/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.oneport;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import org.apache.activeio.AcceptListener;
import org.apache.activeio.Channel;
import org.apache.activeio.adapter.AsyncToSyncChannel;
import org.apache.activeio.adapter.SyncToAsyncChannel;
import org.apache.activeio.oneport.ProtocolRecognizer;
import org.apache.activeio.oneport.UnknownRecognizer;
import org.apache.activeio.packet.AppendedPacket;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.AsyncChannelListener;
import org.apache.activeio.packet.async.AsyncChannelServer;
import org.apache.activeio.packet.async.FilterAsyncChannel;
import org.apache.activeio.packet.async.FilterAsyncChannelServer;
import org.apache.activeio.packet.sync.SyncChannel;
import org.apache.activeio.packet.sync.filter.PushbackSyncChannel;

public final class OnePortAsyncChannelServer
extends FilterAsyncChannelServer {
    private final ConcurrentHashMap recognizerMap = new ConcurrentHashMap();

    public OnePortAsyncChannelServer(AsyncChannelServer server) throws IOException {
        super(server);
        super.setAcceptListener(new OnePortAcceptListener());
    }

    public void setAcceptListener(AcceptListener acceptListener) {
        throw new IllegalAccessError("Not supported");
    }

    public AsyncChannelServer bindAsyncChannel(ProtocolRecognizer recognizer) throws IOException {
        if (this.recognizerMap.contains((Object)recognizer)) {
            throw new IOException("That recognizer is allredy bound.");
        }
        SubPortAsyncChannelServer server = new SubPortAsyncChannelServer(recognizer);
        Object old = this.recognizerMap.put((Object)recognizer, (Object)server);
        return server;
    }

    private final class SubPortAsyncChannelServer
    implements AsyncChannelServer {
        private final ProtocolRecognizer recognizer;
        private AcceptListener acceptListener;
        private boolean started;

        public SubPortAsyncChannelServer(ProtocolRecognizer recognizer) {
            this.recognizer = recognizer;
        }

        public void setAcceptListener(AcceptListener acceptListener) {
            this.acceptListener = acceptListener;
        }

        public URI getBindURI() {
            return OnePortAsyncChannelServer.this.next.getBindURI();
        }

        public URI getConnectURI() {
            return OnePortAsyncChannelServer.this.next.getConnectURI();
        }

        public void dispose() {
            this.started = false;
            OnePortAsyncChannelServer.this.recognizerMap.remove((Object)this.recognizer);
        }

        public void start() throws IOException {
            this.started = true;
        }

        public void stop() throws IOException {
            this.started = false;
        }

        void onAccept(Channel channel) {
            if (this.started && this.acceptListener != null) {
                this.acceptListener.onAccept(channel);
            } else {
                channel.dispose();
            }
        }

        public Object getAdapter(Class target) {
            if (target.isAssignableFrom(this.getClass())) {
                return this;
            }
            return OnePortAsyncChannelServer.this.getAdapter(target);
        }
    }

    private final class ProtocolInspectingAsyncChannel
    extends FilterAsyncChannel {
        private Packet buffer;

        public ProtocolInspectingAsyncChannel(AsyncChannel next) throws IOException {
            super(next);
            this.setAsyncChannelListener(new AsyncChannelListener(){

                public void onPacket(Packet packet) {
                    if (ProtocolInspectingAsyncChannel.this.buffer == null) {
                        ProtocolInspectingAsyncChannel.this.buffer = packet;
                    } else {
                        ProtocolInspectingAsyncChannel.this.buffer = AppendedPacket.join(ProtocolInspectingAsyncChannel.this.buffer, packet);
                    }
                    ProtocolInspectingAsyncChannel.this.findMagicNumber();
                }

                public void onPacketError(IOException error) {
                    ProtocolInspectingAsyncChannel.this.dispose();
                }
            });
        }

        private void findMagicNumber() {
            Iterator iter = OnePortAsyncChannelServer.this.recognizerMap.keySet().iterator();
            while (iter.hasNext()) {
                SubPortAsyncChannelServer onePort;
                ProtocolRecognizer recognizer = (ProtocolRecognizer)iter.next();
                if (!recognizer.recognizes(this.buffer.duplicate())) continue;
                if (UnknownRecognizer.UNKNOWN_RECOGNIZER == recognizer) {
                    this.dispose();
                }
                if ((onePort = (SubPortAsyncChannelServer)OnePortAsyncChannelServer.this.recognizerMap.get((Object)recognizer)) == null) {
                    this.dispose();
                }
                try {
                    this.stop();
                    this.setAsyncChannelListener(null);
                }
                catch (IOException e) {
                    this.getAsyncChannelListener().onPacketError(e);
                }
                Channel channel = this.getNext();
                channel = AsyncToSyncChannel.adapt(channel);
                channel = new PushbackSyncChannel((SyncChannel)channel, this.buffer);
                channel = SyncToAsyncChannel.adapt(channel);
                onePort.onAccept(channel);
                break;
            }
        }
    }

    private final class OnePortAcceptListener
    implements AcceptListener {
        private OnePortAcceptListener() {
        }

        public void onAccept(Channel channel) {
            try {
                AsyncChannel asyncChannel = SyncToAsyncChannel.adapt(channel);
                ProtocolInspectingAsyncChannel inspector = new ProtocolInspectingAsyncChannel(asyncChannel);
                inspector.start();
            }
            catch (IOException e) {
                this.onAcceptError(e);
            }
        }

        public void onAcceptError(IOException error) {
            OnePortAsyncChannelServer.this.dispose();
        }
    }
}

