/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import org.apache.activeio.packet.ByteSequence;
import org.apache.activeio.packet.Packet;

public final class ByteBufferPacket
implements Packet {
    public static final int DEFAULT_BUFFER_SIZE = Integer.parseInt(System.getProperty("org.apache.activeio.DefaultByteBufferSize", "65536"));
    public static final int DEFAULT_DIRECT_BUFFER_SIZE = Integer.parseInt(System.getProperty("org.apache.activeio.DefaultDirectByteBufferSize", "8192"));
    private final ByteBuffer buffer;
    private static final int TEMP_BUFFER_SIZE = 65536;

    public ByteBufferPacket(ByteBuffer buffer) {
        this.buffer = buffer;
        this.clear();
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public static ByteBufferPacket createDefaultBuffer(boolean direct) {
        if (direct) {
            return new ByteBufferPacket(ByteBuffer.allocateDirect(DEFAULT_DIRECT_BUFFER_SIZE));
        }
        return new ByteBufferPacket(ByteBuffer.allocate(DEFAULT_BUFFER_SIZE));
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.buffer.hasArray()) {
            out.write(this.buffer.array(), this.position(), this.remaining());
            this.position(this.limit());
        } else {
            byte[] temp = new byte[65536];
            while (this.buffer.hasRemaining()) {
                int maxWrite = this.buffer.remaining() > temp.length ? temp.length : this.buffer.remaining();
                this.buffer.get(temp, 0, maxWrite);
                out.write(temp, 0, maxWrite);
            }
        }
    }

    public void writeTo(DataOutput out) throws IOException {
        if (this.buffer.hasArray()) {
            out.write(this.buffer.array(), this.position(), this.remaining());
            this.position(this.limit());
        } else {
            byte[] temp = new byte[65536];
            while (this.buffer.hasRemaining()) {
                int maxWrite = this.buffer.remaining() > temp.length ? temp.length : this.buffer.remaining();
                this.buffer.get(temp, 0, maxWrite);
                out.write(temp, 0, maxWrite);
            }
        }
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public void clear() {
        this.buffer.clear();
    }

    public Packet compact() {
        this.buffer.compact();
        return this;
    }

    public void flip() {
        this.buffer.flip();
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    public int limit() {
        return this.buffer.limit();
    }

    public void limit(int arg0) {
        this.buffer.limit(arg0);
    }

    public Packet mark() {
        this.buffer.mark();
        return this;
    }

    public int position() {
        return this.buffer.position();
    }

    public void position(int arg0) {
        this.buffer.position(arg0);
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public void rewind() {
        this.buffer.rewind();
    }

    public Packet slice() {
        return new ByteBufferPacket(this.buffer.slice());
    }

    public Packet duplicate() {
        return new ByteBufferPacket(this.buffer.duplicate());
    }

    public Object duplicate(ClassLoader cl) throws IOException {
        try {
            Class<?> clazz = cl.loadClass(ByteBufferPacket.class.getName());
            Constructor<?> constructor = clazz.getConstructor(ByteBuffer.class);
            return constructor.newInstance(this.buffer.duplicate());
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Could not duplicate packet in a different classloader: " + e).initCause(e);
        }
    }

    public int read() {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    public int read(byte[] data, int offset, int length) {
        if (!this.hasRemaining()) {
            return -1;
        }
        int copyLength = Math.min(length, this.remaining());
        this.buffer.get(data, offset, copyLength);
        return copyLength;
    }

    public boolean write(int data) {
        if (!this.buffer.hasRemaining()) {
            return false;
        }
        this.buffer.put((byte)data);
        return true;
    }

    public int write(byte[] data, int offset, int length) {
        if (!this.hasRemaining()) {
            return -1;
        }
        int copyLength = Math.min(length, this.remaining());
        this.buffer.put(data, offset, copyLength);
        return copyLength;
    }

    public ByteSequence asByteSequence() {
        if (this.buffer.hasArray()) {
            byte[] bs = this.buffer.array();
            return new ByteSequence(bs, this.buffer.position(), this.buffer.remaining());
        }
        return null;
    }

    public byte[] sliceAsBytes() {
        return null;
    }

    public int read(Packet dest) {
        int rc = Math.min(dest.remaining(), this.remaining());
        if (rc > 0) {
            if (dest.getClass() == ByteBufferPacket.class) {
                int limit = this.limit();
                this.limit(this.position() + rc);
                ((ByteBufferPacket)dest).buffer.put(this.buffer);
                this.limit(limit);
                return 0;
            }
            ByteSequence sequence = dest.asByteSequence();
            rc = this.read(sequence.getData(), sequence.getOffset(), sequence.getLength());
            dest.position(dest.position() + rc);
        }
        return rc;
    }

    public String toString() {
        return "{position=" + this.position() + ",limit=" + this.limit() + ",capacity=" + this.capacity() + "}";
    }

    public Object getAdapter(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public void dispose() {
    }
}

