/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.async;

import java.io.IOException;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.AsyncChannelListener;

public class FilterAsyncChannel
implements AsyncChannel,
AsyncChannelListener {
    protected final AsyncChannel next;
    protected AsyncChannelListener channelListener;

    public FilterAsyncChannel(AsyncChannel next) {
        this.next = next;
    }

    public void setAsyncChannelListener(AsyncChannelListener channelListener) {
        this.channelListener = channelListener;
        if (channelListener == null) {
            this.next.setAsyncChannelListener(null);
        } else {
            this.next.setAsyncChannelListener(this);
        }
    }

    public void write(Packet packet) throws IOException {
        this.next.write(packet);
    }

    public void flush() throws IOException {
        this.next.flush();
    }

    public void dispose() {
        this.next.dispose();
    }

    public void start() throws IOException {
        if (this.next == null) {
            throw new IOException("The next channel has not been set.");
        }
        if (this.channelListener == null) {
            throw new IOException("The UpPacketListener has not been set.");
        }
        this.next.start();
    }

    public void stop() throws IOException {
        this.next.stop();
    }

    public void onPacket(Packet packet) {
        this.channelListener.onPacket(packet);
    }

    public void onPacketError(IOException error) {
        this.channelListener.onPacketError(error);
    }

    public AsyncChannel getNext() {
        return this.next;
    }

    public AsyncChannelListener getAsyncChannelListener() {
        return this.channelListener;
    }

    public Object getAdapter(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.next.getAdapter(target);
    }

    public String toString() {
        return this.next.toString();
    }
}

