/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.async;

import java.io.IOException;
import java.net.URI;
import org.apache.activeio.AcceptListener;
import org.apache.activeio.Channel;
import org.apache.activeio.packet.async.AsyncChannelServer;

public class FilterAsyncChannelServer
implements AsyncChannelServer,
AcceptListener {
    protected final AsyncChannelServer next;
    protected AcceptListener acceptListener;

    public FilterAsyncChannelServer(AsyncChannelServer next) {
        this.next = next;
        if (next == null) {
            throw new IllegalArgumentException("The next AsyncChannelServer cannot be null.");
        }
    }

    public void setAcceptListener(AcceptListener acceptListener) {
        this.acceptListener = acceptListener;
        if (acceptListener == null) {
            this.next.setAcceptListener(null);
        } else {
            this.next.setAcceptListener(this);
        }
    }

    public void dispose() {
        this.next.dispose();
    }

    public void start() throws IOException {
        if (this.acceptListener == null) {
            throw new IOException("The AcceptListener has not been set.");
        }
        this.next.start();
    }

    public void stop() throws IOException {
        this.next.stop();
    }

    public void onAccept(Channel channel) {
        this.acceptListener.onAccept(channel);
    }

    public void onAcceptError(IOException error) {
        this.acceptListener.onAcceptError(error);
    }

    public URI getBindURI() {
        return this.next.getBindURI();
    }

    public URI getConnectURI() {
        return this.next.getConnectURI();
    }

    public Object getAdapter(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.next.getAdapter(target);
    }

    public String toString() {
        return this.next.toString();
    }
}

