/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.async.filter;

import java.io.IOException;
import org.apache.activeio.packet.Packet;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.FilterAsyncChannel;

public final class CounterAsyncChannel
extends FilterAsyncChannel {
    long inBoundCounter = 0L;
    long outBoundCounter = 0L;

    public CounterAsyncChannel(AsyncChannel next) {
        super(next);
    }

    public void onPacket(Packet packet) {
        this.inBoundCounter += (long)packet.remaining();
        super.onPacket(packet);
    }

    public void write(Packet packet) throws IOException {
        this.outBoundCounter += (long)packet.position();
        super.write(packet);
    }

    public long getInBoundCounter() {
        return this.inBoundCounter;
    }

    public long getOutBoundCounter() {
        return this.outBoundCounter;
    }
}

