/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.async.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.apache.activeio.adapter.SyncToAsyncChannelServer;
import org.apache.activeio.packet.ByteBufferPacket;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.AsyncChannelFactory;
import org.apache.activeio.packet.async.AsyncChannelServer;
import org.apache.activeio.packet.async.filter.WriteBufferedAsyncChannel;
import org.apache.activeio.packet.async.nio.NIOAsyncChannel;
import org.apache.activeio.packet.async.nio.NIOAsyncChannelServer;
import org.apache.activeio.util.URISupport;

public class NIOAsyncChannelFactory
implements AsyncChannelFactory {
    protected static final int DEFAULT_BUFFER_SIZE = Integer.parseInt(System.getProperty("org.apache.activeio.net.nio.BufferSize", "65536"));
    protected static final int DEFAULT_BACKLOG = 500;
    boolean useDirectBuffers = true;
    private final boolean createWriteBufferedChannels;
    private int backlog = 500;

    public NIOAsyncChannelFactory() {
        this(true);
    }

    public NIOAsyncChannelFactory(boolean createWriteBufferedChannels) {
        this.createWriteBufferedChannels = createWriteBufferedChannels;
    }

    public AsyncChannel openAsyncChannel(URI location) throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.connect(new InetSocketAddress(location.getHost(), location.getPort()));
        return this.createAsyncChannel(channel);
    }

    protected AsyncChannel createAsyncChannel(SocketChannel socketChannel) throws IOException {
        AsyncChannel channel = new NIOAsyncChannel(socketChannel, this.useDirectBuffers);
        if (this.createWriteBufferedChannels) {
            channel = new WriteBufferedAsyncChannel(channel, ByteBufferPacket.createDefaultBuffer(this.useDirectBuffers), false);
        }
        return channel;
    }

    public AsyncChannelServer bindAsyncChannel(URI bindURI) throws IOException {
        String host = bindURI.getHost();
        InetSocketAddress address = host == null || host.length() == 0 || host.equals("localhost") || host.equals("0.0.0.0") || InetAddress.getLocalHost().getHostName().equals(host) ? new InetSocketAddress(bindURI.getPort()) : new InetSocketAddress(bindURI.getHost(), bindURI.getPort());
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.socket().bind(address, this.backlog);
        URI connectURI = bindURI;
        try {
            connectURI = URISupport.changePort(connectURI, serverSocketChannel.socket().getLocalPort());
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException("Could not build connect URI: " + e).initCause(e);
        }
        return SyncToAsyncChannelServer.adapt(new NIOAsyncChannelServer(serverSocketChannel, bindURI, connectURI, this.createWriteBufferedChannels, this.useDirectBuffers));
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }
}

