/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.async.nio;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.ServerSocketChannel;
import org.apache.activeio.Channel;
import org.apache.activeio.packet.ByteBufferPacket;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.filter.WriteBufferedAsyncChannel;
import org.apache.activeio.packet.async.nio.NIOAsyncChannel;
import org.apache.activeio.packet.sync.socket.SocketSyncChannelServer;
import org.apache.activeio.stream.sync.socket.SocketStreamChannel;

public class NIOAsyncChannelServer
extends SocketSyncChannelServer {
    private final boolean createWriteBufferedChannels;
    private final boolean useDirectBuffers;

    public NIOAsyncChannelServer(ServerSocketChannel socketChannel, URI bindURI, URI connectURI, boolean createWriteBufferedChannels, boolean useDirectBuffers) {
        super(socketChannel.socket(), bindURI, connectURI);
        this.createWriteBufferedChannels = createWriteBufferedChannels;
        this.useDirectBuffers = useDirectBuffers;
    }

    protected Channel createChannel(SocketStreamChannel c) throws IOException {
        AsyncChannel channel = new NIOAsyncChannel(c.getSocket().getChannel(), this.useDirectBuffers);
        if (this.createWriteBufferedChannels) {
            channel = new WriteBufferedAsyncChannel(channel, ByteBufferPacket.createDefaultBuffer(this.useDirectBuffers), false);
        }
        return channel;
    }
}

