/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.async.vmpipe;

import java.io.IOException;
import java.net.URI;
import org.apache.activeio.AcceptListener;
import org.apache.activeio.packet.async.AsyncChannel;
import org.apache.activeio.packet.async.AsyncChannelServer;
import org.apache.activeio.packet.async.vmpipe.VMPipeAsyncChannelFactory;
import org.apache.activeio.packet.async.vmpipe.VMPipeAsyncChannelPipe;

public final class VMPipeAsyncChannelServer
implements AsyncChannelServer {
    private final URI bindURI;
    private final URI connectURI;
    private AcceptListener acceptListener;
    private boolean disposed;

    public VMPipeAsyncChannelServer(URI bindURI) {
        this.bindURI = this.connectURI = bindURI;
    }

    public URI getBindURI() {
        return this.bindURI;
    }

    public URI getConnectURI() {
        return this.connectURI;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        VMPipeAsyncChannelFactory.unbindServer(this.bindURI);
        this.disposed = true;
    }

    public void start() throws IOException {
        if (this.acceptListener == null) {
            throw new IOException("acceptListener has not been set.");
        }
    }

    public void stop() {
    }

    public Object getAdapter(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public String toString() {
        return "VM Pipe Server: " + this.getConnectURI();
    }

    public void setAcceptListener(AcceptListener acceptListener) {
        this.acceptListener = acceptListener;
    }

    public AsyncChannel connect() {
        VMPipeAsyncChannelPipe pipe = new VMPipeAsyncChannelPipe();
        this.acceptListener.onAccept(pipe.getRightAsyncChannel());
        return pipe.getLeftAsyncChannel();
    }
}

