/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet.sync.socket;

import java.io.IOException;
import java.net.URI;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.apache.activeio.packet.sync.SyncChannel;
import org.apache.activeio.packet.sync.SyncChannelFactory;
import org.apache.activeio.packet.sync.SyncChannelServer;
import org.apache.activeio.packet.sync.socket.SocketSyncChannel;
import org.apache.activeio.packet.sync.socket.SocketSyncChannelServer;
import org.apache.activeio.stream.sync.StreamChannelServer;
import org.apache.activeio.stream.sync.socket.SocketStreamChannel;
import org.apache.activeio.stream.sync.socket.SocketStreamChannelFactory;
import org.apache.activeio.stream.sync.socket.SocketStreamChannelServer;

public class SocketSyncChannelFactory
implements SyncChannelFactory {
    SocketStreamChannelFactory factory;

    public SocketSyncChannelFactory() {
        this(SocketFactory.getDefault(), ServerSocketFactory.getDefault());
    }

    public SocketSyncChannelFactory(SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        this.factory = new SocketStreamChannelFactory(socketFactory, serverSocketFactory);
    }

    public SyncChannel openSyncChannel(URI location) throws IOException {
        SocketStreamChannel channel = (SocketStreamChannel)this.factory.openStreamChannel(location);
        return this.createSynchChannel(channel);
    }

    protected SyncChannel createSynchChannel(SocketStreamChannel channel) throws IOException {
        return new SocketSyncChannel(channel);
    }

    public SyncChannelServer bindSyncChannel(URI bindURI) throws IOException {
        StreamChannelServer server = this.factory.bindStreamChannel(bindURI);
        return new SocketSyncChannelServer((SocketStreamChannelServer)server);
    }

    public int getBacklog() {
        return this.factory.getBacklog();
    }

    public void setBacklog(int backlog) {
        this.factory.setBacklog(backlog);
    }
}

