/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.stream.sync.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.apache.activeio.stream.sync.StreamChannel;
import org.apache.activeio.stream.sync.StreamChannelFactory;
import org.apache.activeio.stream.sync.StreamChannelServer;
import org.apache.activeio.stream.sync.socket.SocketStreamChannel;
import org.apache.activeio.stream.sync.socket.SocketStreamChannelServer;
import org.apache.activeio.util.URISupport;

public class SocketStreamChannelFactory
implements StreamChannelFactory {
    protected static final int DEFAULT_BACKLOG = 500;
    private final SocketFactory socketFactory;
    private final ServerSocketFactory serverSocketFactory;
    private int backlog = 500;

    public SocketStreamChannelFactory() {
        this(SocketFactory.getDefault(), ServerSocketFactory.getDefault());
    }

    public SocketStreamChannelFactory(SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        this.socketFactory = socketFactory;
        this.serverSocketFactory = serverSocketFactory;
    }

    public StreamChannel openStreamChannel(URI location) throws IOException {
        Socket socket = null;
        String path = location.getPath();
        if (path != null && path.length() > 0) {
            if (path.indexOf(47) == 0) {
                path = path.substring(1, path.length());
            }
            int localPortIndex = path.indexOf(58);
            try {
                int localPort = Integer.parseInt(path.substring(localPortIndex + 1, path.length()));
                InetAddress localAddress = InetAddress.getByName(path);
                socket = this.socketFactory.createSocket(location.getHost(), location.getPort(), localAddress, localPort);
            }
            catch (Exception e) {
                System.err.println("Could not define local address and port from path: " + path);
                e.printStackTrace();
            }
        }
        if (socket == null) {
            socket = this.socketFactory.createSocket(location.getHost(), location.getPort());
        }
        return this.createStreamChannel(socket);
    }

    protected StreamChannel createStreamChannel(Socket socket) throws IOException {
        return new SocketStreamChannel(socket);
    }

    public StreamChannelServer bindStreamChannel(URI bindURI) throws IOException {
        String host = bindURI.getHost();
        InetAddress addr = host == null || host.length() == 0 || host.equals("localhost") || host.equals("0.0.0.0") || InetAddress.getLocalHost().getHostName().equals(host) ? InetAddress.getLocalHost() : InetAddress.getByName(host);
        ServerSocket serverSocket = addr.equals(InetAddress.getLocalHost()) ? this.serverSocketFactory.createServerSocket(bindURI.getPort(), this.backlog) : this.serverSocketFactory.createServerSocket(bindURI.getPort(), this.backlog, addr);
        URI connectURI = bindURI;
        try {
            connectURI = URISupport.changePort(connectURI, serverSocket.getLocalPort());
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException("Could build connect URI: " + e).initCause(e);
        }
        return new SocketStreamChannelServer(serverSocket, bindURI, connectURI);
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }
}

