/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.xnet;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.activeio.adapter.SyncChannelToSocket;
import org.apache.activeio.packet.sync.SyncChannel;
import org.apache.activeio.packet.sync.SyncChannelServer;
import org.apache.activeio.packet.sync.socket.SocketSyncChannelFactory;
import org.apache.activeio.xnet.ServiceException;
import org.apache.activeio.xnet.SocketService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SyncChannelServerDaemon
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)SyncChannelServerDaemon.class);
    private final SocketService socketService;
    private InetAddress address;
    private int port;
    private int timeout;
    private String name;
    private URI bindURI;
    private SyncChannelServer server;
    private boolean stopped;

    public SyncChannelServerDaemon(SocketService socketService, InetAddress address, int port) {
        this(null, socketService, address, port);
    }

    public SyncChannelServerDaemon(String name, SocketService socketService, InetAddress address, int port) {
        this.name = name;
        if (socketService == null) {
            throw new IllegalArgumentException("socketService is null");
        }
        this.socketService = socketService;
        this.address = address;
        this.port = port;
        try {
            this.bindURI = new URI("uri", null, address.getHostName(), port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
        }
    }

    public void doStart() throws Exception {
        SocketSyncChannelFactory factory = new SocketSyncChannelFactory();
        this.server = null;
        try {
            this.server = factory.bindSyncChannel(this.bindURI);
            this.port = this.server.getConnectURI().getPort();
            this.address = InetAddress.getByName(this.server.getConnectURI().getHost());
            this.stopped = false;
        }
        catch (Exception e) {
            throw new ServiceException("Service failed to open socket", e);
        }
        Thread thread = new Thread(this);
        thread.setName("service." + this.name + "@" + this.hashCode());
        thread.setDaemon(true);
        thread.start();
    }

    public synchronized void doStop() {
        this.stopped = true;
    }

    public synchronized void doFail() throws IOException {
        this.doStop();
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
    }

    public int getSoTimeout() throws IOException {
        return this.timeout;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.shouldStop()) {
            SyncChannelToSocket socket = null;
            try {
                SyncChannel channel = (SyncChannel)this.server.accept(this.timeout);
                socket = new SyncChannelToSocket(channel);
                ((Socket)socket).setTcpNoDelay(true);
                if (this.shouldStop()) continue;
                this.socketService.service(socket);
            }
            catch (SocketTimeoutException e) {
                log.debug((Object)"Socket timed-out", (Throwable)e);
            }
            catch (Throwable e) {
                log.error((Object)"Unexpected error", e);
            }
            finally {
                log.info((Object)"Processed");
            }
        }
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception ioException) {
                log.debug((Object)"Error cleaning up socked", (Throwable)ioException);
            }
            this.server = null;
        }
    }

    public synchronized void stop() {
        this.stopped = true;
    }

    private synchronized boolean shouldStop() {
        return this.stopped;
    }
}

