/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.benchmark;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.benchmark.BenchmarkSupport;

public class Consumer
extends BenchmarkSupport
implements MessageListener {
    public static void main(String[] args) {
        Consumer tool = new Consumer();
        if (args.length > 0) {
            tool.setUrl(args[0]);
        }
        if (args.length > 1) {
            tool.setTopic(Consumer.parseBoolean(args[1]));
        }
        if (args.length > 2) {
            tool.setSubject(args[2]);
        }
        if (args.length > 3) {
            tool.setDurable(Consumer.parseBoolean(args[3]));
        }
        if (args.length > 4) {
            tool.setConnectionCount(Integer.parseInt(args[4]));
        }
        try {
            tool.run();
        }
        catch (Exception e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
        }
    }

    public void run() throws JMSException {
        this.start();
        this.subscribe();
    }

    protected void subscribe() throws JMSException {
        for (int i = 0; i < this.subjects.length; ++i) {
            this.subscribe(this.subjects[i]);
        }
    }

    protected void subscribe(String subject) throws JMSException {
        Session session = this.createSession();
        Destination destination = this.createDestination(session, subject);
        System.out.println("Consuming on : " + destination + " of type: " + destination.getClass().getName());
        Object consumer = null;
        consumer = this.isDurable() && this.isTopic() ? session.createDurableSubscriber((Topic)destination, this.getClass().getName()) : session.createConsumer(destination);
        consumer.setMessageListener((MessageListener)this);
        this.addResource(consumer);
    }

    public void onMessage(Message message) {
        try {
            TextMessage textMessage = (TextMessage)message;
            String text = textMessage.getText();
            this.count(1);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }
}

