/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.TransportSupport;
import org.apache.activemq.util.ServiceStopper;

public class BlockingQueueTransport
extends TransportSupport {
    public static final long MAX_TIMEOUT = 30000L;
    private BlockingQueue queue;

    public BlockingQueueTransport(BlockingQueue channel) {
        this.queue = channel;
    }

    public BlockingQueue getQueue() {
        return this.queue;
    }

    public void oneway(Command command) throws IOException {
        try {
            boolean success = this.queue.offer((Object)command, 30000L, TimeUnit.MILLISECONDS);
            if (!success) {
                throw new IOException("Fail to add to BlockingQueue. Add timed out after 30000ms: size=" + this.queue.size());
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Fail to add to BlockingQueue. Interrupted while waiting for space: size=" + this.queue.size());
        }
    }

    public String getRemoteAddress() {
        return "blockingQueue";
    }

    protected void doStart() throws Exception {
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
    }
}

