/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.https;

import java.net.URI;
import org.apache.activemq.transport.http.HttpTransportServer;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.security.SslSocketConnector;

public class HttpsTransportServer
extends HttpTransportServer {
    private String keyPassword = System.getProperty("javax.net.ssl.keyPassword");
    private String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
    private String keyStore = System.getProperty("javax.net.ssl.keyStore");
    private String keyStoreType = null;
    private String certificateAlgorithm = null;
    private String protocol = null;

    public HttpsTransportServer(URI uri) {
        super(uri);
    }

    public void doStart() throws Exception {
        SslSocketConnector sslConnector = new SslSocketConnector();
        sslConnector.setKeystore(this.keyStore);
        sslConnector.setPassword(this.keyStorePassword);
        if (this.keyPassword == null) {
            sslConnector.setKeyPassword(this.keyStorePassword);
        }
        if (this.keyStoreType != null) {
            sslConnector.setKeystoreType(this.keyStoreType);
        }
        if (this.certificateAlgorithm != null) {
            sslConnector.setAlgorithm(this.certificateAlgorithm);
        }
        if (this.protocol != null) {
            sslConnector.setProtocol(this.protocol);
        }
        this.setConnector((Connector)sslConnector);
        super.doStart();
    }

    public String getCertificateAlgorithm() {
        return this.certificateAlgorithm;
    }

    public void setCertificateAlgorithm(String certificateAlgorithm) {
        this.certificateAlgorithm = certificateAlgorithm;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

