/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.transport.http.HttpTransportSupport;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.util.Callback;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpTransport
extends HttpTransportSupport {
    private static final Log log = LogFactory.getLog((Class)HttpTransport.class);
    private HttpURLConnection sendConnection;
    private HttpURLConnection receiveConnection;
    private URL url;
    private String clientID;

    public HttpTransport(TextWireFormat wireFormat, URI remoteUrl) throws MalformedURLException {
        super(wireFormat, remoteUrl);
        this.url = new URL(remoteUrl.toString());
    }

    public void oneway(Command command) throws IOException {
        try {
            if (command.getDataStructureType() == 3) {
                boolean startGetThread = this.clientID == null;
                this.clientID = ((ConnectionInfo)command).getClientId();
                if (startGetThread && this.isStarted()) {
                    try {
                        super.doStart();
                    }
                    catch (Exception e) {
                        throw IOExceptionSupport.create((Exception)e);
                    }
                }
            }
            HttpURLConnection connection = this.getSendConnection();
            String text = this.getTextWireFormat().toString(command);
            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
            writer.write(text);
            ((Writer)writer).flush();
            int answer = connection.getResponseCode();
            if (answer != 200) {
                throw new IOException("Failed to post command: " + command + " as response was: " + answer);
            }
        }
        catch (IOException e) {
            throw IOExceptionSupport.create((String)("Could not post command: " + command + " due to: " + e), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.trace((Object)("HTTP GET consumer thread starting for transport: " + (Object)((Object)this)));
        URI remoteUrl = this.getRemoteUrl();
        while (!this.isStopped()) {
            try {
                HttpURLConnection connection = this.getReceiveConnection();
                int answer = connection.getResponseCode();
                if (answer != 200) {
                    if (answer == 408) {
                        log.trace((Object)"GET timed out");
                        continue;
                    }
                    log.warn((Object)("Failed to perform GET on: " + remoteUrl + " as response was: " + answer));
                    continue;
                }
                Command command = this.getTextWireFormat().readCommand(new DataInputStream(connection.getInputStream()));
                if (command == null) {
                    log.warn((Object)("Received null packet from url: " + remoteUrl));
                    continue;
                }
                this.doConsume(command);
            }
            catch (Throwable e) {
                if (!this.isStopped()) {
                    log.error((Object)("Failed to perform GET on: " + remoteUrl + " due to: " + e), e);
                    continue;
                }
                log.trace((Object)("Caught error after closed: " + e), e);
            }
            finally {
                this.safeClose(this.receiveConnection);
                this.receiveConnection = null;
            }
        }
    }

    protected HttpURLConnection createSendConnection() throws IOException {
        HttpURLConnection conn = (HttpURLConnection)this.getRemoteURL().openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        this.configureConnection(conn);
        conn.connect();
        return conn;
    }

    protected HttpURLConnection createReceiveConnection() throws IOException {
        HttpURLConnection conn = (HttpURLConnection)this.getRemoteURL().openConnection();
        conn.setDoOutput(false);
        conn.setDoInput(true);
        conn.setRequestMethod("GET");
        this.configureConnection(conn);
        conn.connect();
        return conn;
    }

    protected void configureConnection(HttpURLConnection connection) {
        if (this.clientID != null) {
            connection.setRequestProperty("clientID", this.clientID);
        }
    }

    protected URL getRemoteURL() {
        return this.url;
    }

    protected HttpURLConnection getSendConnection() throws IOException {
        this.setSendConnection(this.createSendConnection());
        return this.sendConnection;
    }

    protected HttpURLConnection getReceiveConnection() throws IOException {
        this.setReceiveConnection(this.createReceiveConnection());
        return this.receiveConnection;
    }

    protected void setSendConnection(HttpURLConnection conn) {
        this.safeClose(this.sendConnection);
        this.sendConnection = conn;
    }

    protected void setReceiveConnection(HttpURLConnection conn) {
        this.safeClose(this.receiveConnection);
        this.receiveConnection = conn;
    }

    protected void doStart() throws Exception {
        if (this.clientID != null) {
            super.doStart();
        }
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        stopper.run(new Callback(){

            public void execute() throws Exception {
                HttpTransport.this.safeClose(HttpTransport.this.sendConnection);
            }
        });
        this.sendConnection = null;
        stopper.run(new Callback(){

            public void execute() {
                HttpTransport.this.safeClose(HttpTransport.this.receiveConnection);
            }
        });
    }

    private void safeClose(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }
}

