/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.xstream;

import com.thoughtworks.xstream.XStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import javax.jms.JMSException;
import org.apache.activeio.command.WireFormat;
import org.apache.activeio.packet.Packet;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.util.TextWireFormat;

public class XStreamWireFormat
extends TextWireFormat {
    private XStream xStream;
    private int version;

    public void marshal(Object command, DataOutputStream out) throws IOException {
        String text = this.getXStream().toXML(command);
        out.writeUTF(text);
    }

    public Packet marshal(Object command) throws IOException {
        return null;
    }

    public Object unmarshal(DataInputStream arg0) throws IOException {
        return null;
    }

    public Object unmarshal(Packet arg0) throws IOException {
        return null;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Packet readPacket(DataInput in) throws IOException {
        String text = in.readUTF();
        return (Packet)this.getXStream().fromXML(text);
    }

    public Packet readPacket(int firstByte, DataInput in) throws IOException {
        String text = in.readUTF();
        return (Packet)this.getXStream().fromXML(text);
    }

    public Packet writePacket(Packet packet, DataOutput out) throws IOException, JMSException {
        String text = this.getXStream().toXML((Object)packet);
        out.writeUTF(text);
        return null;
    }

    public WireFormat copy() {
        return new XStreamWireFormat();
    }

    public String toString(Packet packet) {
        return this.getXStream().toXML((Object)packet);
    }

    public Packet fromString(String xml) {
        return (Packet)this.getXStream().fromXML(xml);
    }

    public Command readCommand(String text) {
        return (Command)this.getXStream().fromXML(text);
    }

    public Command readCommand(Reader reader) {
        return (Command)this.getXStream().fromXML(reader);
    }

    public String toString(Command command) {
        return this.getXStream().toXML((Object)command);
    }

    public boolean canProcessWireFormatVersion(int version) {
        return true;
    }

    public int getCurrentWireFormatVersion() {
        return 1;
    }

    public XStream getXStream() {
        if (this.xStream == null) {
            this.xStream = this.createXStream();
        }
        return this.xStream;
    }

    public void setXStream(XStream xStream) {
        this.xStream = xStream;
    }

    protected XStream createXStream() {
        return new XStream();
    }
}

