/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web.controller;

import java.util.Iterator;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.web.DestinationFacade;
import org.apache.activemq.web.WebClient;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class SendMessage
extends DestinationFacade
implements Controller {
    private String JMSText;
    private boolean JMSPersistent;
    private int JMSPriority;
    private int JMSTimeToLive = -1;
    private String JMSCorrelationID;
    private String JMSReplyTo;
    private String JMSType;
    private int JMSMessageCount = 1;
    private String JMSMessageCountHeader = "JMSXMessageNumber";
    private boolean redirectToBrowse;

    public SendMessage(BrokerService brokerService) {
        super(brokerService);
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebClient client = WebClient.getWebClient((HttpServletRequest)request);
        ActiveMQDestination dest = this.createDestination();
        this.sendMessages(request, client, dest);
        if (this.redirectToBrowse && this.isQueue()) {
            return new ModelAndView("redirect:browse.jsp?destination=" + this.getJMSDestination());
        }
        return this.redirectToBrowseView();
    }

    protected void sendMessages(HttpServletRequest request, WebClient client, ActiveMQDestination dest) throws JMSException {
        if (this.JMSMessageCount <= 1) {
            this.JMSMessageCount = 1;
        }
        for (int i = 0; i < this.JMSMessageCount; ++i) {
            Message message = this.createMessage(client, request);
            this.appendHeaders(message, request);
            if (this.JMSMessageCount > 1) {
                message.setIntProperty(this.JMSMessageCountHeader, i + 1);
            }
            client.send((Destination)dest, message, this.JMSPersistent, this.JMSPriority, this.JMSTimeToLive);
            System.out.println("Sent message: " + message);
        }
    }

    public String getJMSCorrelationID() {
        return this.JMSCorrelationID;
    }

    public void setJMSCorrelationID(String correlationID) {
        this.JMSCorrelationID = correlationID;
    }

    public String getJMSReplyTo() {
        return this.JMSReplyTo;
    }

    public void setJMSReplyTo(String replyTo) {
        this.JMSReplyTo = replyTo;
    }

    public String getJMSType() {
        return this.JMSType;
    }

    public void setJMSType(String type) {
        this.JMSType = type;
    }

    public boolean isJMSPersistent() {
        return this.JMSPersistent;
    }

    public void setJMSPersistent(boolean persistent) {
        this.JMSPersistent = persistent;
    }

    public int getJMSPriority() {
        return this.JMSPriority;
    }

    public void setJMSPriority(int priority) {
        this.JMSPriority = priority;
    }

    public String getJMSText() {
        return this.JMSText;
    }

    public void setJMSText(String text) {
        this.JMSText = text;
    }

    public int getJMSTimeToLive() {
        return this.JMSTimeToLive;
    }

    public void setJMSTimeToLive(int timeToLive) {
        this.JMSTimeToLive = timeToLive;
    }

    public int getJMSMessageCount() {
        return this.JMSMessageCount;
    }

    public void setJMSMessageCount(int copies) {
        this.JMSMessageCount = copies;
    }

    public String getJMSMessageCountHeader() {
        return this.JMSMessageCountHeader;
    }

    public void setJMSMessageCountHeader(String messageCountHeader) {
        this.JMSMessageCountHeader = messageCountHeader;
    }

    protected Message createMessage(WebClient client, HttpServletRequest request) throws JMSException {
        if (this.JMSText != null) {
            return client.getSession().createTextMessage(this.JMSText);
        }
        return client.getSession().createMessage();
    }

    protected void appendHeaders(Message message, HttpServletRequest request) throws JMSException {
        message.setJMSCorrelationID(this.JMSCorrelationID);
        if (this.JMSReplyTo != null && this.JMSReplyTo.trim().length() > 0) {
            message.setJMSReplyTo((Destination)ActiveMQDestination.createDestination((String)this.JMSReplyTo, (byte)1));
        }
        message.setJMSType(this.JMSType);
        Map map = request.getParameterMap();
        if (map != null) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (!this.isValidPropertyName(name)) continue;
                if (value instanceof String[]) {
                    String[] array = (String[])value;
                    value = array.length > 0 ? array[0] : null;
                }
                if (value instanceof String) {
                    String text = value.toString().trim();
                    value = text.length() == 0 ? null : text;
                }
                if (value == null) continue;
                message.setObjectProperty(name, value);
            }
        }
    }

    protected boolean isValidPropertyName(String name) {
        return name.startsWith("JMSX") || !name.startsWith("JMS");
    }
}

