/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.web.DestinationFacade;
import org.apache.activemq.web.SessionPool;
import org.springframework.beans.factory.DisposableBean;

public class QueueBrowseQuery
extends DestinationFacade
implements DisposableBean {
    private SessionPool sessionPool;
    private String selector;
    private Session session;
    private Queue queue;
    private QueueBrowser browser;

    public QueueBrowseQuery(BrokerService brokerService, SessionPool sessionPool) throws JMSException {
        super(brokerService);
        this.sessionPool = sessionPool;
        this.session = sessionPool.borrowSession();
        this.setJMSDestinationType("query");
    }

    public void destroy() throws Exception {
        if (this.browser != null) {
            this.browser.close();
        }
        this.sessionPool.returnSession(this.session);
        this.session = null;
    }

    public QueueBrowser getBrowser() throws JMSException {
        if (this.browser == null) {
            this.browser = this.createBrowser();
        }
        return this.browser;
    }

    public void setBrowser(QueueBrowser browser) {
        this.browser = browser;
    }

    public Queue getQueue() throws JMSException {
        if (this.queue == null) {
            this.queue = this.session.createQueue(this.getValidDestination());
        }
        return this.queue;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isQueue() {
        return true;
    }

    protected QueueBrowser createBrowser() throws JMSException {
        return this.getSession().createBrowser(this.getQueue(), this.getSelector());
    }
}

