/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import javax.servlet.http.HttpServletRequest;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.web.BrokerFacade;
import org.springframework.web.servlet.ModelAndView;

public class DestinationFacade
extends BrokerFacade {
    private String JMSDestination;
    private String JMSDestinationType;

    public DestinationFacade(BrokerService brokerService) {
        super(brokerService);
    }

    public String toString() {
        return super.toString() + "[destination:" + this.JMSDestination + "; type=" + this.JMSDestinationType + "]";
    }

    public void removeDestination() throws Exception {
        this.getValidDestination();
        if (this.isQueue()) {
            this.getBrokerAdmin().removeQueue(this.getJMSDestination());
        } else {
            this.getBrokerAdmin().removeTopic(this.getJMSDestination());
        }
    }

    public void addDestination() throws Exception {
        if (this.isQueue()) {
            this.getBrokerAdmin().addQueue(this.getValidDestination());
        } else {
            this.getBrokerAdmin().addTopic(this.getValidDestination());
        }
    }

    public boolean isQueue() {
        return this.JMSDestinationType == null || !this.JMSDestinationType.equalsIgnoreCase("topic");
    }

    public String getJMSDestination() {
        return this.JMSDestination;
    }

    public void setJMSDestination(String destination) {
        this.JMSDestination = destination;
    }

    public String getJMSDestinationType() {
        return this.JMSDestinationType;
    }

    public void setJMSDestinationType(String type) {
        this.JMSDestinationType = type;
    }

    protected ActiveMQDestination createDestination() {
        if (this.isQueue()) {
            return new ActiveMQQueue(this.getValidDestination());
        }
        return new ActiveMQTopic(this.getValidDestination());
    }

    protected String getValidDestination() {
        if (this.JMSDestination == null) {
            throw new IllegalArgumentException("No JMSDestination parameter specified");
        }
        return this.JMSDestination;
    }

    protected ModelAndView redirectToRequest(HttpServletRequest request) {
        String view = "redirect:" + request.getRequestURI();
        System.out.println("Redirecting to: " + view);
        return new ModelAndView(view);
    }

    protected ModelAndView redirectToBrowseView() {
        return new ModelAndView("redirect:" + (this.isQueue() ? "queues.jsp" : "topics.jsp"));
    }
}

