/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.util.LinkedList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;

public class SessionPool {
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private LinkedList sessions = new LinkedList();

    public Connection getConnection() throws JMSException {
        if (this.connection == null) {
            this.connection = this.getConnectionFactory().createConnection();
            this.connection.start();
        }
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = new ActiveMQConnectionFactory("vm://localhost");
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session borrowSession() throws JMSException {
        Session answer = null;
        LinkedList linkedList = this.sessions;
        synchronized (linkedList) {
            answer = this.sessions.isEmpty() ? this.createSession() : (Session)this.sessions.removeLast();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnSession(Session session) {
        if (session != null) {
            LinkedList linkedList = this.sessions;
            synchronized (linkedList) {
                this.sessions.add(session);
            }
        }
    }

    protected Session createSession() throws JMSException {
        return this.getConnection().createSession(false, 1);
    }
}

