/*
 * Copyright 2005-2006 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.activemq.web;

import javax.servlet.ServletException;

/**
 * 
 * @version $Revision: $
 */
public class NoSuchViewStyleException extends ServletException {

    private static final long serialVersionUID = -3590398087507019767L;
    
    private final String style;

    public NoSuchViewStyleException(String style, Throwable cause) {
        super("The view style '" + style + "' could not be created", cause);
        this.style = style;
    }

    public String getStyle() {
        return style;
    }
}
