/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.activemq.web.MessageServletSupport;
import org.apache.activemq.web.WebClient;

public class PortfolioPublishServlet
extends MessageServletSupport {
    private static final int maxDeltaPercent = 1;
    private static final Map lastPrices = new Hashtable();
    private boolean ricoStyle = true;

    public void init() throws ServletException {
        super.init();
        this.ricoStyle = PortfolioPublishServlet.asBoolean(this.getServletConfig().getInitParameter("rico"), true);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        String[] stocks = request.getParameterValues("stocks");
        if (stocks == null || stocks.length == 0) {
            out.println("<html><body>No <b>stocks</b> query parameter specified. Cannot publish market data</body></html>");
        } else {
            Integer total = (Integer)request.getSession(true).getAttribute("total");
            if (total == null) {
                total = new Integer(0);
            }
            int count = this.getNumberOfMessages(request);
            total = new Integer(total + count);
            request.getSession().setAttribute("total", (Object)total);
            try {
                WebClient client = WebClient.getWebClient(request);
                for (int i = 0; i < count; ++i) {
                    this.sendMessage(client, stocks);
                }
                out.print("<html><head><meta http-equiv='refresh' content='");
                String refreshRate = request.getParameter("refresh");
                if (refreshRate == null || refreshRate.length() == 0) {
                    refreshRate = "1";
                }
                out.print(refreshRate);
                out.println("'/></head>");
                out.println("<body>Published <b>" + count + "</b> of " + total + " price messages.  Refresh = " + refreshRate + "s");
                out.println("</body></html>");
            }
            catch (JMSException e) {
                out.println("<html><body>Failed sending price messages due to <b>" + (Object)((Object)e) + "</b></body></html>");
                this.log("Failed to send message: " + (Object)((Object)e), e);
            }
        }
    }

    protected void sendMessage(WebClient client, String[] stocks) throws JMSException {
        Session session = client.getSession();
        int idx = 0;
        while ((idx = (int)Math.round((double)stocks.length * Math.random())) >= stocks.length) {
        }
        String stock = stocks[idx];
        Topic destination = session.createTopic("STOCKS." + stock);
        String stockText = this.createStockText(stock);
        this.log("Sending: " + stockText + " on destination: " + destination);
        TextMessage message = session.createTextMessage(stockText);
        client.send((Destination)destination, (Message)message);
    }

    protected String createStockText(String stock) {
        Double value = (Double)lastPrices.get(stock);
        if (value == null) {
            value = new Double(Math.random() * 100.0);
        }
        double oldPrice = value;
        value = new Double(this.mutatePrice(oldPrice));
        lastPrices.put(stock, value);
        double price = value;
        double offer = price * 1.001;
        String movement = price > oldPrice ? "up" : "down";
        return "<price stock='" + stock + "' bid='" + price + "' offer='" + offer + "' movement='" + movement + "'/>";
    }

    protected double mutatePrice(double price) {
        double percentChange = 2.0 * Math.random() * 1.0 - 1.0;
        return price * (100.0 + percentChange) / 100.0;
    }

    protected int getNumberOfMessages(HttpServletRequest request) {
        String name = request.getParameter("count");
        if (name != null) {
            return Integer.parseInt(name);
        }
        return 1;
    }
}

