/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.maven;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.FileUtils;

public class BundleMojo
extends AbstractMojo {
    protected File outputDirectory;
    String includes = "";
    MavenProject project;
    protected ArchiverManager archiverManager;

    public void execute() throws MojoExecutionException {
        String[] include = this.includes.split(",");
        List<String> includeList = Arrays.asList(include);
        this.getLog().info((CharSequence)("Inclusions: " + includeList));
        this.getLog().info((CharSequence)("OutputDirectory: " + this.outputDirectory));
        this.outputDirectory.mkdirs();
        Iterator itr = this.project.getArtifacts().iterator();
        while (itr.hasNext()) {
            Artifact a = (Artifact)itr.next();
            if (!includeList.contains(a.getArtifactId()) || !"jar".equals(a.getType())) continue;
            this.getLog().info((CharSequence)("Found " + a.getArtifactId()));
            try {
                this.unpack(a.getFile(), this.outputDirectory);
            }
            catch (MojoExecutionException e) {
                e.printStackTrace();
            }
            catch (NoSuchArchiverException e) {
                e.printStackTrace();
            }
        }
    }

    protected void unpack(File file, File location) throws MojoExecutionException, NoSuchArchiverException {
        String archiveExt = FileUtils.getExtension((String)file.getAbsolutePath()).toLowerCase();
        try {
            this.getLog().info((CharSequence)("Extracting: " + file + ": to " + location));
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(archiveExt);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            unArchiver.extract();
            File metaDir = new File(location, "META-INF");
            File jarMetaDir = new File(metaDir, file.getName());
            FileUtils.mkdir((String)jarMetaDir.getAbsolutePath());
            File[] files = metaDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName();
                if (!name.toUpperCase().startsWith("MANIFEST.MF") && !name.toUpperCase().startsWith("COPYRIGHT") && !name.toUpperCase().startsWith("LICENSE") && !name.toUpperCase().startsWith("NOTICE") && !name.toUpperCase().startsWith("DISCLAIMER")) continue;
                FileUtils.copyFileToDirectory((File)files[i], (File)jarMetaDir);
                files[i].delete();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)((Object)e));
        }
    }
}

