/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.ConfigurationException;
import org.apache.activemq.MessageTransformer;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.blob.BlobTransferPolicy;
import org.apache.activemq.jndi.JNDIBaseStorable;
import org.apache.activemq.management.JMSStatsImpl;
import org.apache.activemq.management.StatsCapable;
import org.apache.activemq.management.StatsImpl;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.activemq.util.URISupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveMQConnectionFactory
extends JNDIBaseStorable
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
StatsCapable,
Cloneable {
    public static final String DEFAULT_BROKER_URL = "tcp://localhost:61616";
    public static final String DEFAULT_USER = null;
    public static final String DEFAULT_PASSWORD = null;
    public static final int DEFAULT_PRODUCER_WINDOW_SIZE = 0;
    protected static final Executor DEFAULT_CONNECTION_EXECUTOR = new ScheduledThreadPoolExecutor(5, new ThreadFactory(){

        public Thread newThread(Runnable run) {
            Thread thread = new Thread(run);
            thread.setPriority(7);
            return thread;
        }
    });
    protected URI brokerURL;
    protected String userName;
    protected String password;
    protected String clientID;
    protected boolean dispatchAsync = true;
    protected boolean alwaysSessionAsync = true;
    JMSStatsImpl factoryStats = new JMSStatsImpl();
    private IdGenerator clientIdGenerator;
    private String clientIDPrefix;
    private ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
    private RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
    private BlobTransferPolicy blobTransferPolicy = new BlobTransferPolicy();
    private MessageTransformer transformer;
    private boolean disableTimeStampsByDefault;
    private boolean optimizedMessageDispatch = true;
    private boolean copyMessageOnSend = true;
    private boolean useCompression;
    private boolean objectMessageSerializationDefered;
    private boolean useAsyncSend;
    private boolean optimizeAcknowledge;
    private int closeTimeout = 15000;
    private boolean useRetroactiveConsumer;
    private boolean exclusiveConsumer;
    private boolean nestedMapAndListEnabled = true;
    private boolean alwaysSyncSend;
    private boolean watchTopicAdvisories = true;
    private int producerWindowSize = 0;
    private long warnAboutUnstartedConnectionTimeout = 500L;
    private int sendTimeout = 0;
    private TransportListener transportListener;

    public ActiveMQConnectionFactory() {
        this(DEFAULT_BROKER_URL);
    }

    public ActiveMQConnectionFactory(String brokerURL) {
        this(ActiveMQConnectionFactory.createURI(brokerURL));
    }

    public ActiveMQConnectionFactory(URI brokerURL) {
        this.setBrokerURL(brokerURL.toString());
    }

    public ActiveMQConnectionFactory(String userName, String password, URI brokerURL) {
        this.setUserName(userName);
        this.setPassword(password);
        this.setBrokerURL(brokerURL.toString());
    }

    public ActiveMQConnectionFactory(String userName, String password, String brokerURL) {
        this.setUserName(userName);
        this.setPassword(password);
        this.setBrokerURL(brokerURL);
    }

    public ActiveMQConnectionFactory copy() {
        try {
            return (ActiveMQConnectionFactory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This should never happen: " + e, e);
        }
    }

    private static URI createURI(String brokerURL) {
        try {
            return new URI(brokerURL);
        }
        catch (URISyntaxException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Invalid broker URI: " + brokerURL).initCause(e);
        }
    }

    @Override
    public Connection createConnection() throws JMSException {
        return this.createActiveMQConnection();
    }

    @Override
    public Connection createConnection(String userName, String password) throws JMSException {
        return this.createActiveMQConnection(userName, password);
    }

    @Override
    public QueueConnection createQueueConnection() throws JMSException {
        return this.createActiveMQConnection();
    }

    @Override
    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return this.createActiveMQConnection(userName, password);
    }

    @Override
    public TopicConnection createTopicConnection() throws JMSException {
        return this.createActiveMQConnection();
    }

    @Override
    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return this.createActiveMQConnection(userName, password);
    }

    @Override
    public StatsImpl getStats() {
        return null;
    }

    protected ActiveMQConnection createActiveMQConnection() throws JMSException {
        return this.createActiveMQConnection(this.userName, this.password);
    }

    protected Transport createTransport() throws JMSException {
        try {
            return TransportFactory.connect(this.brokerURL, DEFAULT_CONNECTION_EXECUTOR);
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create("Could not create Transport. Reason: " + e, e);
        }
    }

    protected ActiveMQConnection createActiveMQConnection(String userName, String password) throws JMSException {
        if (this.brokerURL == null) {
            throw new ConfigurationException("brokerURL not set.");
        }
        ActiveMQConnection connection = null;
        try {
            Transport transport = this.createTransport();
            connection = this.createActiveMQConnection(transport, this.factoryStats);
            connection.setUserName(userName);
            connection.setPassword(password);
            this.configureConnection(connection);
            transport.start();
            if (this.clientID != null) {
                connection.setDefaultClientID(this.clientID);
            }
            return connection;
        }
        catch (JMSException e) {
            try {
                connection.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            throw e;
        }
        catch (Exception e) {
            try {
                connection.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            throw JMSExceptionSupport.create("Could not connect to broker URL: " + this.brokerURL + ". Reason: " + e, e);
        }
    }

    protected ActiveMQConnection createActiveMQConnection(Transport transport, JMSStatsImpl stats) throws Exception {
        ActiveMQConnection connection = new ActiveMQConnection(transport, this.getClientIdGenerator(), stats);
        return connection;
    }

    protected void configureConnection(ActiveMQConnection connection) {
        connection.setPrefetchPolicy(this.getPrefetchPolicy());
        connection.setDisableTimeStampsByDefault(this.isDisableTimeStampsByDefault());
        connection.setOptimizedMessageDispatch(this.isOptimizedMessageDispatch());
        connection.setCopyMessageOnSend(this.isCopyMessageOnSend());
        connection.setUseCompression(this.isUseCompression());
        connection.setObjectMessageSerializationDefered(this.isObjectMessageSerializationDefered());
        connection.setDispatchAsync(this.isDispatchAsync());
        connection.setUseAsyncSend(this.isUseAsyncSend());
        connection.setAlwaysSyncSend(this.isAlwaysSyncSend());
        connection.setAlwaysSessionAsync(this.isAlwaysSessionAsync());
        connection.setOptimizeAcknowledge(this.isOptimizeAcknowledge());
        connection.setUseRetroactiveConsumer(this.isUseRetroactiveConsumer());
        connection.setRedeliveryPolicy(this.getRedeliveryPolicy());
        connection.setTransformer(this.getTransformer());
        connection.setBlobTransferPolicy(this.getBlobTransferPolicy().copy());
        connection.setWatchTopicAdvisories(this.isWatchTopicAdvisories());
        connection.setProducerWindowSize(this.getProducerWindowSize());
        connection.setWarnAboutUnstartedConnectionTimeout(this.getWarnAboutUnstartedConnectionTimeout());
        connection.setSendTimeout(this.getSendTimeout());
        if (this.transportListener != null) {
            connection.addTransportListener(this.transportListener);
        }
    }

    public String getBrokerURL() {
        return this.brokerURL == null ? null : this.brokerURL.toString();
    }

    public void setBrokerURL(String brokerURL) {
        this.brokerURL = ActiveMQConnectionFactory.createURI(brokerURL);
        if (this.brokerURL.getQuery() != null) {
            try {
                Map<String, String> map = URISupport.parseQuery(this.brokerURL.getQuery());
                if (this.buildFromMap(IntrospectionSupport.extractProperties(map, "jms."))) {
                    this.brokerURL = URISupport.createRemainingURI(this.brokerURL, map);
                }
            }
            catch (URISyntaxException e) {}
        } else {
            try {
                URISupport.CompositeData data = URISupport.parseComposite(this.brokerURL);
                if (this.buildFromMap(IntrospectionSupport.extractProperties(data.getParameters(), "jms."))) {
                    this.brokerURL = data.toURI();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public boolean isCopyMessageOnSend() {
        return this.copyMessageOnSend;
    }

    public void setCopyMessageOnSend(boolean copyMessageOnSend) {
        this.copyMessageOnSend = copyMessageOnSend;
    }

    public boolean isDisableTimeStampsByDefault() {
        return this.disableTimeStampsByDefault;
    }

    public void setDisableTimeStampsByDefault(boolean disableTimeStampsByDefault) {
        this.disableTimeStampsByDefault = disableTimeStampsByDefault;
    }

    public boolean isOptimizedMessageDispatch() {
        return this.optimizedMessageDispatch;
    }

    public void setOptimizedMessageDispatch(boolean optimizedMessageDispatch) {
        this.optimizedMessageDispatch = optimizedMessageDispatch;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ActiveMQPrefetchPolicy getPrefetchPolicy() {
        return this.prefetchPolicy;
    }

    public void setPrefetchPolicy(ActiveMQPrefetchPolicy prefetchPolicy) {
        this.prefetchPolicy = prefetchPolicy;
    }

    public boolean isUseAsyncSend() {
        return this.useAsyncSend;
    }

    public BlobTransferPolicy getBlobTransferPolicy() {
        return this.blobTransferPolicy;
    }

    public void setBlobTransferPolicy(BlobTransferPolicy blobTransferPolicy) {
        this.blobTransferPolicy = blobTransferPolicy;
    }

    public void setUseAsyncSend(boolean useAsyncSend) {
        this.useAsyncSend = useAsyncSend;
    }

    public synchronized boolean isWatchTopicAdvisories() {
        return this.watchTopicAdvisories;
    }

    public synchronized void setWatchTopicAdvisories(boolean watchTopicAdvisories) {
        this.watchTopicAdvisories = watchTopicAdvisories;
    }

    public boolean isAlwaysSyncSend() {
        return this.alwaysSyncSend;
    }

    public void setAlwaysSyncSend(boolean alwaysSyncSend) {
        this.alwaysSyncSend = alwaysSyncSend;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean isUseRetroactiveConsumer() {
        return this.useRetroactiveConsumer;
    }

    public void setUseRetroactiveConsumer(boolean useRetroactiveConsumer) {
        this.useRetroactiveConsumer = useRetroactiveConsumer;
    }

    public boolean isExclusiveConsumer() {
        return this.exclusiveConsumer;
    }

    public void setExclusiveConsumer(boolean exclusiveConsumer) {
        this.exclusiveConsumer = exclusiveConsumer;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public MessageTransformer getTransformer() {
        return this.transformer;
    }

    public int getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(int sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setTransformer(MessageTransformer transformer) {
        this.transformer = transformer;
    }

    @Override
    public void buildFromProperties(Properties properties) {
        String temp;
        if (properties == null) {
            properties = new Properties();
        }
        if ((temp = properties.getProperty("java.naming.provider.url")) == null || temp.length() == 0) {
            temp = properties.getProperty("brokerURL");
        }
        if (temp != null && temp.length() > 0) {
            this.setBrokerURL(temp);
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>(properties);
        this.buildFromMap(p);
    }

    public boolean buildFromMap(Map<String, Object> properties) {
        BlobTransferPolicy blobTransferPolicy;
        RedeliveryPolicy rp;
        boolean rc = false;
        ActiveMQPrefetchPolicy p = new ActiveMQPrefetchPolicy();
        if (IntrospectionSupport.setProperties(p, properties, "prefetchPolicy.")) {
            this.setPrefetchPolicy(p);
            rc = true;
        }
        if (IntrospectionSupport.setProperties(rp = new RedeliveryPolicy(), properties, "redeliveryPolicy.")) {
            this.setRedeliveryPolicy(rp);
            rc = true;
        }
        if (IntrospectionSupport.setProperties(blobTransferPolicy = new BlobTransferPolicy(), properties, "blobTransferPolicy.")) {
            this.setBlobTransferPolicy(blobTransferPolicy);
            rc = true;
        }
        return rc |= IntrospectionSupport.setProperties(this, properties);
    }

    @Override
    public void populateProperties(Properties props) {
        props.setProperty("dispatchAsync", Boolean.toString(this.isDispatchAsync()));
        if (this.getBrokerURL() != null) {
            props.setProperty("java.naming.provider.url", this.getBrokerURL());
            props.setProperty("brokerURL", this.getBrokerURL());
        }
        if (this.getClientID() != null) {
            props.setProperty("clientID", this.getClientID());
        }
        IntrospectionSupport.getProperties(this.getPrefetchPolicy(), props, "prefetchPolicy.");
        IntrospectionSupport.getProperties(this.getRedeliveryPolicy(), props, "redeliveryPolicy.");
        IntrospectionSupport.getProperties(this.getBlobTransferPolicy(), props, "blobTransferPolicy.");
        props.setProperty("copyMessageOnSend", Boolean.toString(this.isCopyMessageOnSend()));
        props.setProperty("disableTimeStampsByDefault", Boolean.toString(this.isDisableTimeStampsByDefault()));
        props.setProperty("objectMessageSerializationDefered", Boolean.toString(this.isObjectMessageSerializationDefered()));
        props.setProperty("optimizedMessageDispatch", Boolean.toString(this.isOptimizedMessageDispatch()));
        if (this.getPassword() != null) {
            props.setProperty("password", this.getPassword());
        }
        props.setProperty("useAsyncSend", Boolean.toString(this.isUseAsyncSend()));
        props.setProperty("useCompression", Boolean.toString(this.isUseCompression()));
        props.setProperty("useRetroactiveConsumer", Boolean.toString(this.isUseRetroactiveConsumer()));
        props.setProperty("watchTopicAdvisories", Boolean.toString(this.isWatchTopicAdvisories()));
        if (this.getUserName() != null) {
            props.setProperty("userName", this.getUserName());
        }
        props.setProperty("closeTimeout", Integer.toString(this.getCloseTimeout()));
        props.setProperty("alwaysSessionAsync", Boolean.toString(this.isAlwaysSessionAsync()));
        props.setProperty("optimizeAcknowledge", Boolean.toString(this.isOptimizeAcknowledge()));
        props.setProperty("statsEnabled", Boolean.toString(this.isStatsEnabled()));
        props.setProperty("alwaysSyncSend", Boolean.toString(this.isAlwaysSyncSend()));
        props.setProperty("producerWindowSize", Integer.toString(this.getProducerWindowSize()));
        props.setProperty("sendTimeout", Integer.toString(this.getSendTimeout()));
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public boolean isObjectMessageSerializationDefered() {
        return this.objectMessageSerializationDefered;
    }

    public void setObjectMessageSerializationDefered(boolean objectMessageSerializationDefered) {
        this.objectMessageSerializationDefered = objectMessageSerializationDefered;
    }

    public boolean isDispatchAsync() {
        return this.dispatchAsync;
    }

    public void setDispatchAsync(boolean asyncDispatch) {
        this.dispatchAsync = asyncDispatch;
    }

    public int getCloseTimeout() {
        return this.closeTimeout;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public boolean isAlwaysSessionAsync() {
        return this.alwaysSessionAsync;
    }

    public void setAlwaysSessionAsync(boolean alwaysSessionAsync) {
        this.alwaysSessionAsync = alwaysSessionAsync;
    }

    public boolean isOptimizeAcknowledge() {
        return this.optimizeAcknowledge;
    }

    public void setOptimizeAcknowledge(boolean optimizeAcknowledge) {
        this.optimizeAcknowledge = optimizeAcknowledge;
    }

    public boolean isNestedMapAndListEnabled() {
        return this.nestedMapAndListEnabled;
    }

    public void setNestedMapAndListEnabled(boolean structuredMapsEnabled) {
        this.nestedMapAndListEnabled = structuredMapsEnabled;
    }

    public String getClientIDPrefix() {
        return this.clientIDPrefix;
    }

    public void setClientIDPrefix(String clientIDPrefix) {
        this.clientIDPrefix = clientIDPrefix;
    }

    protected synchronized IdGenerator getClientIdGenerator() {
        if (this.clientIdGenerator == null) {
            this.clientIdGenerator = this.clientIDPrefix != null ? new IdGenerator(this.clientIDPrefix) : new IdGenerator();
        }
        return this.clientIdGenerator;
    }

    protected void setClientIdGenerator(IdGenerator clientIdGenerator) {
        this.clientIdGenerator = clientIdGenerator;
    }

    public boolean isStatsEnabled() {
        return this.factoryStats.isEnabled();
    }

    public void setStatsEnabled(boolean statsEnabled) {
        this.factoryStats.setEnabled(statsEnabled);
    }

    public synchronized int getProducerWindowSize() {
        return this.producerWindowSize;
    }

    public synchronized void setProducerWindowSize(int producerWindowSize) {
        this.producerWindowSize = producerWindowSize;
    }

    public long getWarnAboutUnstartedConnectionTimeout() {
        return this.warnAboutUnstartedConnectionTimeout;
    }

    public void setWarnAboutUnstartedConnectionTimeout(long warnAboutUnstartedConnectionTimeout) {
        this.warnAboutUnstartedConnectionTimeout = warnAboutUnstartedConnectionTimeout;
    }

    public TransportListener getTransportListener() {
        return this.transportListener;
    }

    public void setTransportListener(TransportListener transportListener) {
        this.transportListener = transportListener;
    }
}

