/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.Service;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.transport.DefaultTransportListener;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MasterConnector
implements Service,
BrokerServiceAware {
    private static final Log LOG = LogFactory.getLog(MasterConnector.class);
    private BrokerService broker;
    private URI remoteURI;
    private URI localURI;
    private Transport localBroker;
    private Transport remoteBroker;
    private TransportConnector connector;
    private AtomicBoolean started = new AtomicBoolean(false);
    private final IdGenerator idGenerator = new IdGenerator();
    private String userName;
    private String password;
    private ConnectionInfo connectionInfo;
    private SessionInfo sessionInfo;
    private ProducerInfo producerInfo;
    private final AtomicBoolean masterActive = new AtomicBoolean();

    public MasterConnector() {
    }

    public MasterConnector(String remoteUri) throws URISyntaxException {
        this.remoteURI = new URI(remoteUri);
    }

    public void setBrokerService(BrokerService broker) {
        List<TransportConnector> transportConnectors;
        this.broker = broker;
        if (this.localURI == null) {
            this.localURI = broker.getVmConnectorURI();
        }
        if (this.connector == null && !(transportConnectors = broker.getTransportConnectors()).isEmpty()) {
            this.connector = transportConnectors.get(0);
        }
    }

    public boolean isSlave() {
        return this.masterActive.get();
    }

    public void start() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        if (this.remoteURI == null) {
            throw new IllegalArgumentException("You must specify a remoteURI");
        }
        this.localBroker = TransportFactory.connect(this.localURI);
        this.remoteBroker = TransportFactory.connect(this.remoteURI);
        LOG.info("Starting a slave connection between " + this.localBroker + " and " + this.remoteBroker + " has been established.");
        this.localBroker.setTransportListener(new DefaultTransportListener(){

            public void onCommand(Object command) {
            }

            public void onException(IOException error) {
                if (MasterConnector.this.started.get()) {
                    MasterConnector.this.serviceLocalException(error);
                }
            }
        });
        this.remoteBroker.setTransportListener(new DefaultTransportListener(){

            public void onCommand(Object o) {
                Command command = (Command)o;
                if (MasterConnector.this.started.get()) {
                    MasterConnector.this.serviceRemoteCommand(command);
                }
            }

            public void onException(IOException error) {
                if (MasterConnector.this.started.get()) {
                    MasterConnector.this.serviceRemoteException(error);
                }
            }
        });
        try {
            this.localBroker.start();
            this.remoteBroker.start();
            this.startBridge();
            this.masterActive.set(true);
        }
        catch (Exception e) {
            this.masterActive.set(false);
            LOG.error("Failed to start network bridge: " + e, e);
        }
    }

    protected void startBridge() throws Exception {
        this.connectionInfo = new ConnectionInfo();
        this.connectionInfo.setConnectionId(new ConnectionId(this.idGenerator.generateId()));
        this.connectionInfo.setClientId(this.idGenerator.generateId());
        this.connectionInfo.setUserName(this.userName);
        this.connectionInfo.setPassword(this.password);
        this.localBroker.oneway(this.connectionInfo);
        ConnectionInfo remoteInfo = new ConnectionInfo();
        this.connectionInfo.copy(remoteInfo);
        remoteInfo.setBrokerMasterConnector(true);
        this.remoteBroker.oneway(this.connectionInfo);
        this.sessionInfo = new SessionInfo(this.connectionInfo, 1L);
        this.localBroker.oneway(this.sessionInfo);
        this.remoteBroker.oneway(this.sessionInfo);
        this.producerInfo = new ProducerInfo(this.sessionInfo, 1L);
        this.producerInfo.setResponseRequired(false);
        this.remoteBroker.oneway(this.producerInfo);
        BrokerInfo brokerInfo = null;
        brokerInfo = this.connector != null ? this.connector.getBrokerInfo() : new BrokerInfo();
        brokerInfo.setBrokerName(this.broker.getBrokerName());
        brokerInfo.setPeerBrokerInfos(this.broker.getBroker().getPeerBrokerInfos());
        brokerInfo.setSlaveBroker(true);
        this.remoteBroker.oneway(brokerInfo);
        LOG.info("Slave connection between " + this.localBroker + " and " + this.remoteBroker + " has been established.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        this.masterActive.set(false);
        try {
            this.remoteBroker.oneway(new ShutdownInfo());
            this.localBroker.oneway(new ShutdownInfo());
        }
        catch (IOException e) {
            LOG.debug("Caught exception stopping", e);
        }
        finally {
            ServiceStopper ss = new ServiceStopper();
            ss.stop(this.localBroker);
            ss.stop(this.remoteBroker);
            ss.throwFirstException();
        }
    }

    protected void serviceRemoteException(IOException error) {
        LOG.error("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown: " + error.getMessage(), error);
        this.shutDown();
    }

    protected void serviceRemoteCommand(Command command) {
        try {
            if (command.isMessageDispatch()) {
                MessageDispatch md = (MessageDispatch)command;
                command = md.getMessage();
            }
            if (command.getDataStructureType() == 11) {
                LOG.warn("The Master has shutdown");
                this.shutDown();
            } else {
                boolean responseRequired = command.isResponseRequired();
                int commandId = command.getCommandId();
                if (responseRequired) {
                    Response response = (Response)this.localBroker.request(command);
                    response.setCorrelationId(commandId);
                    this.remoteBroker.oneway(response);
                } else {
                    this.localBroker.oneway(command);
                }
            }
        }
        catch (IOException e) {
            this.serviceRemoteException(e);
        }
    }

    protected void serviceLocalException(Throwable error) {
        LOG.info("Network connection between " + this.localBroker + " and " + this.remoteBroker + " shutdown: " + error.getMessage(), error);
        ServiceSupport.dispose(this);
    }

    public URI getLocalURI() {
        return this.localURI;
    }

    public void setLocalURI(URI localURI) {
        this.localURI = localURI;
    }

    public URI getRemoteURI() {
        return this.remoteURI;
    }

    public void setRemoteURI(URI remoteURI) {
        this.remoteURI = remoteURI;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    private void shutDown() {
        this.masterActive.set(false);
        this.broker.masterFailed();
        ServiceSupport.dispose(this);
    }
}

