/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.jmx.DurableSubscriptionViewMBean;
import org.apache.activemq.broker.jmx.ManagedRegionBroker;
import org.apache.activemq.broker.jmx.SubscriptionView;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.RemoveSubscriptionInfo;

public class DurableSubscriptionView
extends SubscriptionView
implements DurableSubscriptionViewMBean {
    protected ManagedRegionBroker broker;
    protected String subscriptionName;

    public DurableSubscriptionView(ManagedRegionBroker broker, String clientId, Subscription sub) {
        super(clientId, sub);
        this.broker = broker;
        this.subscriptionName = sub.getConsumerInfo().getSubscriptionName();
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public CompositeData[] browse() throws OpenDataException {
        return this.broker.browse(this);
    }

    public TabularData browseAsTable() throws OpenDataException {
        return this.broker.browseAsTable(this);
    }

    public void destroy() throws Exception {
        RemoveSubscriptionInfo info = new RemoveSubscriptionInfo();
        info.setClientId(this.clientId);
        info.setSubscriptionName(this.subscriptionName);
        ConnectionContext context = new ConnectionContext();
        context.setBroker(this.broker);
        context.setClientId(this.clientId);
        this.broker.removeSubscription(context, info);
    }

    public String toString() {
        return "InactiveDurableSubscriptionView: " + this.getClientId() + ":" + this.getSubscriptionName();
    }
}

