/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.util;

import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.command.Message;

public class TimeStampingBrokerPlugin
extends BrokerPluginSupport {
    public void send(ProducerBrokerExchange producerExchange, Message message) throws Exception {
        if (message.getTimestamp() > 0L && (message.getBrokerPath() == null || message.getBrokerPath().length == 0)) {
            long oldExpiration = message.getExpiration();
            long newTimeStamp = System.currentTimeMillis();
            if (oldExpiration > 0L) {
                long oldTimestamp = message.getTimestamp();
                long timeToLive = oldExpiration - oldTimestamp;
                long expiration = timeToLive + newTimeStamp;
                message.setExpiration(expiration);
            }
            message.setTimestamp(newTimeStamp);
        }
        super.send(producerExchange, message);
    }
}

