/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index.hash;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.impl.index.Index;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexManager;
import org.apache.activemq.kaha.impl.index.hash.HashBin;
import org.apache.activemq.kaha.impl.index.hash.HashEntry;
import org.apache.activemq.kaha.impl.index.hash.HashIndexMBean;
import org.apache.activemq.kaha.impl.index.hash.HashPage;
import org.apache.activemq.util.DataByteArrayInputStream;
import org.apache.activemq.util.DataByteArrayOutputStream;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.LRUCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HashIndex
implements Index,
HashIndexMBean {
    public static final int DEFAULT_PAGE_SIZE;
    public static final int DEFAULT_KEY_SIZE;
    public static final int DEFAULT_BIN_SIZE;
    public static final int MAXIMUM_CAPACITY;
    public static final int DEFAULT_LOAD_FACTOR;
    private static final int LOW_WATER_MARK = 16384;
    private static final String NAME_PREFIX = "hash-index-";
    private static final Log LOG;
    private final String name;
    private File directory;
    private File file;
    private RandomAccessFile indexFile;
    private IndexManager indexManager;
    private int pageSize = DEFAULT_PAGE_SIZE;
    private int keySize = DEFAULT_KEY_SIZE;
    private int numberOfBins = DEFAULT_BIN_SIZE;
    private int keysPerPage = this.pageSize / this.keySize;
    private DataByteArrayInputStream dataIn;
    private DataByteArrayOutputStream dataOut;
    private byte[] readBuffer;
    private HashBin[] bins;
    private Marshaller keyMarshaller;
    private long length;
    private LinkedList<HashPage> freeList = new LinkedList();
    private AtomicBoolean loaded = new AtomicBoolean();
    private LRUCache<Long, HashPage> pageCache;
    private boolean enablePageCaching = false;
    private int pageCacheSize = 10;
    private int size;
    private int highestSize = 0;
    private int activeBins;
    private int threshold;
    private int maximumCapacity = MAXIMUM_CAPACITY;
    private int loadFactor = DEFAULT_LOAD_FACTOR;

    public HashIndex(File directory, String name, IndexManager indexManager) throws IOException {
        this.directory = directory;
        this.name = name;
        this.indexManager = indexManager;
        this.openIndexFile();
        this.pageCache = new LRUCache(this.pageCacheSize, this.pageCacheSize, 0.75f, true);
    }

    public synchronized void setKeyMarshaller(Marshaller marshaller) {
        this.keyMarshaller = marshaller;
    }

    public synchronized int getKeySize() {
        return this.keySize;
    }

    public synchronized void setKeySize(int keySize) {
        this.keySize = keySize;
        if (this.loaded.get()) {
            throw new RuntimeException("Pages already loaded - can't reset key size");
        }
    }

    public synchronized int getPageSize() {
        return this.pageSize;
    }

    public synchronized void setPageSize(int pageSize) {
        if (this.loaded.get() && pageSize != this.pageSize) {
            throw new RuntimeException("Pages already loaded - can't reset page size");
        }
        this.pageSize = pageSize;
    }

    public int getNumberOfBins() {
        return this.numberOfBins;
    }

    public void setNumberOfBins(int numberOfBins) {
        if (this.loaded.get() && numberOfBins != this.numberOfBins) {
            throw new RuntimeException("Pages already loaded - can't reset bin size");
        }
        this.numberOfBins = numberOfBins;
    }

    public synchronized boolean isEnablePageCaching() {
        return this.enablePageCaching;
    }

    public synchronized void setEnablePageCaching(boolean enablePageCaching) {
        this.enablePageCaching = enablePageCaching;
    }

    public synchronized int getPageCacheSize() {
        return this.pageCacheSize;
    }

    public synchronized void setPageCacheSize(int pageCacheSize) {
        this.pageCacheSize = pageCacheSize;
        this.pageCache.setMaxCacheSize(pageCacheSize);
    }

    public synchronized boolean isTransient() {
        return false;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(int loadFactor) {
        this.loadFactor = loadFactor;
    }

    public int getMaximumCapacity() {
        return this.maximumCapacity;
    }

    public void setMaximumCapacity(int maximumCapacity) {
        this.maximumCapacity = maximumCapacity;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized int getActiveBins() {
        return this.activeBins;
    }

    public synchronized void load() {
        if (this.loaded.compareAndSet(false, true)) {
            int capacity;
            for (capacity = 1; capacity < this.numberOfBins; capacity <<= 1) {
            }
            this.bins = new HashBin[capacity];
            this.numberOfBins = capacity;
            this.threshold = this.calculateThreashold();
            this.keysPerPage = this.pageSize / this.keySize;
            this.dataIn = new DataByteArrayInputStream();
            this.dataOut = new DataByteArrayOutputStream(this.pageSize);
            this.readBuffer = new byte[this.pageSize];
            try {
                this.openIndexFile();
                if (this.indexFile.length() > 0L) {
                    this.doCompress();
                }
            }
            catch (IOException e) {
                LOG.error("Failed to load index ", e);
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized void unload() throws IOException {
        if (this.loaded.compareAndSet(true, false) && this.indexFile != null) {
            this.indexFile.close();
            this.indexFile = null;
            this.freeList.clear();
            this.pageCache.clear();
            this.bins = new HashBin[this.bins.length];
        }
    }

    public synchronized void store(Object key, StoreEntry value) throws IOException {
        this.load();
        HashEntry entry = new HashEntry();
        entry.setKey((Comparable)key);
        entry.setIndexOffset(value.getOffset());
        if (!this.getBin(key).put(entry)) {
            ++this.size;
        }
        if (this.size >= this.threshold) {
            this.resize(2 * this.bins.length);
        }
        if (this.size > this.highestSize) {
            this.highestSize = this.size;
        }
    }

    public synchronized StoreEntry get(Object key) throws IOException {
        this.load();
        HashEntry entry = new HashEntry();
        entry.setKey((Comparable)key);
        HashEntry result = this.getBin(key).find(entry);
        return result != null ? this.indexManager.getIndex(result.getIndexOffset()) : null;
    }

    public synchronized StoreEntry remove(Object key) throws IOException {
        this.load();
        IndexItem result = null;
        HashEntry entry = new HashEntry();
        entry.setKey((Comparable)key);
        HashEntry he = this.getBin(key).remove(entry);
        if (he != null) {
            --this.size;
            result = this.indexManager.getIndex(he.getIndexOffset());
        }
        if (this.highestSize > 16384 && this.highestSize > this.size * 2) {
            int newSize = this.size / this.keysPerPage;
            newSize = Math.max(128, newSize);
            this.highestSize = 0;
            this.resize(newSize);
        }
        return result;
    }

    public synchronized boolean containsKey(Object key) throws IOException {
        return this.get(key) != null;
    }

    public synchronized void clear() throws IOException {
        this.unload();
        this.delete();
        this.openIndexFile();
        this.load();
    }

    public synchronized void delete() throws IOException {
        this.unload();
        if (this.file.exists()) {
            this.file.delete();
        }
        this.length = 0L;
    }

    HashPage lookupPage(long pageId) throws IOException {
        HashPage result = null;
        if (pageId >= 0L && (result = this.getFromCache(pageId)) == null && (result = this.getFullPage(pageId)) != null) {
            if (result.isActive()) {
                this.addToCache(result);
            } else {
                throw new IllegalStateException("Trying to access an inactive page: " + pageId);
            }
        }
        return result;
    }

    HashPage createPage(int binId) throws IOException {
        HashPage result = this.getNextFreePage();
        if (result == null) {
            result = new HashPage(this.keysPerPage);
            result.setId(this.length);
            result.setBinId(binId);
            this.writePageHeader(result);
            this.length += (long)this.pageSize;
            this.indexFile.seek(this.length);
            this.indexFile.write(-1);
        }
        this.addToCache(result);
        return result;
    }

    void releasePage(HashPage page) throws IOException {
        this.removeFromCache(page);
        page.reset();
        page.setActive(false);
        this.writePageHeader(page);
        this.freeList.add(page);
    }

    private HashPage getNextFreePage() throws IOException {
        HashPage result = null;
        if (!this.freeList.isEmpty()) {
            result = this.freeList.removeFirst();
            result.setActive(true);
            result.reset();
            this.writePageHeader(result);
        }
        return result;
    }

    void writeFullPage(HashPage page) throws IOException {
        this.dataOut.reset();
        page.write(this.keyMarshaller, this.dataOut);
        if (this.dataOut.size() > this.pageSize) {
            throw new IOException("Page Size overflow: pageSize is " + this.pageSize + " trying to write " + this.dataOut.size());
        }
        this.indexFile.seek(page.getId());
        this.indexFile.write(this.dataOut.getData(), 0, this.dataOut.size());
    }

    void writePageHeader(HashPage page) throws IOException {
        this.dataOut.reset();
        page.writeHeader(this.dataOut);
        this.indexFile.seek(page.getId());
        this.indexFile.write(this.dataOut.getData(), 0, 17);
    }

    HashPage getFullPage(long id) throws IOException {
        this.indexFile.seek(id);
        this.indexFile.readFully(this.readBuffer, 0, this.pageSize);
        this.dataIn.restart(this.readBuffer);
        HashPage page = new HashPage(this.keysPerPage);
        page.setId(id);
        page.read(this.keyMarshaller, this.dataIn);
        return page;
    }

    HashPage getPageHeader(long id) throws IOException {
        this.indexFile.seek(id);
        this.indexFile.readFully(this.readBuffer, 0, 17);
        this.dataIn.restart(this.readBuffer);
        HashPage page = new HashPage(this.keysPerPage);
        page.setId(id);
        page.readHeader(this.dataIn);
        return page;
    }

    void addToBin(HashPage page) throws IOException {
        int index = page.getBinId();
        if (index >= this.bins.length) {
            this.resize(index + 1);
        }
        HashBin bin = this.getBin(index);
        bin.addHashPageInfo(page.getId(), page.getPersistedSize());
    }

    private HashBin getBin(int index) {
        HashBin result = this.bins[index];
        if (result == null) {
            this.bins[index] = result = new HashBin(this, index, this.pageSize / this.keySize);
            ++this.activeBins;
        }
        return result;
    }

    private void openIndexFile() throws IOException {
        if (this.indexFile == null) {
            this.file = new File(this.directory, NAME_PREFIX + IOHelper.toFileSystemSafeName(this.name));
            IOHelper.mkdirs(this.file.getParentFile());
            this.indexFile = new RandomAccessFile(this.file, "rw");
        }
    }

    private HashBin getBin(Object key) {
        int hash = HashIndex.hash(key);
        int i = HashIndex.indexFor(hash, this.bins.length);
        return this.getBin(i);
    }

    private HashPage getFromCache(long pageId) {
        HashPage result = null;
        if (this.enablePageCaching) {
            result = (HashPage)this.pageCache.get(pageId);
        }
        return result;
    }

    private void addToCache(HashPage page) {
        if (this.enablePageCaching) {
            this.pageCache.put(page.getId(), page);
        }
    }

    private void removeFromCache(HashPage page) {
        if (this.enablePageCaching) {
            this.pageCache.remove(page.getId());
        }
    }

    private void doLoad() throws IOException {
        long offset = 0L;
        if (this.loaded.compareAndSet(false, true)) {
            while (offset + (long)this.pageSize <= this.indexFile.length()) {
                this.indexFile.seek(offset);
                this.indexFile.readFully(this.readBuffer, 0, 17);
                this.dataIn.restart(this.readBuffer);
                HashPage page = new HashPage(this.keysPerPage);
                page.setId(offset);
                page.readHeader(this.dataIn);
                if (!page.isActive()) {
                    page.reset();
                    this.freeList.add(page);
                } else {
                    this.addToBin(page);
                    this.size += page.size();
                }
                offset += (long)this.pageSize;
            }
            this.length = offset;
        }
    }

    private void doCompress() throws IOException {
        String backFileName = this.name + "-COMPRESS";
        HashIndex backIndex = new HashIndex(this.directory, backFileName, this.indexManager);
        backIndex.setKeyMarshaller(this.keyMarshaller);
        backIndex.setKeySize(this.getKeySize());
        backIndex.setNumberOfBins(this.getNumberOfBins());
        backIndex.setPageSize(this.getPageSize());
        backIndex.load();
        File backFile = backIndex.file;
        long offset = 0L;
        while (offset + (long)this.pageSize <= this.indexFile.length()) {
            this.indexFile.seek(offset);
            HashPage page = this.getFullPage(offset);
            if (page.isActive()) {
                for (HashEntry entry : page.getEntries()) {
                    backIndex.getBin(entry.getKey()).put(entry);
                    ++backIndex.size;
                }
            }
            page = null;
            offset += (long)this.pageSize;
        }
        backIndex.unload();
        this.unload();
        IOHelper.deleteFile(this.file);
        IOHelper.copyFile(backFile, this.file);
        IOHelper.deleteFile(backFile);
        this.openIndexFile();
        this.doLoad();
    }

    private void resize(int newCapacity) throws IOException {
        if (this.bins.length < this.getMaximumCapacity()) {
            if (newCapacity != this.numberOfBins) {
                int capacity;
                for (capacity = 1; capacity < newCapacity; capacity <<= 1) {
                }
                newCapacity = capacity;
                if (newCapacity != this.numberOfBins) {
                    LOG.info("Resize hash bins " + this.name + " from " + this.numberOfBins + " to " + newCapacity);
                    String backFileName = this.name + "-REISZE";
                    HashIndex backIndex = new HashIndex(this.directory, backFileName, this.indexManager);
                    backIndex.setKeyMarshaller(this.keyMarshaller);
                    backIndex.setKeySize(this.getKeySize());
                    backIndex.setNumberOfBins(newCapacity);
                    backIndex.setPageSize(this.getPageSize());
                    backIndex.load();
                    File backFile = backIndex.file;
                    long offset = 0L;
                    while (offset + (long)this.pageSize <= this.indexFile.length()) {
                        this.indexFile.seek(offset);
                        HashPage page = this.getFullPage(offset);
                        if (page.isActive()) {
                            for (HashEntry entry : page.getEntries()) {
                                backIndex.getBin(entry.getKey()).put(entry);
                                ++backIndex.size;
                            }
                        }
                        page = null;
                        offset += (long)this.pageSize;
                    }
                    backIndex.unload();
                    this.unload();
                    IOHelper.deleteFile(this.file);
                    IOHelper.copyFile(backFile, this.file);
                    IOHelper.deleteFile(backFile);
                    this.setNumberOfBins(newCapacity);
                    this.bins = new HashBin[newCapacity];
                    this.threshold = this.calculateThreashold();
                    this.openIndexFile();
                    this.doLoad();
                }
            }
        } else {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
    }

    private int calculateThreashold() {
        return this.bins.length * this.loadFactor;
    }

    public String toString() {
        String str = "HashIndex" + System.identityHashCode(this) + ": " + this.file.getName();
        return str;
    }

    static int hash(Object x) {
        int h = x.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    static {
        LOG = LogFactory.getLog(HashIndex.class);
        DEFAULT_PAGE_SIZE = Integer.parseInt(System.getProperty("defaultPageSize", "16384"));
        DEFAULT_KEY_SIZE = Integer.parseInt(System.getProperty("defaultKeySize", "96"));
        DEFAULT_BIN_SIZE = Integer.parseInt(System.getProperty("defaultBinSize", "1024"));
        MAXIMUM_CAPACITY = Integer.parseInt(System.getProperty("defaultPageSize", "16384"));
        DEFAULT_LOAD_FACTOR = Integer.parseInt(System.getProperty("defaultLoadFactor", "50"));
    }
}

