/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.DemandSubscription;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.transport.Transport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConduitBridge
extends DemandForwardingBridge {
    private static final Log LOG = LogFactory.getLog(ConduitBridge.class);

    public ConduitBridge(NetworkBridgeConfiguration configuration, Transport localBroker, Transport remoteBroker) {
        super(configuration, localBroker, remoteBroker);
    }

    protected DemandSubscription createDemandSubscription(ConsumerInfo info) throws IOException {
        if (this.addToAlreadyInterestedConsumers(info)) {
            return null;
        }
        info.addNetworkConsumerId(info.getConsumerId());
        info.setSelector(null);
        return this.doCreateDemandSubscription(info);
    }

    protected boolean addToAlreadyInterestedConsumers(ConsumerInfo info) {
        boolean matched = false;
        DestinationFilter filter = DestinationFilter.parseFilter(info.getDestination());
        for (DemandSubscription ds : this.subscriptionMapByLocalId.values()) {
            if (!filter.matches(ds.getLocalInfo().getDestination())) continue;
            ds.add(info.getConsumerId());
            matched = true;
        }
        return matched;
    }

    protected void removeDemandSubscription(ConsumerId id) throws IOException {
        ArrayList<DemandSubscription> tmpList = new ArrayList<DemandSubscription>();
        for (DemandSubscription ds : this.subscriptionMapByLocalId.values()) {
            ds.remove(id);
            if (!ds.isEmpty()) continue;
            tmpList.add(ds);
        }
        for (DemandSubscription ds : tmpList) {
            this.subscriptionMapByLocalId.remove(ds.getRemoteInfo().getConsumerId());
            this.removeSubscription(ds);
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("removing sub on " + this.localBroker + " from " + this.remoteBrokerName + " :  " + ds.getRemoteInfo());
        }
    }
}

