/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.activemq.store.jdbc.DatabaseLocker;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.Statements;
import org.apache.activemq.util.Handler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultDatabaseLocker
implements DatabaseLocker {
    public static final long DEFAULT_LOCK_ACQUIRE_SLEEP_INTERVAL = 1000L;
    private static final Log LOG = LogFactory.getLog(DefaultDatabaseLocker.class);
    private final DataSource dataSource;
    private final Statements statements;
    private long lockAcquireSleepInterval = 1000L;
    private Connection connection;
    private boolean stopping;
    private Handler<Exception> exceptionHandler;

    public DefaultDatabaseLocker(JDBCPersistenceAdapter persistenceAdapter) throws IOException {
        this(persistenceAdapter.getLockDataSource(), persistenceAdapter.getStatements());
    }

    public DefaultDatabaseLocker(DataSource dataSource, Statements statements) {
        this.dataSource = dataSource;
        this.statements = statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        this.stopping = false;
        LOG.info("Attempting to acquire the exclusive lock to become the Master broker");
        Statement statement = null;
        while (true) {
            try {
                this.connection = this.dataSource.getConnection();
                this.connection.setAutoCommit(false);
                String sql = this.statements.getLockCreateStatement();
                statement = this.connection.prepareStatement(sql);
                statement.execute();
                break;
            }
            catch (Exception e) {
                if (this.stopping) {
                    throw new Exception("Cannot start broker as being asked to shut down. Interrupted attempt to acquire lock: " + e, e);
                }
                if (this.exceptionHandler != null) {
                    try {
                        this.exceptionHandler.handle(e);
                    }
                    catch (Throwable handlerException) {
                        LOG.error("The exception handler " + this.exceptionHandler.getClass().getCanonicalName() + " threw this exception: " + handlerException + " while trying to handle this excpetion: " + e, handlerException);
                    }
                } else {
                    LOG.error("Failed to acquire lock: " + e, e);
                }
            }
            finally {
                if (null != statement) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e1) {
                        LOG.warn("Caught while closing statement: " + e1, e1);
                    }
                    statement = null;
                }
            }
            LOG.debug("Sleeping for " + this.lockAcquireSleepInterval + " milli(s) before trying again to get the lock...");
            try {
                Thread.sleep(this.lockAcquireSleepInterval);
            }
            catch (InterruptedException ie) {
                LOG.warn("Master lock retry sleep interrupted", ie);
            }
        }
        LOG.info("Becoming the master on dataSource: " + this.dataSource);
    }

    public void stop() throws Exception {
        this.stopping = true;
        if (this.connection != null && !this.connection.isClosed()) {
            try {
                this.connection.rollback();
            }
            catch (SQLException sqle) {
                LOG.warn("Exception while rollbacking the connection on shutdown", sqle);
            }
            this.connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean keepAlive() {
        PreparedStatement statement = null;
        boolean result = false;
        try {
            statement = this.connection.prepareStatement(this.statements.getLockUpdateStatement());
            statement.setLong(1, System.currentTimeMillis());
            int rows = statement.executeUpdate();
            if (rows == 1) {
                result = true;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to update database lock: " + e, e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.error("Failed to close statement", e);
                }
            }
        }
        return result;
    }

    public long getLockAcquireSleepInterval() {
        return this.lockAcquireSleepInterval;
    }

    public void setLockAcquireSleepInterval(long lockAcquireSleepInterval) {
        this.lockAcquireSleepInterval = lockAcquireSleepInterval;
    }

    public Handler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(Handler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }
}

