/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.jdbc.DataSourceSupport;
import org.apache.activemq.store.jdbc.DatabaseLocker;
import org.apache.activemq.store.jdbc.DefaultDatabaseLocker;
import org.apache.activemq.store.jdbc.JDBCAdapter;
import org.apache.activemq.store.jdbc.JDBCMessageStore;
import org.apache.activemq.store.jdbc.JDBCTopicMessageStore;
import org.apache.activemq.store.jdbc.Statements;
import org.apache.activemq.store.jdbc.TransactionContext;
import org.apache.activemq.store.jdbc.adapter.DefaultJDBCAdapter;
import org.apache.activemq.store.memory.MemoryTransactionStore;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.util.FactoryFinder;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.wireformat.WireFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCPersistenceAdapter
extends DataSourceSupport
implements PersistenceAdapter,
BrokerServiceAware {
    private static final Log LOG = LogFactory.getLog(JDBCPersistenceAdapter.class);
    private static FactoryFinder factoryFinder = new FactoryFinder("META-INF/services/org/apache/activemq/store/jdbc/");
    private WireFormat wireFormat = new OpenWireFormat();
    private BrokerService brokerService;
    private Statements statements;
    private JDBCAdapter adapter;
    private MemoryTransactionStore transactionStore;
    private ScheduledThreadPoolExecutor clockDaemon;
    private ScheduledFuture clockTicket;
    private int cleanupPeriod = 300000;
    private boolean useExternalMessageReferences;
    private boolean useDatabaseLock = true;
    private long lockKeepAlivePeriod = 30000L;
    private long lockAcquireSleepInterval = 1000L;
    private DatabaseLocker databaseLocker;
    private boolean createTablesOnStartup = true;
    private DataSource lockDataSource;

    public JDBCPersistenceAdapter() {
    }

    public JDBCPersistenceAdapter(DataSource ds, WireFormat wireFormat) {
        super(ds);
        this.wireFormat = wireFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ActiveMQDestination> getDestinations() {
        TransactionContext c = null;
        try {
            c = this.getTransactionContext();
            Set<ActiveMQDestination> set = this.getAdapter().doGetDestinations(c);
            return set;
        }
        catch (IOException e) {
            Set<ActiveMQDestination> set = this.emptyDestinationSet();
            return set;
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            Set<ActiveMQDestination> set = this.emptyDestinationSet();
            return set;
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    private Set<ActiveMQDestination> emptyDestinationSet() {
        return Collections.EMPTY_SET;
    }

    @Override
    public MessageStore createQueueMessageStore(ActiveMQQueue destination) throws IOException {
        MessageStore rc = new JDBCMessageStore(this, this.getAdapter(), this.wireFormat, destination);
        if (this.transactionStore != null) {
            rc = this.transactionStore.proxy(rc);
        }
        return rc;
    }

    @Override
    public TopicMessageStore createTopicMessageStore(ActiveMQTopic destination) throws IOException {
        TopicMessageStore rc = new JDBCTopicMessageStore(this, this.getAdapter(), this.wireFormat, destination);
        if (this.transactionStore != null) {
            rc = this.transactionStore.proxy(rc);
        }
        return rc;
    }

    @Override
    public TransactionStore createTransactionStore() throws IOException {
        if (this.transactionStore == null) {
            this.transactionStore = new MemoryTransactionStore();
        }
        return this.transactionStore;
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        TransactionContext c = this.getTransactionContext();
        try {
            long l = this.getAdapter().doGetLastMessageBrokerSequenceId(c);
            return l;
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create("Failed to get last broker message id: " + e, e);
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        this.getAdapter().setUseExternalMessageReferences(this.isUseExternalMessageReferences());
        if (this.isCreateTablesOnStartup()) {
            TransactionContext transactionContext = this.getTransactionContext();
            transactionContext.begin();
            try {
                try {
                    this.getAdapter().doCreateTables(transactionContext);
                }
                catch (SQLException e) {
                    LOG.warn("Cannot create tables due to: " + e);
                    JDBCPersistenceAdapter.log("Failure Details: ", e);
                }
            }
            finally {
                transactionContext.commit();
            }
        }
        if (this.isUseDatabaseLock()) {
            DatabaseLocker service = this.getDatabaseLocker();
            if (service == null) {
                LOG.warn("No databaseLocker configured for the JDBC Persistence Adapter");
            } else {
                service.start();
                if (this.lockKeepAlivePeriod > 0L) {
                    this.getScheduledThreadPoolExecutor().scheduleAtFixedRate(new Runnable(){

                        public void run() {
                            JDBCPersistenceAdapter.this.databaseLockKeepAlive();
                        }
                    }, this.lockKeepAlivePeriod, this.lockKeepAlivePeriod, TimeUnit.MILLISECONDS);
                }
            }
        }
        this.cleanup();
        if (this.cleanupPeriod > 0) {
            this.clockTicket = this.getScheduledThreadPoolExecutor().scheduleAtFixedRate(new Runnable(){

                public void run() {
                    JDBCPersistenceAdapter.this.cleanup();
                }
            }, this.cleanupPeriod, this.cleanupPeriod, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        DatabaseLocker service;
        if (this.clockTicket != null) {
            this.clockTicket.cancel(true);
            this.clockTicket = null;
        }
        if (this.clockDaemon != null) {
            this.clockDaemon.shutdown();
            this.clockDaemon = null;
        }
        if ((service = this.getDatabaseLocker()) != null) {
            service.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        TransactionContext c = null;
        try {
            LOG.debug("Cleaning up old messages.");
            c = this.getTransactionContext();
            this.getAdapter().doDeleteOldMessages(c);
        }
        catch (IOException e) {
            LOG.warn("Old message cleanup failed due to: " + e, e);
        }
        catch (SQLException e) {
            LOG.warn("Old message cleanup failed due to: " + e);
            JDBCPersistenceAdapter.log("Failure Details: ", e);
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Throwable e) {}
            }
            LOG.debug("Cleanup done.");
        }
    }

    public void setScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor clockDaemon) {
        this.clockDaemon = clockDaemon;
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        if (this.clockDaemon == null) {
            this.clockDaemon = new ScheduledThreadPoolExecutor(5, new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "ActiveMQ Cleanup Timer");
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }
        return this.clockDaemon;
    }

    public JDBCAdapter getAdapter() throws IOException {
        if (this.adapter == null) {
            this.setAdapter(this.createAdapter());
        }
        return this.adapter;
    }

    public DatabaseLocker getDatabaseLocker() throws IOException {
        if (this.databaseLocker == null) {
            this.databaseLocker = this.createDatabaseLocker();
        }
        return this.databaseLocker;
    }

    public DataSource getLockDataSource() throws IOException {
        if (this.lockDataSource == null) {
            this.lockDataSource = this.getDataSource();
            if (this.lockDataSource == null) {
                throw new IllegalArgumentException("No dataSource property has been configured");
            }
        } else {
            LOG.info("Using a separate dataSource for locking: " + this.lockDataSource);
        }
        return this.lockDataSource;
    }

    public void setLockDataSource(DataSource dataSource) {
        this.lockDataSource = dataSource;
    }

    public void setDatabaseLocker(DatabaseLocker databaseLocker) {
        this.databaseLocker = databaseLocker;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JDBCAdapter createAdapter() throws IOException {
        DefaultJDBCAdapter adapter = null;
        TransactionContext c = this.getTransactionContext();
        try {
            try {
                String dirverName = c.getConnection().getMetaData().getDriverName();
                dirverName = dirverName.replaceAll("[^a-zA-Z0-9\\-]", "_").toLowerCase();
                try {
                    adapter = (DefaultJDBCAdapter)factoryFinder.newInstance(dirverName);
                    LOG.info("Database driver recognized: [" + dirverName + "]");
                }
                catch (Throwable e) {
                    LOG.warn("Database driver NOT recognized: [" + dirverName + "].  Will use default JDBC implementation.");
                }
            }
            catch (SQLException e) {
                LOG.warn("JDBC error occurred while trying to detect database type.  Will use default JDBC implementation: " + e.getMessage());
                JDBCPersistenceAdapter.log("Failure Details: ", e);
            }
            if (adapter == null) {
                adapter = new DefaultJDBCAdapter();
            }
        }
        finally {
            c.close();
        }
        return adapter;
    }

    public void setAdapter(JDBCAdapter adapter) {
        this.adapter = adapter;
        this.adapter.setStatements(this.getStatements());
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public TransactionContext getTransactionContext(ConnectionContext context) throws IOException {
        if (context == null) {
            return this.getTransactionContext();
        }
        TransactionContext answer = (TransactionContext)context.getLongTermStoreContext();
        if (answer == null) {
            answer = new TransactionContext(this.getDataSource());
            context.setLongTermStoreContext(answer);
        }
        return answer;
    }

    public TransactionContext getTransactionContext() throws IOException {
        return new TransactionContext(this.getDataSource());
    }

    @Override
    public void beginTransaction(ConnectionContext context) throws IOException {
        TransactionContext transactionContext = this.getTransactionContext(context);
        transactionContext.begin();
    }

    @Override
    public void commitTransaction(ConnectionContext context) throws IOException {
        TransactionContext transactionContext = this.getTransactionContext(context);
        transactionContext.commit();
    }

    @Override
    public void rollbackTransaction(ConnectionContext context) throws IOException {
        TransactionContext transactionContext = this.getTransactionContext(context);
        transactionContext.rollback();
    }

    public int getCleanupPeriod() {
        return this.cleanupPeriod;
    }

    public void setCleanupPeriod(int cleanupPeriod) {
        this.cleanupPeriod = cleanupPeriod;
    }

    @Override
    public void deleteAllMessages() throws IOException {
        TransactionContext c = this.getTransactionContext();
        try {
            this.getAdapter().doDropTables(c);
            this.getAdapter().setUseExternalMessageReferences(this.isUseExternalMessageReferences());
            this.getAdapter().doCreateTables(c);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create(e);
        }
        finally {
            c.close();
        }
    }

    public boolean isUseExternalMessageReferences() {
        return this.useExternalMessageReferences;
    }

    public void setUseExternalMessageReferences(boolean useExternalMessageReferences) {
        this.useExternalMessageReferences = useExternalMessageReferences;
    }

    public boolean isCreateTablesOnStartup() {
        return this.createTablesOnStartup;
    }

    public void setCreateTablesOnStartup(boolean createTablesOnStartup) {
        this.createTablesOnStartup = createTablesOnStartup;
    }

    public boolean isUseDatabaseLock() {
        return this.useDatabaseLock;
    }

    public void setUseDatabaseLock(boolean useDatabaseLock) {
        this.useDatabaseLock = useDatabaseLock;
    }

    public static void log(String msg, SQLException e) {
        String s = msg + e.getMessage();
        while (e.getNextException() != null) {
            e = e.getNextException();
            s = s + ", due to: " + e.getMessage();
        }
        LOG.debug(s, e);
    }

    public Statements getStatements() {
        if (this.statements == null) {
            this.statements = new Statements();
        }
        return this.statements;
    }

    public void setStatements(Statements statements) {
        this.statements = statements;
    }

    @Override
    public void setUsageManager(SystemUsage usageManager) {
    }

    protected void databaseLockKeepAlive() {
        boolean stop = false;
        try {
            DatabaseLocker locker = this.getDatabaseLocker();
            if (locker != null && !locker.keepAlive()) {
                stop = true;
            }
        }
        catch (IOException e) {
            LOG.error("Failed to get database when trying keepalive: " + e, e);
        }
        if (stop) {
            this.stopBroker();
        }
    }

    protected void stopBroker() {
        LOG.info("No longer able to keep the exclusive lock so giving up being a master");
        try {
            this.brokerService.stop();
        }
        catch (Exception e) {
            LOG.warn("Failure occured while stopping broker");
        }
    }

    protected DatabaseLocker createDatabaseLocker() throws IOException {
        DefaultDatabaseLocker locker = new DefaultDatabaseLocker(this);
        locker.setLockAcquireSleepInterval(this.getLockAcquireSleepInterval());
        return locker;
    }

    @Override
    public void setBrokerName(String brokerName) {
    }

    @Override
    public String toString() {
        return "JDBCPersistenceAdaptor(" + super.toString() + ")";
    }

    @Override
    public void setDirectory(File dir) {
    }

    @Override
    public void checkpoint(boolean sync) throws IOException {
    }

    @Override
    public long size() {
        return 0L;
    }

    public long getLockKeepAlivePeriod() {
        return this.lockKeepAlivePeriod;
    }

    public void setLockKeepAlivePeriod(long lockKeepAlivePeriod) {
        this.lockKeepAlivePeriod = lockKeepAlivePeriod;
    }

    public long getLockAcquireSleepInterval() {
        return this.lockAcquireSleepInterval;
    }

    public void setLockAcquireSleepInterval(long lockAcquireSleepInterval) {
        this.lockAcquireSleepInterval = lockAcquireSleepInterval;
    }
}

