/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.activemq.broker.LockableServiceSupport;
import org.apache.activemq.util.IOHelper;
import org.apache.derby.jdbc.EmbeddedDataSource;

public abstract class DataSourceServiceSupport
extends LockableServiceSupport {
    private String dataDirectory = IOHelper.getDefaultDataDirectory();
    private File dataDirectoryFile;
    private DataSource dataSource;
    private DataSource createdDefaultDataSource;

    public DataSourceServiceSupport() {
    }

    public DataSourceServiceSupport(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public File getDataDirectoryFile() {
        if (this.dataDirectoryFile == null) {
            this.dataDirectoryFile = new File(this.getDataDirectory());
        }
        return this.dataDirectoryFile;
    }

    public void setDataDirectoryFile(File dataDirectory) {
        this.dataDirectoryFile = dataDirectory;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public DataSource getDataSource() throws IOException {
        if (this.dataSource == null) {
            this.dataSource = DataSourceServiceSupport.createDataSource(this.getDataDirectoryFile().getCanonicalPath());
            if (this.dataSource == null) {
                throw new IllegalArgumentException("No dataSource property has been configured");
            }
            this.createdDefaultDataSource = this.dataSource;
        }
        return this.dataSource;
    }

    public void closeDataSource(DataSource dataSource) {
        if (this.createdDefaultDataSource != null && this.createdDefaultDataSource.equals(dataSource)) {
            DataSourceServiceSupport.shutdownDefaultDataSource(dataSource);
            this.dataSource = null;
            this.createdDefaultDataSource = null;
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static DataSource createDataSource(String homeDir) throws IOException {
        System.setProperty("derby.system.home", homeDir);
        System.setProperty("derby.storage.fileSyncTransactionLog", "true");
        System.setProperty("derby.storage.pageCacheSize", "100");
        EmbeddedDataSource ds = new EmbeddedDataSource();
        ds.setDatabaseName("derbydb");
        ds.setCreateDatabase("create");
        return ds;
    }

    public static void shutdownDefaultDataSource(DataSource dataSource) {
        EmbeddedDataSource ds = (EmbeddedDataSource)dataSource;
        ds.setCreateDatabase("shutdown");
        ds.setShutdownDatabase("shutdown");
        try {
            ds.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String toString() {
        return "" + this.dataSource;
    }
}

