/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionMetaData;
import org.apache.activemq.ConfigurationException;
import org.apache.activemq.Service;
import org.apache.activemq.advisory.AdvisoryBroker;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.broker.CompositeDestinationBroker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ErrorBroker;
import org.apache.activemq.broker.MutableBrokerFilter;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.broker.TransactionBroker;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.UserIDBroker;
import org.apache.activemq.broker.cluster.ConnectionSplitBroker;
import org.apache.activemq.broker.ft.MasterConnector;
import org.apache.activemq.broker.jmx.AnnotatedMBean;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.broker.jmx.ConnectorView;
import org.apache.activemq.broker.jmx.FTConnectorView;
import org.apache.activemq.broker.jmx.JmsConnectorView;
import org.apache.activemq.broker.jmx.ManagedRegionBroker;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.jmx.NetworkConnectorView;
import org.apache.activemq.broker.jmx.ProxyConnectorView;
import org.apache.activemq.broker.region.CompositeDestinationInterceptor;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFactory;
import org.apache.activemq.broker.region.DestinationFactoryImpl;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.virtual.MirroredQueue;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualTopic;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreFactory;
import org.apache.activemq.network.ConnectionFilter;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.network.jms.JmsConnector;
import org.apache.activemq.proxy.ProxyConnector;
import org.apache.activemq.security.MessageAuthorizationPolicy;
import org.apache.activemq.security.SecurityContext;
import org.apache.activemq.selector.SelectorParser;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.PersistenceAdapterFactory;
import org.apache.activemq.store.amq.AMQPersistenceAdapterFactory;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.vm.VMTransportFactory;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.util.DefaultIOExceptionHandler;
import org.apache.activemq.util.IOExceptionHandler;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.JMXSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerService
implements Service {
    protected CountDownLatch slaveStartSignal = new CountDownLatch(1);
    public static final String DEFAULT_PORT = "61616";
    public static final String LOCAL_HOST_NAME;
    public static final String DEFAULT_BROKER_NAME = "localhost";
    private static final Log LOG;
    private static final long serialVersionUID = 7353129142305630237L;
    private boolean useJmx = true;
    private boolean enableStatistics = true;
    private boolean persistent = true;
    private boolean populateJMSXUserID;
    private boolean useShutdownHook = true;
    private boolean useLoggingForShutdownErrors;
    private boolean shutdownOnMasterFailure;
    private boolean shutdownOnSlaveFailure;
    private boolean waitForSlave;
    private long waitForSlaveTimeout = 600000L;
    private boolean passiveSlave;
    private String brokerName = "localhost";
    private File dataDirectoryFile;
    private File tmpDataDirectory;
    private Broker broker;
    private BrokerView adminView;
    private ManagementContext managementContext;
    private ObjectName brokerObjectName;
    private TaskRunnerFactory taskRunnerFactory;
    private TaskRunnerFactory persistenceTaskRunnerFactory;
    private SystemUsage systemUsage;
    private SystemUsage producerSystemUsage;
    private SystemUsage consumerSystemUsaage;
    private PersistenceAdapter persistenceAdapter;
    private PersistenceAdapterFactory persistenceFactory;
    protected DestinationFactory destinationFactory;
    private MessageAuthorizationPolicy messageAuthorizationPolicy;
    private List<TransportConnector> transportConnectors = new CopyOnWriteArrayList<TransportConnector>();
    private List<NetworkConnector> networkConnectors = new CopyOnWriteArrayList<NetworkConnector>();
    private List<ProxyConnector> proxyConnectors = new CopyOnWriteArrayList<ProxyConnector>();
    private List<JmsConnector> jmsConnectors = new CopyOnWriteArrayList<JmsConnector>();
    private List<Service> services = new ArrayList<Service>();
    private MasterConnector masterConnector;
    private String masterConnectorURI;
    private transient Thread shutdownHook;
    private String[] transportConnectorURIs;
    private String[] networkConnectorURIs;
    private JmsConnector[] jmsBridgeConnectors;
    private boolean deleteAllMessagesOnStartup;
    private boolean advisorySupport = true;
    private URI vmConnectorURI;
    private PolicyMap destinationPolicy;
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private BrokerPlugin[] plugins;
    private boolean keepDurableSubsActive = true;
    private boolean useVirtualTopics = true;
    private boolean useMirroredQueues = false;
    private boolean useTempMirroredQueues = true;
    private BrokerId brokerId;
    private DestinationInterceptor[] destinationInterceptors;
    private ActiveMQDestination[] destinations;
    private Store tempDataStore;
    private int persistenceThreadPriority = 10;
    private boolean useLocalHostBrokerName;
    private CountDownLatch stoppedLatch = new CountDownLatch(1);
    private CountDownLatch startedLatch = new CountDownLatch(1);
    private boolean supportFailOver;
    private Broker regionBroker;
    private int producerSystemUsagePortion = 60;
    private int consumerSystemUsagePortion = 40;
    private boolean splitSystemUsageForProducersConsumers;
    private boolean monitorConnectionSplits = false;
    private int taskRunnerPriority = 5;
    private boolean dedicatedTaskRunner;
    private boolean cacheTempDestinations = false;
    private int timeBeforePurgeTempDestinations = 5000;
    private List<Runnable> shutdownHooks = new ArrayList<Runnable>();
    private boolean systemExitOnShutdown;
    private int systemExitOnShutdownExitCode;
    private SslContext sslContext;
    private boolean forceStart = false;
    private IOExceptionHandler ioExceptionHandler;
    private boolean slave = true;

    public String toString() {
        return "BrokerService[" + this.getBrokerName() + "]";
    }

    public TransportConnector addConnector(String bindAddress) throws Exception {
        return this.addConnector(new URI(bindAddress));
    }

    public TransportConnector addConnector(URI bindAddress) throws Exception {
        return this.addConnector(this.createTransportConnector(bindAddress));
    }

    public TransportConnector addConnector(TransportServer transport) throws Exception {
        return this.addConnector(new TransportConnector(transport));
    }

    public TransportConnector addConnector(TransportConnector connector) throws Exception {
        this.transportConnectors.add(connector);
        return connector;
    }

    public boolean removeConnector(TransportConnector connector) throws Exception {
        boolean rc = this.transportConnectors.remove(connector);
        if (rc) {
            this.unregisterConnectorMBean(connector);
        }
        return rc;
    }

    public NetworkConnector addNetworkConnector(String discoveryAddress) throws Exception {
        return this.addNetworkConnector(new URI(discoveryAddress));
    }

    public ProxyConnector addProxyConnector(String bindAddress) throws Exception {
        return this.addProxyConnector(new URI(bindAddress));
    }

    public NetworkConnector addNetworkConnector(URI discoveryAddress) throws Exception {
        if (!this.isAdvisorySupport()) {
            throw new javax.jms.IllegalStateException("Networks require advisory messages to function - advisories are currently disabled");
        }
        DiscoveryNetworkConnector connector = new DiscoveryNetworkConnector(discoveryAddress);
        return this.addNetworkConnector(connector);
    }

    public ProxyConnector addProxyConnector(URI bindAddress) throws Exception {
        ProxyConnector connector = new ProxyConnector();
        connector.setBind(bindAddress);
        connector.setRemote(new URI("fanout:multicast://default"));
        return this.addProxyConnector(connector);
    }

    public NetworkConnector addNetworkConnector(NetworkConnector connector) throws Exception {
        connector.setBrokerService(this);
        URI uri = this.getVmConnectorURI();
        HashMap<String, String> map = new HashMap<String, String>(URISupport.parseParamters(uri));
        map.put("network", "true");
        uri = URISupport.createURIWithQuery(uri, URISupport.createQueryString(map));
        connector.setLocalUri(uri);
        connector.setConnectionFilter(new ConnectionFilter(){

            public boolean connectTo(URI location) {
                List<TransportConnector> transportConnectors = BrokerService.this.getTransportConnectors();
                Iterator<TransportConnector> iter = transportConnectors.iterator();
                while (iter.hasNext()) {
                    try {
                        TransportConnector tc = iter.next();
                        if (!location.equals(tc.getConnectUri())) continue;
                        return false;
                    }
                    catch (Throwable e) {
                    }
                }
                return true;
            }
        });
        this.networkConnectors.add(connector);
        if (this.isUseJmx()) {
            this.registerNetworkConnectorMBean(connector);
        }
        return connector;
    }

    public boolean removeNetworkConnector(NetworkConnector connector) {
        boolean answer = this.networkConnectors.remove(connector);
        if (answer) {
            this.unregisterNetworkConnectorMBean(connector);
        }
        return answer;
    }

    public ProxyConnector addProxyConnector(ProxyConnector connector) throws Exception {
        URI uri = this.getVmConnectorURI();
        connector.setLocalUri(uri);
        this.proxyConnectors.add(connector);
        if (this.isUseJmx()) {
            this.registerProxyConnectorMBean(connector);
        }
        return connector;
    }

    public JmsConnector addJmsConnector(JmsConnector connector) throws Exception {
        connector.setBrokerService(this);
        this.jmsConnectors.add(connector);
        if (this.isUseJmx()) {
            this.registerJmsConnectorMBean(connector);
        }
        return connector;
    }

    public JmsConnector removeJmsConnector(JmsConnector connector) {
        if (this.jmsConnectors.remove(connector)) {
            return connector;
        }
        return null;
    }

    public String getMasterConnectorURI() {
        return this.masterConnectorURI;
    }

    public void setMasterConnectorURI(String masterConnectorURI) {
        this.masterConnectorURI = masterConnectorURI;
    }

    public boolean isSlave() {
        return this.masterConnector != null && this.masterConnector.isSlave() || this.masterConnector != null && this.masterConnector.isStoppedBeforeStart() || this.masterConnector == null && this.slave;
    }

    public void masterFailed() {
        if (this.shutdownOnMasterFailure) {
            LOG.fatal("The Master has failed ... shutting down");
            try {
                this.stop();
            }
            catch (Exception e) {
                LOG.error("Failed to stop for master failure", e);
            }
        } else {
            LOG.warn("Master Failed - starting all connectors");
            try {
                this.startAllConnectors();
                this.broker.nowMasterBroker();
            }
            catch (Exception e) {
                LOG.error("Failed to startAllConnectors", e);
            }
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void start(boolean force) throws Exception {
        this.forceStart = force;
        this.stopped.set(false);
        this.started.set(false);
        this.start();
    }

    @Override
    @PostConstruct
    public void start() throws Exception {
        if (this.stopped.get() || !this.started.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.systemExitOnShutdown && this.useShutdownHook) {
                throw new ConfigurationException("'useShutdownHook' property cannot be be used with 'systemExitOnShutdown', please turn it off (useShutdownHook=false)");
            }
            this.processHelperProperties();
            if (this.isUseJmx()) {
                this.startManagementContext();
            }
            this.getPersistenceAdapter().setUsageManager(this.getProducerSystemUsage());
            this.getPersistenceAdapter().setBrokerName(this.getBrokerName());
            LOG.info("Using Persistence Adapter: " + this.getPersistenceAdapter());
            if (this.deleteAllMessagesOnStartup) {
                this.deleteAllMessages();
            }
            this.getPersistenceAdapter().start();
            this.slave = false;
            this.startDestinations();
            this.addShutdownHook();
            this.getBroker().start();
            if (this.isUseJmx()) {
                if (this.getManagementContext().isCreateConnector() && !this.getManagementContext().isConnectorStarted()) {
                    this.managementContext.stop();
                    this.startManagementContext();
                }
                ManagedRegionBroker managedBroker = (ManagedRegionBroker)this.regionBroker;
                managedBroker.setContextBroker(this.broker);
                this.adminView.setBroker(managedBroker);
            }
            BrokerRegistry.getInstance().bind(this.getBrokerName(), this);
            for (Service service : this.services) {
                if (!(service instanceof MasterConnector)) continue;
                this.configureService(service);
                service.start();
            }
            if (!(this.isSlave() || this.masterConnector != null && this.isShutdownOnMasterFailure())) {
                this.startAllConnectors();
            }
            if (!this.stopped.get() && this.isUseJmx() && this.masterConnector != null) {
                this.registerFTConnectorMBean(this.masterConnector);
            }
            this.brokerId = this.broker.getBrokerId();
            if (this.ioExceptionHandler == null) {
                this.setIoExceptionHandler(new DefaultIOExceptionHandler());
            }
            LOG.info("ActiveMQ JMS Message Broker (" + this.getBrokerName() + ", " + this.brokerId + ") started");
            this.getBroker().brokerServiceStarted();
            this.startedLatch.countDown();
        }
        catch (Exception e) {
            LOG.error("Failed to start ActiveMQ JMS Message Broker. Reason: " + e, e);
            try {
                if (!this.stopped.get()) {
                    this.stop();
                }
            }
            catch (Exception ex) {
                LOG.warn("Failed to stop broker after failure in start ", ex);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    public void stop() throws Exception {
        if (!this.started.get()) {
            return;
        }
        if (this.systemExitOnShutdown) {
            new Thread(){

                public void run() {
                    System.exit(BrokerService.this.systemExitOnShutdownExitCode);
                }
            }.start();
        }
        LOG.info("ActiveMQ Message Broker (" + this.getBrokerName() + ", " + this.brokerId + ") is shutting down");
        this.removeShutdownHook();
        ServiceStopper stopper = new ServiceStopper();
        if (this.services != null) {
            for (Service service : this.services) {
                stopper.stop(service);
            }
        }
        this.stopAllConnectors(stopper);
        BrokerRegistry.getInstance().unbind(this.getBrokerName());
        VMTransportFactory.stopped(this.getBrokerName());
        if (this.broker != null) {
            stopper.stop(this.broker);
        }
        if (this.tempDataStore != null) {
            this.tempDataStore.close();
        }
        stopper.stop(this.persistenceAdapter);
        this.slave = true;
        if (this.isUseJmx()) {
            stopper.stop(this.getManagementContext());
        }
        SelectorParser.clearCache();
        this.stopped.set(true);
        this.stoppedLatch.countDown();
        if (this.masterConnectorURI == null) {
            if (this.slaveStartSignal.getCount() == 1L) {
                this.started.set(false);
                this.slaveStartSignal.countDown();
            }
        } else {
            for (Service service : this.services) {
                MasterConnector mConnector;
                if (!(service instanceof MasterConnector) || (mConnector = (MasterConnector)service).isSlave()) continue;
                this.started.set(false);
                mConnector.stopBeforeConnected();
            }
        }
        LOG.info("ActiveMQ JMS Message Broker (" + this.getBrokerName() + ", " + this.brokerId + ") stopped");
        List<Runnable> list = this.shutdownHooks;
        synchronized (list) {
            for (Runnable hook : this.shutdownHooks) {
                try {
                    hook.run();
                }
                catch (Throwable e) {
                    stopper.onException(hook, e);
                }
            }
        }
        stopper.throwFirstException();
    }

    public boolean checkQueueSize(String queueName) {
        long count = 0L;
        long queueSize = 0L;
        Map<ActiveMQDestination, Destination> destinationMap = this.regionBroker.getDestinationMap();
        for (Map.Entry<ActiveMQDestination, Destination> entry : destinationMap.entrySet()) {
            if (!entry.getKey().isQueue() || !entry.getValue().getName().matches(queueName)) continue;
            count = queueSize = entry.getValue().getDestinationStatistics().getMessages().getCount();
            if (queueSize <= 0L) continue;
            LOG.info("Queue has pending message:" + entry.getValue().getName() + " queueSize is:" + queueSize);
        }
        return count == 0L;
    }

    public void stopGracefully(String connectorName, String queueName, long timeout, long pollInterval) throws Exception {
        if (this.isUseJmx()) {
            if (connectorName == null || queueName == null || timeout <= 0L) {
                throw new Exception("connectorName and queueName cannot be null and timeout should be >0 for stopGracefully.");
            }
            if (pollInterval <= 0L) {
                pollInterval = 30L;
            }
            LOG.info("Stop gracefully with connectorName:" + connectorName + " queueName:" + queueName + " timeout:" + timeout + " pollInterval:" + pollInterval);
            for (int i = 0; i < this.transportConnectors.size(); ++i) {
                TransportConnector connector = this.transportConnectors.get(i);
                if (connector == null || connector.getName() == null || !connector.getName().matches(connectorName)) continue;
                connector.stop();
            }
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() - start < timeout * 1000L) {
                if (this.checkQueueSize(queueName)) {
                    this.stop();
                    break;
                }
                Thread.sleep(pollInterval * 1000L);
            }
            if (this.stopped.get()) {
                LOG.info("Successfully stop the broker.");
            } else {
                LOG.info("There is still pending message on the queue. Please check and stop the broker manually.");
            }
        }
    }

    public void waitUntilStopped() {
        while (this.isStarted() && !this.stopped.get()) {
            try {
                this.stoppedLatch.await();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean waitUntilStarted() {
        boolean waitSucceeded = false;
        while (this.isStarted() && !this.stopped.get() && !waitSucceeded) {
            try {
                waitSucceeded = this.startedLatch.await(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        return waitSucceeded;
    }

    public Broker getBroker() throws Exception {
        if (this.broker == null) {
            LOG.info("ActiveMQ " + ActiveMQConnectionMetaData.PROVIDER_VERSION + " JMS Message Broker (" + this.getBrokerName() + ") is starting");
            LOG.info("For help or more information please see: http://activemq.apache.org/");
            this.broker = this.createBroker();
        }
        return this.broker;
    }

    public BrokerView getAdminView() throws Exception {
        if (this.adminView == null) {
            this.getBroker();
        }
        return this.adminView;
    }

    public void setAdminView(BrokerView adminView) {
        this.adminView = adminView;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        if (brokerName == null) {
            throw new NullPointerException("The broker name cannot be null");
        }
        String str = brokerName.replaceAll("[^a-zA-Z0-9\\.\\_\\-\\:]", "_");
        if (!str.equals(brokerName)) {
            LOG.error("Broker Name: " + brokerName + " contained illegal characters - replaced with " + str);
        }
        this.brokerName = str.trim();
    }

    public PersistenceAdapterFactory getPersistenceFactory() {
        if (this.persistenceFactory == null) {
            this.persistenceFactory = this.createPersistenceFactory();
        }
        return this.persistenceFactory;
    }

    public File getDataDirectoryFile() {
        if (this.dataDirectoryFile == null) {
            this.dataDirectoryFile = new File(IOHelper.getDefaultDataDirectory());
        }
        return this.dataDirectoryFile;
    }

    public File getBrokerDataDirectory() {
        String brokerDir = this.getBrokerName();
        return new File(this.getDataDirectoryFile(), brokerDir);
    }

    public void setDataDirectory(String dataDirectory) {
        this.setDataDirectoryFile(new File(dataDirectory));
    }

    public void setDataDirectoryFile(File dataDirectoryFile) {
        this.dataDirectoryFile = dataDirectoryFile;
    }

    public File getTmpDataDirectory() {
        if (this.tmpDataDirectory == null) {
            this.tmpDataDirectory = new File(this.getBrokerDataDirectory(), "tmp_storage");
        }
        return this.tmpDataDirectory;
    }

    public void setTmpDataDirectory(File tmpDataDirectory) {
        this.tmpDataDirectory = tmpDataDirectory;
    }

    public void setPersistenceFactory(PersistenceAdapterFactory persistenceFactory) {
        this.persistenceFactory = persistenceFactory;
    }

    public void setDestinationFactory(DestinationFactory destinationFactory) {
        this.destinationFactory = destinationFactory;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isPopulateJMSXUserID() {
        return this.populateJMSXUserID;
    }

    public void setPopulateJMSXUserID(boolean populateJMSXUserID) {
        this.populateJMSXUserID = populateJMSXUserID;
    }

    public SystemUsage getSystemUsage() {
        try {
            if (this.systemUsage == null) {
                this.systemUsage = new SystemUsage("Main", this.getPersistenceAdapter(), this.getTempDataStore());
                this.systemUsage.getMemoryUsage().setLimit(0x4000000L);
                this.systemUsage.getTempUsage().setLimit(0x1900000000L);
                this.systemUsage.getStoreUsage().setLimit(0x1900000000L);
                this.addService(this.systemUsage);
            }
            return this.systemUsage;
        }
        catch (IOException e) {
            LOG.fatal("Cannot create SystemUsage", e);
            throw new RuntimeException("Fatally failed to create SystemUsage" + e.getMessage());
        }
    }

    public void setSystemUsage(SystemUsage memoryManager) {
        if (this.systemUsage != null) {
            this.removeService(this.systemUsage);
        }
        this.systemUsage = memoryManager;
        this.addService(this.systemUsage);
    }

    public SystemUsage getConsumerSystemUsage() throws IOException {
        if (this.consumerSystemUsaage == null) {
            if (this.splitSystemUsageForProducersConsumers) {
                this.consumerSystemUsaage = new SystemUsage(this.getSystemUsage(), "Consumer");
                float portion = (float)this.consumerSystemUsagePortion / 100.0f;
                this.consumerSystemUsaage.getMemoryUsage().setUsagePortion(portion);
                this.addService(this.consumerSystemUsaage);
            } else {
                this.consumerSystemUsaage = this.getSystemUsage();
            }
        }
        return this.consumerSystemUsaage;
    }

    public void setConsumerSystemUsage(SystemUsage consumerSystemUsaage) {
        if (this.consumerSystemUsaage != null) {
            this.removeService(this.consumerSystemUsaage);
        }
        this.consumerSystemUsaage = consumerSystemUsaage;
        this.addService(this.consumerSystemUsaage);
    }

    public SystemUsage getProducerSystemUsage() throws IOException {
        if (this.producerSystemUsage == null) {
            if (this.splitSystemUsageForProducersConsumers) {
                this.producerSystemUsage = new SystemUsage(this.getSystemUsage(), "Producer");
                float portion = (float)this.producerSystemUsagePortion / 100.0f;
                this.producerSystemUsage.getMemoryUsage().setUsagePortion(portion);
                this.addService(this.producerSystemUsage);
            } else {
                this.producerSystemUsage = this.getSystemUsage();
            }
        }
        return this.producerSystemUsage;
    }

    public void setProducerSystemUsage(SystemUsage producerUsageManager) {
        if (this.producerSystemUsage != null) {
            this.removeService(this.producerSystemUsage);
        }
        this.producerSystemUsage = producerUsageManager;
        this.addService(this.producerSystemUsage);
    }

    public PersistenceAdapter getPersistenceAdapter() throws IOException {
        if (this.persistenceAdapter == null) {
            this.persistenceAdapter = this.createPersistenceAdapter();
            this.configureService(this.persistenceAdapter);
            this.persistenceAdapter = this.registerPersistenceAdapterMBean(this.persistenceAdapter);
        }
        return this.persistenceAdapter;
    }

    public void setPersistenceAdapter(PersistenceAdapter persistenceAdapter) throws IOException {
        this.persistenceAdapter = persistenceAdapter;
        this.configureService(this.persistenceAdapter);
        this.persistenceAdapter = this.registerPersistenceAdapterMBean(persistenceAdapter);
    }

    public TaskRunnerFactory getTaskRunnerFactory() {
        if (this.taskRunnerFactory == null) {
            this.taskRunnerFactory = new TaskRunnerFactory("BrokerService", this.getTaskRunnerPriority(), true, 1000, this.isDedicatedTaskRunner());
        }
        return this.taskRunnerFactory;
    }

    public void setTaskRunnerFactory(TaskRunnerFactory taskRunnerFactory) {
        this.taskRunnerFactory = taskRunnerFactory;
    }

    public TaskRunnerFactory getPersistenceTaskRunnerFactory() {
        if (this.taskRunnerFactory == null) {
            this.persistenceTaskRunnerFactory = new TaskRunnerFactory("Persistence Adaptor Task", this.persistenceThreadPriority, true, 1000, this.isDedicatedTaskRunner());
        }
        return this.persistenceTaskRunnerFactory;
    }

    public void setPersistenceTaskRunnerFactory(TaskRunnerFactory persistenceTaskRunnerFactory) {
        this.persistenceTaskRunnerFactory = persistenceTaskRunnerFactory;
    }

    public boolean isUseJmx() {
        return this.useJmx;
    }

    public boolean isEnableStatistics() {
        return this.enableStatistics;
    }

    public void setEnableStatistics(boolean enableStatistics) {
        this.enableStatistics = enableStatistics;
    }

    public void setUseJmx(boolean useJmx) {
        this.useJmx = useJmx;
    }

    public ObjectName getBrokerObjectName() throws IOException {
        if (this.brokerObjectName == null) {
            this.brokerObjectName = this.createBrokerObjectName();
        }
        return this.brokerObjectName;
    }

    public void setBrokerObjectName(ObjectName brokerObjectName) {
        this.brokerObjectName = brokerObjectName;
    }

    public ManagementContext getManagementContext() {
        if (this.managementContext == null) {
            this.managementContext = new ManagementContext();
        }
        return this.managementContext;
    }

    public void setManagementContext(ManagementContext managementContext) {
        this.managementContext = managementContext;
    }

    public NetworkConnector getNetworkConnectorByName(String connectorName) {
        for (NetworkConnector connector : this.networkConnectors) {
            if (!connector.getName().equals(connectorName)) continue;
            return connector;
        }
        return null;
    }

    public String[] getNetworkConnectorURIs() {
        return this.networkConnectorURIs;
    }

    public void setNetworkConnectorURIs(String[] networkConnectorURIs) {
        this.networkConnectorURIs = networkConnectorURIs;
    }

    public TransportConnector getConnectorByName(String connectorName) {
        for (TransportConnector connector : this.transportConnectors) {
            if (!connector.getName().equals(connectorName)) continue;
            return connector;
        }
        return null;
    }

    public Map<String, String> getTransportConnectorURIsAsMap() {
        HashMap<String, String> answer = new HashMap<String, String>();
        for (TransportConnector connector : this.transportConnectors) {
            try {
                URI uri = connector.getConnectUri();
                String scheme = uri.getScheme();
                if (scheme == null) continue;
                answer.put(scheme.toLowerCase(), uri.toString());
            }
            catch (Exception e) {
                LOG.debug("Failed to read URI to build transportURIsAsMap", e);
            }
        }
        return answer;
    }

    public String[] getTransportConnectorURIs() {
        return this.transportConnectorURIs;
    }

    public void setTransportConnectorURIs(String[] transportConnectorURIs) {
        this.transportConnectorURIs = transportConnectorURIs;
    }

    public JmsConnector[] getJmsBridgeConnectors() {
        return this.jmsBridgeConnectors;
    }

    public void setJmsBridgeConnectors(JmsConnector[] jmsConnectors) {
        this.jmsBridgeConnectors = jmsConnectors;
    }

    public Service[] getServices() {
        return this.services.toArray(new Service[0]);
    }

    public void setServices(Service[] services) {
        this.services.clear();
        if (services != null) {
            for (int i = 0; i < services.length; ++i) {
                this.services.add(services[i]);
            }
        }
    }

    public void addService(Service service) {
        this.services.add(service);
    }

    public void removeService(Service service) {
        this.services.remove(service);
    }

    public boolean isUseLoggingForShutdownErrors() {
        return this.useLoggingForShutdownErrors;
    }

    public void setUseLoggingForShutdownErrors(boolean useLoggingForShutdownErrors) {
        this.useLoggingForShutdownErrors = useLoggingForShutdownErrors;
    }

    public boolean isUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setUseShutdownHook(boolean useShutdownHook) {
        this.useShutdownHook = useShutdownHook;
    }

    public boolean isAdvisorySupport() {
        return this.advisorySupport;
    }

    public void setAdvisorySupport(boolean advisorySupport) {
        this.advisorySupport = advisorySupport;
    }

    public List<TransportConnector> getTransportConnectors() {
        return new ArrayList<TransportConnector>(this.transportConnectors);
    }

    public void setTransportConnectors(List<TransportConnector> transportConnectors) throws Exception {
        for (TransportConnector connector : transportConnectors) {
            this.addConnector(connector);
        }
    }

    public List<NetworkConnector> getNetworkConnectors() {
        return new ArrayList<NetworkConnector>(this.networkConnectors);
    }

    public List<ProxyConnector> getProxyConnectors() {
        return new ArrayList<ProxyConnector>(this.proxyConnectors);
    }

    public void setNetworkConnectors(List networkConnectors) throws Exception {
        for (NetworkConnector connector : networkConnectors) {
            this.addNetworkConnector(connector);
        }
    }

    public void setProxyConnectors(List proxyConnectors) throws Exception {
        for (ProxyConnector connector : proxyConnectors) {
            this.addProxyConnector(connector);
        }
    }

    public PolicyMap getDestinationPolicy() {
        return this.destinationPolicy;
    }

    public void setDestinationPolicy(PolicyMap policyMap) {
        this.destinationPolicy = policyMap;
    }

    public BrokerPlugin[] getPlugins() {
        return this.plugins;
    }

    public void setPlugins(BrokerPlugin[] plugins) {
        this.plugins = plugins;
    }

    public MessageAuthorizationPolicy getMessageAuthorizationPolicy() {
        return this.messageAuthorizationPolicy;
    }

    public void setMessageAuthorizationPolicy(MessageAuthorizationPolicy messageAuthorizationPolicy) {
        this.messageAuthorizationPolicy = messageAuthorizationPolicy;
    }

    public void deleteAllMessages() throws IOException {
        this.getPersistenceAdapter().deleteAllMessages();
    }

    public boolean isDeleteAllMessagesOnStartup() {
        return this.deleteAllMessagesOnStartup;
    }

    public void setDeleteAllMessagesOnStartup(boolean deletePersistentMessagesOnStartup) {
        this.deleteAllMessagesOnStartup = deletePersistentMessagesOnStartup;
    }

    public URI getVmConnectorURI() {
        if (this.vmConnectorURI == null) {
            try {
                this.vmConnectorURI = new URI("vm://" + this.getBrokerName().replaceAll("[^a-zA-Z0-9\\.\\_\\-]", "_"));
            }
            catch (URISyntaxException e) {
                LOG.error("Badly formed URI from " + this.getBrokerName(), e);
            }
        }
        return this.vmConnectorURI;
    }

    public void setVmConnectorURI(URI vmConnectorURI) {
        this.vmConnectorURI = vmConnectorURI;
    }

    public boolean isShutdownOnMasterFailure() {
        return this.shutdownOnMasterFailure;
    }

    public void setShutdownOnMasterFailure(boolean shutdownOnMasterFailure) {
        this.shutdownOnMasterFailure = shutdownOnMasterFailure;
    }

    public boolean isKeepDurableSubsActive() {
        return this.keepDurableSubsActive;
    }

    public void setKeepDurableSubsActive(boolean keepDurableSubsActive) {
        this.keepDurableSubsActive = keepDurableSubsActive;
    }

    public boolean isUseVirtualTopics() {
        return this.useVirtualTopics;
    }

    public void setUseVirtualTopics(boolean useVirtualTopics) {
        this.useVirtualTopics = useVirtualTopics;
    }

    public DestinationInterceptor[] getDestinationInterceptors() {
        return this.destinationInterceptors;
    }

    public boolean isUseMirroredQueues() {
        return this.useMirroredQueues;
    }

    public void setUseMirroredQueues(boolean useMirroredQueues) {
        this.useMirroredQueues = useMirroredQueues;
    }

    public void setDestinationInterceptors(DestinationInterceptor[] destinationInterceptors) {
        this.destinationInterceptors = destinationInterceptors;
    }

    public ActiveMQDestination[] getDestinations() {
        return this.destinations;
    }

    public void setDestinations(ActiveMQDestination[] destinations) {
        this.destinations = destinations;
    }

    public synchronized Store getTempDataStore() {
        if (this.tempDataStore == null) {
            if (!this.isPersistent()) {
                return null;
            }
            boolean result = true;
            boolean empty = true;
            try {
                File[] files;
                File directory = this.getTmpDataDirectory();
                if (directory.exists() && directory.isDirectory() && (files = directory.listFiles()) != null && files.length > 0) {
                    empty = false;
                    for (int i = 0; i < files.length; ++i) {
                        File file = files[i];
                        if (file.isDirectory()) continue;
                        result &= file.delete();
                    }
                }
                if (!empty) {
                    String str = result ? "Successfully deleted" : "Failed to delete";
                    LOG.info(str + " temporary storage");
                }
                this.tempDataStore = StoreFactory.open(this.getTmpDataDirectory(), "rw");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.tempDataStore;
    }

    public void setTempDataStore(Store tempDataStore) {
        this.tempDataStore = tempDataStore;
    }

    public int getPersistenceThreadPriority() {
        return this.persistenceThreadPriority;
    }

    public void setPersistenceThreadPriority(int persistenceThreadPriority) {
        this.persistenceThreadPriority = persistenceThreadPriority;
    }

    public boolean isUseLocalHostBrokerName() {
        return this.useLocalHostBrokerName;
    }

    public void setUseLocalHostBrokerName(boolean useLocalHostBrokerName) {
        this.useLocalHostBrokerName = useLocalHostBrokerName;
        if (useLocalHostBrokerName && !this.started.get() && this.brokerName == null || this.brokerName == DEFAULT_BROKER_NAME) {
            this.brokerName = LOCAL_HOST_NAME;
        }
    }

    public boolean isSupportFailOver() {
        return this.supportFailOver;
    }

    public void setSupportFailOver(boolean supportFailOver) {
        this.supportFailOver = supportFailOver;
    }

    public Destination getDestination(ActiveMQDestination destination) throws Exception {
        return this.getBroker().addDestination(this.getAdminConnectionContext(), destination);
    }

    public void removeDestination(ActiveMQDestination destination) throws Exception {
        this.getBroker().removeDestination(this.getAdminConnectionContext(), destination, 0L);
    }

    public int getProducerSystemUsagePortion() {
        return this.producerSystemUsagePortion;
    }

    public void setProducerSystemUsagePortion(int producerSystemUsagePortion) {
        this.producerSystemUsagePortion = producerSystemUsagePortion;
    }

    public int getConsumerSystemUsagePortion() {
        return this.consumerSystemUsagePortion;
    }

    public void setConsumerSystemUsagePortion(int consumerSystemUsagePortion) {
        this.consumerSystemUsagePortion = consumerSystemUsagePortion;
    }

    public boolean isSplitSystemUsageForProducersConsumers() {
        return this.splitSystemUsageForProducersConsumers;
    }

    public void setSplitSystemUsageForProducersConsumers(boolean splitSystemUsageForProducersConsumers) {
        this.splitSystemUsageForProducersConsumers = splitSystemUsageForProducersConsumers;
    }

    public boolean isMonitorConnectionSplits() {
        return this.monitorConnectionSplits;
    }

    public void setMonitorConnectionSplits(boolean monitorConnectionSplits) {
        this.monitorConnectionSplits = monitorConnectionSplits;
    }

    public int getTaskRunnerPriority() {
        return this.taskRunnerPriority;
    }

    public void setTaskRunnerPriority(int taskRunnerPriority) {
        this.taskRunnerPriority = taskRunnerPriority;
    }

    public boolean isDedicatedTaskRunner() {
        return this.dedicatedTaskRunner;
    }

    public void setDedicatedTaskRunner(boolean dedicatedTaskRunner) {
        this.dedicatedTaskRunner = dedicatedTaskRunner;
    }

    public boolean isCacheTempDestinations() {
        return this.cacheTempDestinations;
    }

    public void setCacheTempDestinations(boolean cacheTempDestinations) {
        this.cacheTempDestinations = cacheTempDestinations;
    }

    public int getTimeBeforePurgeTempDestinations() {
        return this.timeBeforePurgeTempDestinations;
    }

    public void setTimeBeforePurgeTempDestinations(int timeBeforePurgeTempDestinations) {
        this.timeBeforePurgeTempDestinations = timeBeforePurgeTempDestinations;
    }

    public boolean isUseTempMirroredQueues() {
        return this.useTempMirroredQueues;
    }

    public void setUseTempMirroredQueues(boolean useTempMirroredQueues) {
        this.useTempMirroredQueues = useTempMirroredQueues;
    }

    protected void processHelperProperties() throws Exception {
        String uri;
        int i;
        boolean masterServiceExists = false;
        if (this.transportConnectorURIs != null) {
            for (i = 0; i < this.transportConnectorURIs.length; ++i) {
                uri = this.transportConnectorURIs[i];
                this.addConnector(uri);
            }
        }
        if (this.networkConnectorURIs != null) {
            for (i = 0; i < this.networkConnectorURIs.length; ++i) {
                uri = this.networkConnectorURIs[i];
                this.addNetworkConnector(uri);
            }
        }
        if (this.jmsBridgeConnectors != null) {
            for (i = 0; i < this.jmsBridgeConnectors.length; ++i) {
                this.addJmsConnector(this.jmsBridgeConnectors[i]);
            }
        }
        for (Service service : this.services) {
            if (!(service instanceof MasterConnector)) continue;
            masterServiceExists = true;
            break;
        }
        if (this.masterConnectorURI != null) {
            if (masterServiceExists) {
                throw new IllegalStateException("Cannot specify masterConnectorURI when a masterConnector is already registered via the services property");
            }
            this.addService(new MasterConnector(this.masterConnectorURI));
        }
    }

    protected void stopAllConnectors(ServiceStopper stopper) {
        for (NetworkConnector networkConnector : this.getNetworkConnectors()) {
            this.unregisterNetworkConnectorMBean(networkConnector);
            stopper.stop(networkConnector);
        }
        for (ProxyConnector proxyConnector : this.getProxyConnectors()) {
            stopper.stop(proxyConnector);
        }
        for (JmsConnector jmsConnector : this.jmsConnectors) {
            stopper.stop(jmsConnector);
        }
        for (TransportConnector transportConnector : this.getTransportConnectors()) {
            stopper.stop(transportConnector);
        }
    }

    protected TransportConnector registerConnectorMBean(TransportConnector connector) throws IOException {
        try {
            ObjectName objectName = this.createConnectorObjectName(connector);
            connector = connector.asManagedConnector(this.getManagementContext(), objectName);
            ConnectorView view = new ConnectorView(connector);
            AnnotatedMBean.registerMBean(this.getManagementContext(), view, objectName);
            return connector;
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Transport Connector could not be registered in JMX: " + e.getMessage(), e);
        }
    }

    protected void unregisterConnectorMBean(TransportConnector connector) throws IOException {
        if (this.isUseJmx()) {
            try {
                ObjectName objectName = this.createConnectorObjectName(connector);
                this.getManagementContext().unregisterMBean(objectName);
            }
            catch (Throwable e) {
                throw IOExceptionSupport.create("Transport Connector could not be unregistered in JMX: " + e.getMessage(), e);
            }
        }
    }

    protected PersistenceAdapter registerPersistenceAdapterMBean(PersistenceAdapter adaptor) throws IOException {
        return adaptor;
    }

    protected void unregisterPersistenceAdapterMBean(PersistenceAdapter adaptor) throws IOException {
        if (this.isUseJmx()) {
            // empty if block
        }
    }

    private ObjectName createConnectorObjectName(TransportConnector connector) throws MalformedObjectNameException {
        return new ObjectName(this.getManagementContext().getJmxDomainName() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(this.getBrokerName()) + "," + "Type=Connector," + "ConnectorName=" + JMXSupport.encodeObjectNamePart(connector.getName()));
    }

    protected void registerNetworkConnectorMBean(NetworkConnector connector) throws IOException {
        NetworkConnectorView view = new NetworkConnectorView(connector);
        try {
            ObjectName objectName = this.createNetworkConnectorObjectName(connector);
            connector.setObjectName(objectName);
            AnnotatedMBean.registerMBean(this.getManagementContext(), view, objectName);
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Network Connector could not be registered in JMX: " + e.getMessage(), e);
        }
    }

    protected ObjectName createNetworkConnectorObjectName(NetworkConnector connector) throws MalformedObjectNameException {
        return new ObjectName(this.getManagementContext().getJmxDomainName() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(this.getBrokerName()) + "," + "Type=NetworkConnector," + "NetworkConnectorName=" + JMXSupport.encodeObjectNamePart(connector.getName()));
    }

    protected void unregisterNetworkConnectorMBean(NetworkConnector connector) {
        if (this.isUseJmx()) {
            try {
                ObjectName objectName = this.createNetworkConnectorObjectName(connector);
                this.getManagementContext().unregisterMBean(objectName);
            }
            catch (Exception e) {
                LOG.error("Network Connector could not be unregistered from JMX: " + e, e);
            }
        }
    }

    protected void registerProxyConnectorMBean(ProxyConnector connector) throws IOException {
        ProxyConnectorView view = new ProxyConnectorView(connector);
        try {
            ObjectName objectName = new ObjectName(this.getManagementContext().getJmxDomainName() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(this.getBrokerName()) + "," + "Type=ProxyConnector," + "ProxyConnectorName=" + JMXSupport.encodeObjectNamePart(connector.getName()));
            AnnotatedMBean.registerMBean(this.getManagementContext(), view, objectName);
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Broker could not be registered in JMX: " + e.getMessage(), e);
        }
    }

    protected void registerFTConnectorMBean(MasterConnector connector) throws IOException {
        FTConnectorView view = new FTConnectorView(connector);
        try {
            ObjectName objectName = new ObjectName(this.getManagementContext().getJmxDomainName() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(this.getBrokerName()) + "," + "Type=MasterConnector");
            AnnotatedMBean.registerMBean(this.getManagementContext(), view, objectName);
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Broker could not be registered in JMX: " + e.getMessage(), e);
        }
    }

    protected void registerJmsConnectorMBean(JmsConnector connector) throws IOException {
        JmsConnectorView view = new JmsConnectorView(connector);
        try {
            ObjectName objectName = new ObjectName(this.getManagementContext().getJmxDomainName() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(this.getBrokerName()) + "," + "Type=JmsConnector," + "JmsConnectorName=" + JMXSupport.encodeObjectNamePart(connector.getName()));
            AnnotatedMBean.registerMBean(this.getManagementContext(), view, objectName);
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Broker could not be registered in JMX: " + e.getMessage(), e);
        }
    }

    protected Broker createBroker() throws Exception {
        this.regionBroker = this.createRegionBroker();
        Broker broker = this.addInterceptors(this.regionBroker);
        broker = new MutableBrokerFilter(broker){
            Broker old;

            public void stop() throws Exception {
                this.old = this.next.getAndSet(new ErrorBroker("Broker has been stopped: " + this){

                    public void stop() throws Exception {
                    }
                });
                this.old.stop();
            }

            public void start() throws Exception {
                if (BrokerService.this.forceStart && this.old != null) {
                    this.next.set(this.old);
                }
                this.getNext().start();
            }
        };
        return broker;
    }

    protected Broker createRegionBroker() throws Exception {
        if (this.destinationInterceptors == null) {
            this.destinationInterceptors = this.createDefaultDestinationInterceptor();
        }
        this.configureServices(this.destinationInterceptors);
        CompositeDestinationInterceptor destinationInterceptor = new CompositeDestinationInterceptor(this.destinationInterceptors);
        if (this.destinationFactory == null) {
            this.destinationFactory = new DestinationFactoryImpl(this, this.getTaskRunnerFactory(), this.getPersistenceAdapter());
        }
        return this.createRegionBroker(destinationInterceptor);
    }

    protected Broker createRegionBroker(DestinationInterceptor destinationInterceptor) throws IOException {
        RegionBroker regionBroker = this.isUseJmx() ? new ManagedRegionBroker(this, this.getManagementContext(), this.getBrokerObjectName(), this.getTaskRunnerFactory(), this.getConsumerSystemUsage(), this.destinationFactory, destinationInterceptor) : new RegionBroker(this, this.getTaskRunnerFactory(), this.getConsumerSystemUsage(), this.destinationFactory, destinationInterceptor);
        this.destinationFactory.setRegionBroker(regionBroker);
        regionBroker.setKeepDurableSubsActive(this.keepDurableSubsActive);
        regionBroker.setBrokerName(this.getBrokerName());
        regionBroker.getDestinationStatistics().setEnabled(this.enableStatistics);
        return regionBroker;
    }

    protected DestinationInterceptor[] createDefaultDestinationInterceptor() {
        DestinationInterceptor interceptor;
        ArrayList<DestinationInterceptor> answer = new ArrayList<DestinationInterceptor>();
        if (this.isUseVirtualTopics()) {
            interceptor = new VirtualDestinationInterceptor();
            VirtualTopic virtualTopic = new VirtualTopic();
            virtualTopic.setName("VirtualTopic.>");
            VirtualDestination[] virtualDestinations = new VirtualDestination[]{virtualTopic};
            ((VirtualDestinationInterceptor)interceptor).setVirtualDestinations(virtualDestinations);
            answer.add(interceptor);
        }
        if (this.isUseMirroredQueues()) {
            interceptor = new MirroredQueue();
            answer.add(interceptor);
        }
        DestinationInterceptor[] array = new DestinationInterceptor[answer.size()];
        answer.toArray(array);
        return array;
    }

    protected Broker addInterceptors(Broker broker) throws Exception {
        if (this.isAdvisorySupport()) {
            broker = new AdvisoryBroker(broker);
        }
        broker = new CompositeDestinationBroker(broker);
        broker = new TransactionBroker(broker, this.getPersistenceAdapter().createTransactionStore());
        if (this.isPopulateJMSXUserID()) {
            broker = new UserIDBroker(broker);
        }
        if (this.isMonitorConnectionSplits()) {
            broker = new ConnectionSplitBroker(broker);
        }
        if (this.plugins != null) {
            for (int i = 0; i < this.plugins.length; ++i) {
                BrokerPlugin plugin = this.plugins[i];
                broker = plugin.installPlugin(broker);
            }
        }
        return broker;
    }

    protected PersistenceAdapter createPersistenceAdapter() throws IOException {
        if (this.isPersistent()) {
            return this.getPersistenceFactory().createPersistenceAdapter();
        }
        return new MemoryPersistenceAdapter();
    }

    protected AMQPersistenceAdapterFactory createPersistenceFactory() {
        AMQPersistenceAdapterFactory factory = new AMQPersistenceAdapterFactory();
        factory.setDataDirectory(this.getBrokerDataDirectory());
        factory.setTaskRunnerFactory(this.getPersistenceTaskRunnerFactory());
        factory.setBrokerName(this.getBrokerName());
        return factory;
    }

    protected ObjectName createBrokerObjectName() throws IOException {
        try {
            return new ObjectName(this.getManagementContext().getJmxDomainName() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(this.getBrokerName()) + "," + "Type=Broker");
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Invalid JMX broker name: " + this.brokerName, e);
        }
    }

    protected TransportConnector createTransportConnector(URI brokerURI) throws Exception {
        TransportServer transport = TransportFactory.bind(this, brokerURI);
        return new TransportConnector(transport);
    }

    protected Object getPort(Map options) {
        Object port = options.get("port");
        if (port == null) {
            port = DEFAULT_PORT;
            LOG.warn("No port specified so defaulting to: " + port);
        }
        return port;
    }

    protected void addShutdownHook() {
        if (this.useShutdownHook) {
            this.shutdownHook = new Thread("ActiveMQ ShutdownHook"){

                public void run() {
                    BrokerService.this.containerShutdown();
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    protected void removeShutdownHook() {
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Exception e) {
                LOG.debug("Caught exception, must be shutting down: " + e);
            }
        }
    }

    protected void containerShutdown() {
        try {
            this.stop();
        }
        catch (IOException e) {
            Throwable linkedException = e.getCause();
            if (linkedException != null) {
                this.logError("Failed to shut down: " + e + ". Reason: " + linkedException, linkedException);
            } else {
                this.logError("Failed to shut down: " + e, e);
            }
            if (!this.useLoggingForShutdownErrors) {
                e.printStackTrace(System.err);
            }
        }
        catch (Exception e) {
            this.logError("Failed to shut down: " + e, e);
        }
    }

    protected void logError(String message, Throwable e) {
        if (this.useLoggingForShutdownErrors) {
            LOG.error("Failed to shut down: " + e);
        } else {
            System.err.println("Failed to shut down: " + e);
        }
    }

    protected void startDestinations() throws Exception {
        if (this.destinations != null) {
            ConnectionContext adminConnectionContext = this.getAdminConnectionContext();
            for (int i = 0; i < this.destinations.length; ++i) {
                ActiveMQDestination destination = this.destinations[i];
                this.getBroker().addDestination(adminConnectionContext, destination);
            }
        }
    }

    public ConnectionContext getAdminConnectionContext() throws Exception {
        ConnectionContext adminConnectionContext = this.getBroker().getAdminConnectionContext();
        if (adminConnectionContext == null) {
            adminConnectionContext = this.createAdminConnectionContext();
            this.getBroker().setAdminConnectionContext(adminConnectionContext);
        }
        return adminConnectionContext;
    }

    protected ConnectionContext createAdminConnectionContext() throws Exception {
        ConnectionContext context = new ConnectionContext();
        context.setBroker(this.getBroker());
        context.setSecurityContext(SecurityContext.BROKER_SECURITY_CONTEXT);
        return context;
    }

    protected void waitForSlave() {
        try {
            if (!this.slaveStartSignal.await(this.waitForSlaveTimeout, TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException("Gave up waiting for slave to start after " + this.waitForSlaveTimeout + " milliseconds.");
            }
        }
        catch (InterruptedException e) {
            LOG.error("Exception waiting for slave:" + e);
        }
    }

    protected void slaveConnectionEstablished() {
        this.slaveStartSignal.countDown();
    }

    protected void startManagementContext() throws Exception {
        this.getManagementContext().start();
        this.adminView = new BrokerView(this, null);
        ObjectName objectName = this.getBrokerObjectName();
        AnnotatedMBean.registerMBean(this.getManagementContext(), this.adminView, objectName);
    }

    protected void startAllConnectors() throws Exception {
        if (!this.isSlave()) {
            Set<ActiveMQDestination> durableDestinations = this.getBroker().getDurableDestinations();
            ArrayList<TransportConnector> al = new ArrayList<TransportConnector>();
            for (TransportConnector connector : this.getTransportConnectors()) {
                connector.setBrokerService(this);
                al.add(this.startTransportConnector(connector));
            }
            if (al.size() > 0) {
                this.transportConnectors.clear();
                this.setTransportConnectors(al);
            }
            URI uri = this.getVmConnectorURI();
            HashMap<String, String> map = new HashMap<String, String>(URISupport.parseParamters(uri));
            map.put("network", "true");
            map.put("async", "false");
            uri = URISupport.createURIWithQuery(uri, URISupport.createQueryString(map));
            if (this.isWaitForSlave()) {
                this.waitForSlave();
            }
            if (!this.stopped.get()) {
                for (NetworkConnector networkConnector : this.getNetworkConnectors()) {
                    networkConnector.setLocalUri(uri);
                    networkConnector.setBrokerName(this.getBrokerName());
                    networkConnector.setDurableDestinations(durableDestinations);
                    networkConnector.start();
                }
                for (ProxyConnector proxyConnector : this.getProxyConnectors()) {
                    proxyConnector.start();
                }
                for (JmsConnector jmsConnector : this.jmsConnectors) {
                    jmsConnector.start();
                }
                for (Service service : this.services) {
                    this.configureService(service);
                    service.start();
                }
            }
        }
    }

    protected TransportConnector startTransportConnector(TransportConnector connector) throws Exception {
        connector.setTaskRunnerFactory(this.getTaskRunnerFactory());
        MessageAuthorizationPolicy policy = this.getMessageAuthorizationPolicy();
        if (policy != null) {
            connector.setMessageAuthorizationPolicy(policy);
        }
        if (this.isUseJmx()) {
            connector = this.registerConnectorMBean(connector);
        }
        connector.getStatistics().setEnabled(this.enableStatistics);
        connector.start();
        return connector;
    }

    protected void configureServices(Object[] services) {
        for (Object service : services) {
            this.configureService(service);
        }
    }

    protected void configureService(Object service) {
        if (service instanceof BrokerServiceAware) {
            BrokerServiceAware serviceAware = (BrokerServiceAware)service;
            serviceAware.setBrokerService(this);
        }
        if (this.masterConnector == null && service instanceof MasterConnector) {
            this.masterConnector = (MasterConnector)service;
            this.supportFailOver = true;
        }
    }

    public void handleIOException(IOException exception) {
        if (this.ioExceptionHandler != null) {
            this.ioExceptionHandler.handle(exception);
        } else {
            LOG.info("Ignoring IO exception, " + exception, exception);
        }
    }

    protected void startDestinationsInPersistenceStore(Broker broker) throws Exception {
        Set<ActiveMQDestination> destinations = this.destinationFactory.getDestinations();
        if (destinations != null) {
            Iterator<ActiveMQDestination> iter = destinations.iterator();
            ConnectionContext adminConnectionContext = broker.getAdminConnectionContext();
            if (adminConnectionContext == null) {
                ConnectionContext context = new ConnectionContext();
                context.setBroker(broker);
                adminConnectionContext = context;
                broker.setAdminConnectionContext(adminConnectionContext);
            }
            while (iter.hasNext()) {
                ActiveMQDestination destination = iter.next();
                broker.addDestination(adminConnectionContext, destination);
            }
        }
    }

    public Broker getRegionBroker() {
        return this.regionBroker;
    }

    public void setRegionBroker(Broker regionBroker) {
        this.regionBroker = regionBroker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownHook(Runnable hook) {
        List<Runnable> list = this.shutdownHooks;
        synchronized (list) {
            this.shutdownHooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShutdownHook(Runnable hook) {
        List<Runnable> list = this.shutdownHooks;
        synchronized (list) {
            this.shutdownHooks.remove(hook);
        }
    }

    public boolean isSystemExitOnShutdown() {
        return this.systemExitOnShutdown;
    }

    public void setSystemExitOnShutdown(boolean systemExitOnShutdown) {
        this.systemExitOnShutdown = systemExitOnShutdown;
    }

    public int getSystemExitOnShutdownExitCode() {
        return this.systemExitOnShutdownExitCode;
    }

    public void setSystemExitOnShutdownExitCode(int systemExitOnShutdownExitCode) {
        this.systemExitOnShutdownExitCode = systemExitOnShutdownExitCode;
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SslContext sslContext) {
        this.sslContext = sslContext;
    }

    public boolean isShutdownOnSlaveFailure() {
        return this.shutdownOnSlaveFailure;
    }

    public void setShutdownOnSlaveFailure(boolean shutdownOnSlaveFailure) {
        this.shutdownOnSlaveFailure = shutdownOnSlaveFailure;
    }

    public boolean isWaitForSlave() {
        return this.waitForSlave;
    }

    public void setWaitForSlave(boolean waitForSlave) {
        this.waitForSlave = waitForSlave;
    }

    public long getWaitForSlaveTimeout() {
        return this.waitForSlaveTimeout;
    }

    public void setWaitForSlaveTimeout(long waitForSlaveTimeout) {
        this.waitForSlaveTimeout = waitForSlaveTimeout;
    }

    public CountDownLatch getSlaveStartSignal() {
        return this.slaveStartSignal;
    }

    public boolean isPassiveSlave() {
        return this.passiveSlave;
    }

    public void setPassiveSlave(boolean passiveSlave) {
        this.passiveSlave = passiveSlave;
    }

    public void setIoExceptionHandler(IOExceptionHandler ioExceptionHandler) {
        ioExceptionHandler.setBrokerService(this);
        this.ioExceptionHandler = ioExceptionHandler;
    }

    static {
        LOG = LogFactory.getLog(BrokerService.class);
        String localHostName = DEFAULT_BROKER_NAME;
        try {
            localHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to resolve localhost");
        }
        LOCAL_HOST_NAME = localHostName;
    }
}

