/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.StompFrame;

public class StompSubscription {
    public static final String AUTO_ACK = "auto";
    public static final String CLIENT_ACK = "client";
    public static final String INDIVIDUAL_ACK = "client-individual";
    private final ProtocolConverter protocolConverter;
    private final String subscriptionId;
    private final ConsumerInfo consumerInfo;
    private final LinkedHashMap<MessageId, MessageDispatch> dispatchedMessage = new LinkedHashMap();
    private final LinkedList<MessageDispatch> unconsumedMessage = new LinkedList();
    private String ackMode = "auto";
    private ActiveMQDestination destination;
    private String transformation;

    public StompSubscription(ProtocolConverter stompTransport, String subscriptionId, ConsumerInfo consumerInfo, String transformation) {
        this.protocolConverter = stompTransport;
        this.subscriptionId = subscriptionId;
        this.consumerInfo = consumerInfo;
        this.transformation = transformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMessageDispatch(MessageDispatch md) throws IOException, JMSException {
        StompSubscription stompSubscription;
        ActiveMQMessage message = (ActiveMQMessage)md.getMessage();
        if (this.ackMode == CLIENT_ACK) {
            stompSubscription = this;
            synchronized (stompSubscription) {
                this.dispatchedMessage.put(message.getMessageId(), md);
            }
        } else if (this.ackMode == INDIVIDUAL_ACK) {
            stompSubscription = this;
            synchronized (stompSubscription) {
                this.dispatchedMessage.put(message.getMessageId(), md);
            }
        } else if (this.ackMode == AUTO_ACK) {
            MessageAck ack = new MessageAck(md, 2, 1);
            this.protocolConverter.getTransportFilter().sendToActiveMQ(ack);
        }
        boolean ignoreTransformation = false;
        if (this.transformation != null) {
            message.setReadOnlyProperties(false);
            message.setStringProperty("transformation", this.transformation);
        } else if (message.getStringProperty("transformation") != null) {
            ignoreTransformation = true;
        }
        StompFrame command = this.protocolConverter.convertMessage(message, ignoreTransformation);
        command.setAction("MESSAGE");
        if (this.subscriptionId != null) {
            command.getHeaders().put("subscription", this.subscriptionId);
        }
        this.protocolConverter.getTransportFilter().sendToStomp(command);
    }

    synchronized void onStompAbort(TransactionId transactionId) {
        this.unconsumedMessage.clear();
    }

    synchronized void onStompCommit(TransactionId transactionId) {
        Iterator<Map.Entry<MessageId, MessageDispatch>> iter = this.dispatchedMessage.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<MessageId, MessageDispatch> entry = iter.next();
            MessageId id = entry.getKey();
            MessageDispatch msg = entry.getValue();
            if (!this.unconsumedMessage.contains(msg)) continue;
            iter.remove();
        }
        this.unconsumedMessage.clear();
    }

    synchronized MessageAck onStompMessageAck(String messageId, TransactionId transactionId) {
        MessageId msgId = new MessageId(messageId);
        if (!this.dispatchedMessage.containsKey(msgId)) {
            return null;
        }
        MessageAck ack = new MessageAck();
        ack.setDestination(this.consumerInfo.getDestination());
        ack.setConsumerId(this.consumerInfo.getConsumerId());
        if (this.ackMode == CLIENT_ACK) {
            ack.setAckType((byte)2);
            int count = 0;
            Iterator<Map.Entry<MessageId, MessageDispatch>> iter = this.dispatchedMessage.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<MessageId, MessageDispatch> entry = iter.next();
                MessageId id = entry.getKey();
                MessageDispatch msg = entry.getValue();
                if (ack.getFirstMessageId() == null) {
                    ack.setFirstMessageId(id);
                }
                if (transactionId != null) {
                    if (!this.unconsumedMessage.contains(msg)) {
                        this.unconsumedMessage.add(msg);
                    }
                } else {
                    iter.remove();
                }
                ++count;
                if (!id.equals(msgId)) continue;
                ack.setLastMessageId(id);
                break;
            }
            ack.setMessageCount(count);
            if (transactionId != null) {
                ack.setTransactionId(transactionId);
            }
        } else if (this.ackMode == INDIVIDUAL_ACK) {
            ack.setAckType((byte)4);
            ack.setMessageID(msgId);
            if (transactionId != null) {
                this.unconsumedMessage.add(this.dispatchedMessage.get(msgId));
                ack.setTransactionId(transactionId);
            }
            this.dispatchedMessage.remove(msgId);
        }
        return ack;
    }

    public String getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(String ackMode) {
        this.ackMode = ackMode;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setDestination(ActiveMQDestination destination) {
        this.destination = destination;
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public ConsumerInfo getConsumerInfo() {
        return this.consumerInfo;
    }
}

