/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util.oxm;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.activemq.util.oxm.AbstractXMLMessageTransformer;
import org.springframework.oxm.AbstractMarshaller;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.StringSource;

public class OXMMessageTransformer
extends AbstractXMLMessageTransformer {
    private AbstractMarshaller marshaller;

    public AbstractMarshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(AbstractMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    protected String marshall(Session session, ObjectMessage objectMessage) throws JMSException {
        StringResult result = new StringResult();
        try {
            this.marshaller.marshal((Object)objectMessage.getObject(), (Result)result);
            return result.toString();
        }
        catch (Exception e) {
            throw new JMSException(e.getMessage());
        }
    }

    protected Object unmarshall(Session session, TextMessage textMessage) throws JMSException {
        try {
            return this.marshaller.unmarshal((Source)new StringSource(textMessage.getText()));
        }
        catch (Exception e) {
            throw new JMSException(e.getMessage());
        }
    }
}

