/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import org.apache.activemq.util.ByteArrayInputStream;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;

public abstract class TextWireFormat
implements WireFormat {
    public abstract Object unmarshalText(String var1);

    public abstract Object unmarshalText(Reader var1);

    public abstract String marshalText(Object var1);

    @Override
    public void marshal(Object command, DataOutput out) throws IOException {
        String text = this.marshalText(command);
        byte[] utf8 = text.getBytes("UTF-8");
        out.writeInt(utf8.length);
        out.write(utf8);
    }

    @Override
    public Object unmarshal(DataInput in) throws IOException {
        int length = in.readInt();
        byte[] utf8 = new byte[length];
        in.readFully(utf8);
        String text = new String(utf8, "UTF-8");
        return this.unmarshalText(text);
    }

    @Override
    public ByteSequence marshal(Object command) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        this.marshal(command, dos);
        dos.close();
        return baos.toByteSequence();
    }

    @Override
    public Object unmarshal(ByteSequence packet) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(packet);
        DataInputStream dis = new DataInputStream(stream);
        return this.unmarshal(dis);
    }

    public boolean inReceive() {
        return false;
    }
}

