/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.net.URISyntaxException;
import javax.jms.Connection;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.util.JmsLogAppenderSupport;

public class JmsLogAppender
extends JmsLogAppenderSupport {
    private String uri = "tcp://localhost:61616";
    private String userName;
    private String password;

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    protected Connection createConnection() throws JMSException {
        if (this.userName != null) {
            try {
                return ActiveMQConnection.makeConnection(this.userName, this.password, this.uri);
            }
            catch (URISyntaxException e) {
                throw new JMSException("Unable to connect to a broker using userName: '" + this.userName + "' password '" + this.password + "' uri '" + this.uri + "' :: error - " + e.getMessage());
            }
        }
        try {
            return ActiveMQConnection.makeConnection(this.uri);
        }
        catch (URISyntaxException e) {
            throw new JMSException("Unable to connect to a broker using uri '" + this.uri + "' :: error - " + e.getMessage());
        }
    }
}

