/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws;

import java.io.IOException;
import java.security.cert.X509Certificate;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.TransportSupport;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompInactivityMonitor;
import org.apache.activemq.transport.stomp.StompTransport;
import org.apache.activemq.transport.stomp.StompWireFormat;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.eclipse.jetty.websocket.WebSocket;

class StompSocket
extends TransportSupport
implements WebSocket,
StompTransport {
    WebSocket.Outbound outbound;
    ProtocolConverter protocolConverter = new ProtocolConverter(this, null);
    StompWireFormat wireFormat = new StompWireFormat();

    StompSocket() {
    }

    public void onConnect(WebSocket.Outbound outbound) {
        this.outbound = outbound;
    }

    public void onMessage(byte frame, byte[] data, int offset, int length) {
    }

    public void onMessage(byte frame, String data) {
        try {
            this.protocolConverter.onStompCommand((StompFrame)this.wireFormat.unmarshal(new ByteSequence(data.getBytes("UTF-8"))));
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    public void onDisconnect() {
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
    }

    @Override
    public int getReceiveCounter() {
        return 0;
    }

    @Override
    public String getRemoteAddress() {
        return "StompSocket_" + this.hashCode();
    }

    @Override
    public void oneway(Object command) throws IOException {
        try {
            this.protocolConverter.onActiveMQCommand((Command)command);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    @Override
    public X509Certificate[] getPeerCertificates() {
        return null;
    }

    @Override
    public void sendToActiveMQ(Command command) {
        this.doConsume(command);
    }

    @Override
    public void sendToStomp(StompFrame command) throws IOException {
        this.outbound.sendMessage((byte)0, command.format());
    }

    @Override
    public StompInactivityMonitor getInactivityMonitor() {
        return null;
    }

    @Override
    public StompWireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void onFragment(boolean more, byte opcode, byte[] data, int offset, int length) {
    }
}

