/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.console.command.AbstractCommand;
import org.apache.activemq.util.ConsumerThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerCommand
extends AbstractCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerCommand.class);
    String brokerUrl = ActiveMQConnectionFactory.DEFAULT_BROKER_URL;
    String user = ActiveMQConnectionFactory.DEFAULT_USER;
    String password = ActiveMQConnectionFactory.DEFAULT_PASSWORD;
    String destination = "queue://TEST";
    int messageCount = 1000;
    int sleep;
    boolean transacted;
    private boolean durable;
    private String clientId;
    int batchSize = 10;
    int ackMode = 1;
    int parallelThreads = 1;
    boolean bytesAsText;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTask(List<String> tokens) throws Exception {
        LOG.info("Connecting to URL: " + this.brokerUrl + " (" + this.user + ":" + this.password + ")");
        LOG.info("Consuming " + this.destination);
        LOG.info("Sleeping between receives " + this.sleep + " ms");
        LOG.info("Running " + this.parallelThreads + " parallel threads");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerUrl);
        try (Connection conn = null;){
            conn = factory.createConnection(this.user, this.password);
            if (this.durable && this.clientId != null && this.clientId.length() > 0 && !"null".equals(this.clientId)) {
                conn.setClientID(this.clientId);
            }
            conn.start();
            Session sess = this.transacted ? conn.createSession(true, 0) : conn.createSession(false, this.ackMode);
            CountDownLatch active = new CountDownLatch(this.parallelThreads);
            for (int i = 1; i <= this.parallelThreads; ++i) {
                ConsumerThread consumer = new ConsumerThread(sess, (Destination)ActiveMQDestination.createDestination((String)this.destination, (byte)1));
                consumer.setName("consumer-" + i);
                consumer.setDurable(this.durable);
                consumer.setBreakOnNull(false);
                consumer.setMessageCount(this.messageCount);
                consumer.setSleep(this.sleep);
                consumer.setBatchSize(this.batchSize);
                consumer.setFinished(active);
                consumer.setBytesAsText(this.bytesAsText);
                consumer.start();
            }
            active.await();
        }
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public int getSleep() {
        return this.sleep;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getParallelThreads() {
        return this.parallelThreads;
    }

    public void setParallelThreads(int parallelThreads) {
        this.parallelThreads = parallelThreads;
    }

    public boolean isBytesAsText() {
        return this.bytesAsText;
    }

    public void setBytesAsText(boolean bytesAsText) {
        this.bytesAsText = bytesAsText;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public int getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(String ackMode) {
        if ("CLIENT_ACKNOWLEDGE".equals(ackMode)) {
            this.ackMode = 2;
        }
        if ("AUTO_ACKNOWLEDGE".equals(ackMode)) {
            this.ackMode = 1;
        }
        if ("DUPS_OK_ACKNOWLEDGE".equals(ackMode)) {
            this.ackMode = 3;
        }
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    protected void printHelp() {
        this.printHelpFromFile();
    }

    @Override
    public String getName() {
        return "consumer";
    }

    @Override
    public String getOneLineDescription() {
        return "Receives messages from the broker";
    }
}

