/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jpa;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.jpa.JPAPersistenceAdapter;
import org.apache.activemq.store.jpa.model.StoredMessage;
import org.apache.activemq.usage.MemoryUsage;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.wireformat.WireFormat;

public class JPAMessageStore
implements MessageStore {
    protected final JPAPersistenceAdapter adapter;
    protected final WireFormat wireFormat;
    protected final ActiveMQDestination destination;
    protected final String destinationName;
    protected AtomicLong lastMessageId = new AtomicLong(-1L);

    public JPAMessageStore(JPAPersistenceAdapter adapter, ActiveMQDestination destination) {
        this.adapter = adapter;
        this.destination = destination;
        this.destinationName = destination.getQualifiedName();
        this.wireFormat = this.adapter.getWireFormat();
    }

    public void addMessage(ConnectionContext context, Message message) throws IOException {
        EntityManager manager = this.adapter.beginEntityManager(context);
        try {
            ByteSequence sequence = this.wireFormat.marshal((Object)message);
            sequence.compact();
            StoredMessage sm = new StoredMessage();
            sm.setDestination(this.destinationName);
            sm.setId(message.getMessageId().getBrokerSequenceId());
            sm.setMessageId(message.getMessageId().toString());
            sm.setExiration(message.getExpiration());
            sm.setData(sequence.data);
            manager.persist((Object)sm);
        }
        catch (Throwable e) {
            this.adapter.rollbackEntityManager(context, manager);
            throw IOExceptionSupport.create((Throwable)e);
        }
        this.adapter.commitEntityManager(context, manager);
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public Message getMessage(MessageId identity) throws IOException {
        Message rc;
        EntityManager manager = this.adapter.beginEntityManager(null);
        try {
            StoredMessage message = null;
            if (identity.getBrokerSequenceId() != 0L) {
                message = (StoredMessage)manager.find(StoredMessage.class, (Object)identity.getBrokerSequenceId());
            } else {
                Query query = manager.createQuery("select m from StoredMessage m where m.messageId=?1");
                query.setParameter(1, (Object)identity.toString());
                message = (StoredMessage)query.getSingleResult();
            }
            rc = (Message)this.wireFormat.unmarshal(new ByteSequence(message.getData()));
        }
        catch (Throwable e) {
            this.adapter.rollbackEntityManager(null, manager);
            throw IOExceptionSupport.create((Throwable)e);
        }
        this.adapter.commitEntityManager(null, manager);
        return rc;
    }

    public int getMessageCount() throws IOException {
        Long rc;
        EntityManager manager = this.adapter.beginEntityManager(null);
        try {
            Query query = manager.createQuery("select count(m) from StoredMessage m");
            rc = (Long)query.getSingleResult();
        }
        catch (Throwable e) {
            this.adapter.rollbackEntityManager(null, manager);
            throw IOExceptionSupport.create((Throwable)e);
        }
        this.adapter.commitEntityManager(null, manager);
        return rc.intValue();
    }

    public void recover(MessageRecoveryListener container) throws Exception {
        EntityManager manager = this.adapter.beginEntityManager(null);
        try {
            Query query = manager.createQuery("select m from StoredMessage m where m.destination=?1 order by m.id asc");
            query.setParameter(1, (Object)this.destinationName);
            for (StoredMessage m : query.getResultList()) {
                Message message = (Message)this.wireFormat.unmarshal(new ByteSequence(m.getData()));
                container.recoverMessage(message);
            }
        }
        catch (Throwable e) {
            this.adapter.rollbackEntityManager(null, manager);
            throw IOExceptionSupport.create((Throwable)e);
        }
        this.adapter.commitEntityManager(null, manager);
    }

    public void recoverNextMessages(int maxReturned, MessageRecoveryListener listener) throws Exception {
        EntityManager manager = this.adapter.beginEntityManager(null);
        try {
            Query query = manager.createQuery("select m from StoredMessage m where m.destination=?1 and m.id>?2 order by m.id asc");
            query.setParameter(1, (Object)this.destinationName);
            query.setParameter(2, (Object)this.lastMessageId.get());
            query.setMaxResults(maxReturned);
            int count = 0;
            for (StoredMessage m : query.getResultList()) {
                Message message = (Message)this.wireFormat.unmarshal(new ByteSequence(m.getData()));
                listener.recoverMessage(message);
                this.lastMessageId.set(m.getId());
                if (++count < maxReturned) continue;
                return;
            }
        }
        catch (Throwable e) {
            this.adapter.rollbackEntityManager(null, manager);
            throw IOExceptionSupport.create((Throwable)e);
        }
        this.adapter.commitEntityManager(null, manager);
    }

    public void removeAllMessages(ConnectionContext context) throws IOException {
        EntityManager manager = this.adapter.beginEntityManager(context);
        try {
            Query query = manager.createQuery("delete from StoredMessage m where m.destination=?1");
            query.setParameter(1, (Object)this.destinationName);
            query.executeUpdate();
        }
        catch (Throwable e) {
            this.adapter.rollbackEntityManager(context, manager);
            throw IOExceptionSupport.create((Throwable)e);
        }
        this.adapter.commitEntityManager(context, manager);
    }

    public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
        EntityManager manager = this.adapter.beginEntityManager(context);
        try {
            Query query = manager.createQuery("delete from StoredMessage m where m.id=?1");
            query.setParameter(1, (Object)ack.getLastMessageId().getBrokerSequenceId());
            query.executeUpdate();
        }
        catch (Throwable e) {
            this.adapter.rollbackEntityManager(context, manager);
            throw IOExceptionSupport.create((Throwable)e);
        }
        this.adapter.commitEntityManager(context, manager);
    }

    public void resetBatching() {
        this.lastMessageId.set(-1L);
    }

    public void setMemoryUsage(MemoryUsage memoeyUSage) {
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }
}

