/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jpa;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.ReferenceStore;
import org.apache.activemq.store.ReferenceStoreAdapter;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TopicReferenceStore;
import org.apache.activemq.store.amq.AMQTx;
import org.apache.activemq.store.jpa.JPAPersistenceAdapter;
import org.apache.activemq.store.jpa.JPAReferenceStore;
import org.apache.activemq.store.jpa.JPATopicReferenceStore;
import org.apache.activemq.util.IOExceptionSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAReferenceStoreAdapter
extends JPAPersistenceAdapter
implements ReferenceStoreAdapter {
    @Override
    public MessageStore createQueueMessageStore(ActiveMQQueue destination) throws IOException {
        throw new RuntimeException("Use createQueueReferenceStore instead.");
    }

    @Override
    public TopicMessageStore createTopicMessageStore(ActiveMQTopic destination) throws IOException {
        throw new RuntimeException("Use createTopicReferenceStore instead.");
    }

    public ReferenceStore createQueueReferenceStore(ActiveMQQueue destination) throws IOException {
        JPAReferenceStore rc = new JPAReferenceStore(this, (ActiveMQDestination)destination);
        return rc;
    }

    public TopicReferenceStore createTopicReferenceStore(ActiveMQTopic destination) throws IOException {
        JPATopicReferenceStore rc = new JPATopicReferenceStore(this, (ActiveMQDestination)destination);
        return rc;
    }

    @Override
    public void deleteAllMessages() throws IOException {
        EntityManager manager = this.beginEntityManager(null);
        try {
            Query query = manager.createQuery("delete from StoredMessageReference m");
            query.executeUpdate();
            query = manager.createQuery("delete from StoredSubscription ss");
            query.executeUpdate();
        }
        catch (Throwable e) {
            this.rollbackEntityManager(null, manager);
            throw IOExceptionSupport.create((Throwable)e);
        }
        this.commitEntityManager(null, manager);
    }

    @Override
    public Set<ActiveMQDestination> getDestinations() {
        HashSet<ActiveMQDestination> rc = new HashSet<ActiveMQDestination>();
        EntityManager manager = this.beginEntityManager(null);
        try {
            Query query = manager.createQuery("select distinct m.destination from StoredMessageReference m");
            for (String dest : query.getResultList()) {
                rc.add(ActiveMQDestination.createDestination((String)dest, (byte)1));
            }
        }
        catch (RuntimeException e) {
            this.rollbackEntityManager(null, manager);
            throw e;
        }
        this.commitEntityManager(null, manager);
        return rc;
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        long rc = 0L;
        EntityManager manager = this.beginEntityManager(null);
        try {
            Query query = manager.createQuery("select max(m.id) from StoredMessageReference m");
            Long t = (Long)query.getSingleResult();
            if (t != null) {
                rc = t;
            }
        }
        catch (Throwable e) {
            this.rollbackEntityManager(null, manager);
            throw IOExceptionSupport.create((Throwable)e);
        }
        this.commitEntityManager(null, manager);
        return rc;
    }

    public Set<Integer> getReferenceFileIdsInUse() throws IOException {
        HashSet<Integer> rc = null;
        EntityManager manager = this.beginEntityManager(null);
        try {
            Query query = manager.createQuery("select distinct m.fileId from StoredMessageReference m");
            rc = new HashSet<Integer>(query.getResultList());
        }
        catch (Throwable e) {
            this.rollbackEntityManager(null, manager);
            throw IOExceptionSupport.create((Throwable)e);
        }
        this.commitEntityManager(null, manager);
        return rc;
    }

    public boolean isStoreValid() {
        return false;
    }

    public void clearMessages() {
    }

    public void recoverState() {
    }

    public Map<TransactionId, AMQTx> retrievePreparedState() throws IOException {
        return null;
    }

    public void savePreparedState(Map<TransactionId, AMQTx> map) throws IOException {
    }

    public long getMaxDataFileLength() {
        return 0L;
    }

    public void setMaxDataFileLength(long maxDataFileLength) {
    }
}

