/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Checksum;

public abstract class FSOutputSummer
extends OutputStream {
    private Checksum sum;
    private byte[] buf;
    private byte[] checksum;
    private int count;

    protected FSOutputSummer(Checksum sum, int maxChunkSize, int checksumSize) {
        this.sum = sum;
        this.buf = new byte[maxChunkSize];
        this.checksum = new byte[checksumSize];
        this.count = 0;
    }

    protected abstract void writeChunk(byte[] var1, int var2, int var3, byte[] var4) throws IOException;

    @Override
    public synchronized void write(int b) throws IOException {
        this.sum.update(b);
        this.buf[this.count++] = (byte)b;
        if (this.count == this.buf.length) {
            this.flushBuffer();
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += this.write1(b, off + n, len - n)) {
        }
    }

    private int write1(byte[] b, int off, int len) throws IOException {
        if (this.count == 0 && len >= this.buf.length) {
            int length = this.buf.length;
            this.sum.update(b, off, length);
            this.writeChecksumChunk(b, off, length, false);
            return length;
        }
        int bytesToCopy = this.buf.length - this.count;
        bytesToCopy = len < bytesToCopy ? len : bytesToCopy;
        this.sum.update(b, off, bytesToCopy);
        System.arraycopy(b, off, this.buf, this.count, bytesToCopy);
        this.count += bytesToCopy;
        if (this.count == this.buf.length) {
            this.flushBuffer();
        }
        return bytesToCopy;
    }

    protected synchronized void flushBuffer() throws IOException {
        this.flushBuffer(false);
    }

    protected synchronized void flushBuffer(boolean keep) throws IOException {
        if (this.count != 0) {
            int chunkLen = this.count;
            this.count = 0;
            this.writeChecksumChunk(this.buf, 0, chunkLen, keep);
            if (keep) {
                this.count = chunkLen;
            }
        }
    }

    private void writeChecksumChunk(byte[] b, int off, int len, boolean keep) throws IOException {
        int tempChecksum = (int)this.sum.getValue();
        if (!keep) {
            this.sum.reset();
        }
        FSOutputSummer.int2byte(tempChecksum, this.checksum);
        this.writeChunk(b, off, len, this.checksum);
    }

    public static byte[] convertToByteStream(Checksum sum, int checksumSize) {
        return FSOutputSummer.int2byte((int)sum.getValue(), new byte[checksumSize]);
    }

    static byte[] int2byte(int integer, byte[] bytes) {
        bytes[0] = (byte)(integer >>> 24 & 0xFF);
        bytes[1] = (byte)(integer >>> 16 & 0xFF);
        bytes[2] = (byte)(integer >>> 8 & 0xFF);
        bytes[3] = (byte)(integer >>> 0 & 0xFF);
        return bytes;
    }

    protected synchronized void resetChecksumChunk(int size2) {
        this.sum.reset();
        this.buf = new byte[size2];
        this.count = 0;
    }
}

