/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class Path
implements Comparable {
    public static final String SEPARATOR = "/";
    public static final char SEPARATOR_CHAR = '/';
    public static final String CUR_DIR = ".";
    static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private URI uri;

    public Path(String parent, String child) {
        this(new Path(parent), new Path(child));
    }

    public Path(Path parent, String child) {
        this(parent, new Path(child));
    }

    public Path(String parent, Path child) {
        this(new Path(parent), child);
    }

    public Path(Path parent, Path child) {
        URI parentUri = parent.uri;
        String parentPath = parentUri.getPath();
        if (!parentPath.equals(SEPARATOR) && !parentPath.equals("")) {
            try {
                parentUri = new URI(parentUri.getScheme(), parentUri.getAuthority(), parentUri.getPath() + SEPARATOR, null, parentUri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        URI resolved = parentUri.resolve(child.uri);
        this.initialize(resolved.getScheme(), resolved.getAuthority(), this.normalizePath(resolved.getPath()), resolved.getFragment());
    }

    private void checkPathArg(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Can not create a Path from a null string");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("Can not create a Path from an empty string");
        }
    }

    public Path(String pathString) {
        this.checkPathArg(pathString);
        if (this.hasWindowsDrive(pathString, false)) {
            pathString = SEPARATOR + pathString;
        }
        String scheme = null;
        String authority = null;
        int start2 = 0;
        int colon = pathString.indexOf(58);
        int slash = pathString.indexOf(47);
        if (colon != -1 && (slash == -1 || colon < slash)) {
            scheme = pathString.substring(0, colon);
            start2 = colon + 1;
        }
        if (pathString.startsWith("//", start2) && pathString.length() - start2 > 2) {
            int nextSlash = pathString.indexOf(47, start2 + 2);
            int authEnd = nextSlash > 0 ? nextSlash : pathString.length();
            authority = pathString.substring(start2 + 2, authEnd);
            start2 = authEnd;
        }
        String path = pathString.substring(start2, pathString.length());
        this.initialize(scheme, authority, path, null);
    }

    public Path(String scheme, String authority, String path) {
        this.checkPathArg(path);
        this.initialize(scheme, authority, path, null);
    }

    public Path(URI aUri) {
        this.uri = aUri;
    }

    private void initialize(String scheme, String authority, String path, String fragment) {
        try {
            this.uri = new URI(scheme, authority, this.normalizePath(path), null, fragment).normalize();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String normalizePath(String path) {
        int minLength;
        if (path.indexOf("//") != -1) {
            path = path.replace("//", SEPARATOR);
        }
        if (path.indexOf("\\") != -1) {
            path = path.replace("\\", SEPARATOR);
        }
        int n = minLength = this.hasWindowsDrive(path, true) ? 4 : 1;
        if (path.length() > minLength && path.endsWith(SEPARATOR)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private boolean hasWindowsDrive(String path, boolean slashed) {
        if (!WINDOWS) {
            return false;
        }
        int start2 = slashed ? 1 : 0;
        return path.length() >= start2 + 2 && (!slashed || path.charAt(0) == '/') && path.charAt(start2 + 1) == ':' && (path.charAt(start2) >= 'A' && path.charAt(start2) <= 'Z' || path.charAt(start2) >= 'a' && path.charAt(start2) <= 'z');
    }

    public URI toUri() {
        return this.uri;
    }

    public FileSystem getFileSystem(Configuration conf) throws IOException {
        return FileSystem.get(this.toUri(), conf);
    }

    public boolean isAbsolute() {
        int start2 = this.hasWindowsDrive(this.uri.getPath(), true) ? 3 : 0;
        return this.uri.getPath().startsWith(SEPARATOR, start2);
    }

    public String getName() {
        String path = this.uri.getPath();
        int slash = path.lastIndexOf(SEPARATOR);
        return path.substring(slash + 1);
    }

    public Path getParent() {
        String parent;
        int start2;
        String path = this.uri.getPath();
        int lastSlash = path.lastIndexOf(47);
        int n = start2 = this.hasWindowsDrive(path, true) ? 3 : 0;
        if (path.length() == start2 || lastSlash == start2 && path.length() == start2 + 1) {
            return null;
        }
        if (lastSlash == -1) {
            parent = CUR_DIR;
        } else {
            int end = this.hasWindowsDrive(path, true) ? 3 : 0;
            parent = path.substring(0, lastSlash == end ? end + 1 : lastSlash);
        }
        return new Path(this.uri.getScheme(), this.uri.getAuthority(), parent);
    }

    public Path suffix(String suffix) {
        return new Path(this.getParent(), this.getName() + suffix);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.uri.getScheme() != null) {
            buffer.append(this.uri.getScheme());
            buffer.append(":");
        }
        if (this.uri.getAuthority() != null) {
            buffer.append("//");
            buffer.append(this.uri.getAuthority());
        }
        if (this.uri.getPath() != null) {
            String path = this.uri.getPath();
            if (path.indexOf(47) == 0 && this.hasWindowsDrive(path, true) && this.uri.getScheme() == null && this.uri.getAuthority() == null) {
                path = path.substring(1);
            }
            buffer.append(path);
        }
        if (this.uri.getFragment() != null) {
            buffer.append("#");
            buffer.append(this.uri.getFragment());
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Path)) {
            return false;
        }
        Path that = (Path)o;
        return this.uri.equals(that.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public int compareTo(Object o) {
        Path that = (Path)o;
        return this.uri.compareTo(that.uri);
    }

    public int depth() {
        int slash;
        String path = this.uri.getPath();
        int depth = 0;
        int n = slash = path.length() == 1 && path.charAt(0) == '/' ? -1 : 0;
        while (slash != -1) {
            ++depth;
            slash = path.indexOf(SEPARATOR, slash + 1);
        }
        return depth;
    }

    public Path makeQualified(FileSystem fs) {
        Path path = this;
        if (!this.isAbsolute()) {
            path = new Path(fs.getWorkingDirectory(), this);
        }
        URI pathUri = path.toUri();
        URI fsUri = fs.getUri();
        String scheme = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        String fragment = pathUri.getFragment();
        if (scheme != null && (authority != null || fsUri.getAuthority() == null)) {
            return path;
        }
        if (scheme == null) {
            scheme = fsUri.getScheme();
        }
        if (authority == null && (authority = fsUri.getAuthority()) == null) {
            authority = "";
        }
        URI newUri = null;
        try {
            newUri = new URI(scheme, authority, this.normalizePath(pathUri.getPath()), null, fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return new Path(newUri);
    }

    public Path makeQualified(URI defaultUri, Path workingDir) {
        Path path = this;
        if (!this.isAbsolute()) {
            path = new Path(workingDir, this);
        }
        URI pathUri = path.toUri();
        String scheme = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        String fragment = pathUri.getFragment();
        if (scheme != null && (authority != null || defaultUri.getAuthority() == null)) {
            return path;
        }
        if (scheme == null) {
            scheme = defaultUri.getScheme();
        }
        if (authority == null && (authority = defaultUri.getAuthority()) == null) {
            authority = "";
        }
        URI newUri = null;
        try {
            newUri = new URI(scheme, authority, this.normalizePath(pathUri.getPath()), null, fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return new Path(newUri);
    }
}

