/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.io.Writable;

abstract class EditLogOutputStream
extends OutputStream {
    private long numSync = 0L;
    private long totalTimeSync = 0L;

    EditLogOutputStream() throws IOException {
    }

    abstract String getName();

    @Override
    public abstract void write(int var1) throws IOException;

    abstract void write(byte var1, Writable ... var2) throws IOException;

    abstract void create() throws IOException;

    @Override
    public abstract void close() throws IOException;

    abstract void setReadyToFlush() throws IOException;

    protected abstract void flushAndSync() throws IOException;

    @Override
    public void flush() throws IOException {
        ++this.numSync;
        long start2 = FSNamesystem.now();
        this.flushAndSync();
        long end = FSNamesystem.now();
        this.totalTimeSync += end - start2;
    }

    abstract long length() throws IOException;

    long getTotalSyncTime() {
        return this.totalTimeSync;
    }

    long getNumSync() {
        return this.numSync;
    }
}

