/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.TaskTrackerAction;

class HeartbeatResponse
implements Writable,
Configurable {
    Configuration conf = null;
    short responseId;
    int heartbeatInterval;
    TaskTrackerAction[] actions;
    Set<JobID> recoveredJobs = new HashSet<JobID>();

    HeartbeatResponse() {
    }

    HeartbeatResponse(short responseId, TaskTrackerAction[] actions) {
        this.responseId = responseId;
        this.actions = actions;
        this.heartbeatInterval = 3000;
    }

    public void setResponseId(short responseId) {
        this.responseId = responseId;
    }

    public short getResponseId() {
        return this.responseId;
    }

    public void setRecoveredJobs(Set<JobID> ids) {
        this.recoveredJobs = ids;
    }

    public Set<JobID> getRecoveredJobs() {
        return this.recoveredJobs;
    }

    public void setActions(TaskTrackerAction[] actions) {
        this.actions = actions;
    }

    public TaskTrackerAction[] getActions() {
        return this.actions;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    public void setHeartbeatInterval(int interval) {
        this.heartbeatInterval = interval;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeShort(this.responseId);
        out.writeInt(this.heartbeatInterval);
        if (this.actions == null) {
            WritableUtils.writeVInt(out, 0);
        } else {
            WritableUtils.writeVInt(out, this.actions.length);
            for (TaskTrackerAction action : this.actions) {
                WritableUtils.writeEnum(out, action.getActionId());
                action.write(out);
            }
        }
        out.writeInt(this.recoveredJobs.size());
        for (JobID id : this.recoveredJobs) {
            id.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.responseId = in.readShort();
        this.heartbeatInterval = in.readInt();
        int length = WritableUtils.readVInt(in);
        if (length > 0) {
            this.actions = new TaskTrackerAction[length];
            for (int i = 0; i < length; ++i) {
                TaskTrackerAction.ActionType actionType = WritableUtils.readEnum(in, TaskTrackerAction.ActionType.class);
                this.actions[i] = TaskTrackerAction.createAction(actionType);
                this.actions[i].readFields(in);
            }
        } else {
            this.actions = null;
        }
        int size2 = in.readInt();
        for (int i = 0; i < size2; ++i) {
            JobID id = new JobID();
            id.readFields(in);
            this.recoveredJobs.add(id);
        }
    }
}

