/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

class StatisticsCollector {
    private static final int DEFAULT_PERIOD = 5;
    static final TimeWindow SINCE_START = new TimeWindow("Since Start", -1, -1);
    static final TimeWindow LAST_WEEK = new TimeWindow("Last Week", 604800, 3600);
    static final TimeWindow LAST_DAY = new TimeWindow("Last Day", 86400, 3600);
    static final TimeWindow LAST_HOUR = new TimeWindow("Last Hour", 3600, 60);
    static final TimeWindow LAST_MINUTE = new TimeWindow("Last Minute", 60, 10);
    static final TimeWindow[] DEFAULT_COLLECT_WINDOWS = new TimeWindow[]{SINCE_START, LAST_DAY, LAST_HOUR};
    private final int period;
    private boolean started;
    private final Map<TimeWindow, StatUpdater> updaters = new LinkedHashMap<TimeWindow, StatUpdater>();
    private final Map<String, Stat> statistics = new HashMap<String, Stat>();

    StatisticsCollector() {
        this(5);
    }

    StatisticsCollector(int period) {
        this.period = period;
    }

    synchronized void start() {
        if (this.started) {
            return;
        }
        Timer timer = new Timer("Timer thread for monitoring ", true);
        TimerTask task2 = new TimerTask(){

            @Override
            public void run() {
                StatisticsCollector.this.update();
            }
        };
        long millis = this.period * 1000;
        timer.scheduleAtFixedRate(task2, millis, millis);
        this.started = true;
    }

    protected synchronized void update() {
        for (StatUpdater c : this.updaters.values()) {
            c.update();
        }
    }

    Map<TimeWindow, StatUpdater> getUpdaters() {
        return Collections.unmodifiableMap(this.updaters);
    }

    Map<String, Stat> getStatistics() {
        return Collections.unmodifiableMap(this.statistics);
    }

    synchronized Stat createStat(String name) {
        return this.createStat(name, DEFAULT_COLLECT_WINDOWS);
    }

    synchronized Stat createStat(String name, TimeWindow[] windows) {
        if (this.statistics.get(name) != null) {
            throw new RuntimeException("Stat with name " + name + " is already defined");
        }
        LinkedHashMap<TimeWindow, Stat.TimeStat> timeStats = new LinkedHashMap<TimeWindow, Stat.TimeStat>();
        for (TimeWindow window : windows) {
            StatUpdater collector = this.updaters.get(window);
            if (collector == null) {
                collector = SINCE_START.equals(window) ? new StatUpdater() : new TimeWindowStatUpdater(window, this.period);
                this.updaters.put(window, collector);
            }
            Stat.TimeStat timeStat = new Stat.TimeStat();
            collector.addTimeStat(name, timeStat);
            timeStats.put(window, timeStat);
        }
        Stat stat = new Stat(name, timeStats);
        this.statistics.put(name, stat);
        return stat;
    }

    synchronized Stat removeStat(String name) {
        Stat stat = this.statistics.remove(name);
        if (stat != null) {
            for (StatUpdater collector : this.updaters.values()) {
                collector.removeTimeStat(name);
            }
        }
        return stat;
    }

    private static class TimeWindowStatUpdater
    extends StatUpdater {
        final int collectBuckets;
        final int updatesPerBucket;
        private int updates;
        private int buckets;

        TimeWindowStatUpdater(TimeWindow w, int updatePeriod) {
            if (updatePeriod > w.updateGranularity) {
                throw new RuntimeException("Invalid conf: updatePeriod > updateGranularity");
            }
            this.collectBuckets = w.windowSize / w.updateGranularity;
            this.updatesPerBucket = w.updateGranularity / updatePeriod;
        }

        @Override
        synchronized void update() {
            ++this.updates;
            if (this.updates == this.updatesPerBucket) {
                for (Stat.TimeStat stat : this.statToCollect.values()) {
                    stat.addBucket();
                }
                this.updates = 0;
                ++this.buckets;
                if (this.buckets > this.collectBuckets) {
                    for (Stat.TimeStat stat : this.statToCollect.values()) {
                        stat.removeBucket();
                    }
                    --this.buckets;
                }
            }
        }
    }

    private static class StatUpdater {
        protected final Map<String, Stat.TimeStat> statToCollect = new HashMap<String, Stat.TimeStat>();

        private StatUpdater() {
        }

        synchronized void addTimeStat(String name, Stat.TimeStat s) {
            this.statToCollect.put(name, s);
        }

        synchronized Stat.TimeStat removeTimeStat(String name) {
            return this.statToCollect.remove(name);
        }

        synchronized void update() {
            for (Stat.TimeStat stat : this.statToCollect.values()) {
                stat.setValueToCurrent();
            }
        }
    }

    static class Stat {
        final String name;
        private Map<TimeWindow, TimeStat> timeStats;

        private Stat(String name, Map<TimeWindow, TimeStat> timeStats) {
            this.name = name;
            this.timeStats = timeStats;
        }

        public synchronized void inc(int incr) {
            for (TimeStat ts : this.timeStats.values()) {
                ts.inc(incr);
            }
        }

        public synchronized void inc() {
            this.inc(1);
        }

        public synchronized Map<TimeWindow, TimeStat> getValues() {
            return Collections.unmodifiableMap(this.timeStats);
        }

        static class TimeStat {
            private final LinkedList<Integer> buckets = new LinkedList();
            private int value;
            private int currentValue;

            TimeStat() {
            }

            public synchronized int getValue() {
                return this.value;
            }

            private synchronized void inc(int i) {
                this.currentValue += i;
            }

            private synchronized void addBucket() {
                this.buckets.addLast(this.currentValue);
                this.setValueToCurrent();
            }

            private synchronized void setValueToCurrent() {
                this.value += this.currentValue;
                this.currentValue = 0;
            }

            private synchronized void removeBucket() {
                int removed = this.buckets.removeFirst();
                this.value -= removed;
            }
        }
    }

    static class TimeWindow {
        final String name;
        final int windowSize;
        final int updateGranularity;

        TimeWindow(String name, int windowSize, int updateGranularity) {
            if (updateGranularity > windowSize) {
                throw new RuntimeException("Invalid TimeWindow: updateGranularity > windowSize");
            }
            this.name = name;
            this.windowSize = windowSize;
            this.updateGranularity = updateGranularity;
        }

        public int hashCode() {
            return this.name.hashCode() + this.updateGranularity + this.windowSize;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimeWindow other = (TimeWindow)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.updateGranularity != other.updateGranularity) {
                return false;
            }
            return this.windowSize == other.windowSize;
        }
    }
}

