/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.util.Progressable;

@Deprecated
public class InMemoryFileSystem
extends ChecksumFileSystem {
    public InMemoryFileSystem() {
        super(new RawInMemoryFileSystem());
    }

    public InMemoryFileSystem(URI uri, Configuration conf) {
        super(new RawInMemoryFileSystem(uri, conf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reserveSpaceWithCheckSum(Path f, long size2) {
        RawInMemoryFileSystem mfs;
        RawInMemoryFileSystem rawInMemoryFileSystem = mfs = (RawInMemoryFileSystem)this.getRawFileSystem();
        synchronized (rawInMemoryFileSystem) {
            boolean b = mfs.reserveSpace(f, size2);
            if (b) {
                long checksumSize = this.getChecksumFileLength(f, size2);
                b = mfs.reserveSpace(this.getChecksumFile(f), checksumSize);
                if (!b) {
                    mfs.unreserveSpace(f);
                }
            }
            return b;
        }
    }

    public Path[] getFiles(PathFilter filter) {
        return ((RawInMemoryFileSystem)this.getRawFileSystem()).getFiles(filter);
    }

    public int getNumFiles(PathFilter filter) {
        return ((RawInMemoryFileSystem)this.getRawFileSystem()).getNumFiles(filter);
    }

    public long getFSSize() {
        return ((RawInMemoryFileSystem)this.getRawFileSystem()).getFSSize();
    }

    public float getPercentUsed() {
        return ((RawInMemoryFileSystem)this.getRawFileSystem()).getPercentUsed();
    }

    private static class RawInMemoryFileSystem
    extends FileSystem {
        private URI uri;
        private long fsSize;
        private volatile long totalUsed;
        private Path staticWorkingDir;
        private Map<String, FileAttributes> pathToFileAttribs = new HashMap<String, FileAttributes>();
        private Map<String, FileAttributes> tempFileAttribs = new HashMap<String, FileAttributes>();

        public RawInMemoryFileSystem() {
            this.setConf(new Configuration());
        }

        public RawInMemoryFileSystem(URI uri, Configuration conf) {
            this.initialize(uri, conf);
        }

        @Override
        public void initialize(URI uri, Configuration conf) {
            this.setConf(conf);
            int size2 = Integer.parseInt(conf.get("fs.inmemory.size.mb", "100"));
            this.fsSize = (long)size2 * 1024L * 1024L;
            this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
            String path = this.uri.getPath();
            if (path.length() == 0) {
                path = ".";
            }
            this.staticWorkingDir = new Path(path);
            LOG.info((Object)("Initialized InMemoryFileSystem: " + uri.toString() + " of size (in bytes): " + this.fsSize));
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public FSDataInputStream open(Path f, int bufferSize) throws IOException {
            return new FSDataInputStream(new InMemoryInputStream(f));
        }

        @Override
        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
            throw new IOException("Not supported");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            RawInMemoryFileSystem rawInMemoryFileSystem = this;
            synchronized (rawInMemoryFileSystem) {
                if (this.exists(f) && !overwrite) {
                    throw new IOException("File already exists:" + f);
                }
                FileAttributes fAttr = this.tempFileAttribs.remove(this.getPath(f));
                if (fAttr != null) {
                    return this.create(f, fAttr);
                }
                return null;
            }
        }

        public FSDataOutputStream create(Path f, FileAttributes fAttr) throws IOException {
            return new FSDataOutputStream(new InMemoryOutputStream(f, fAttr), this.statistics);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            super.close();
            RawInMemoryFileSystem rawInMemoryFileSystem = this;
            synchronized (rawInMemoryFileSystem) {
                if (this.pathToFileAttribs != null) {
                    this.pathToFileAttribs.clear();
                }
                this.pathToFileAttribs = null;
                if (this.tempFileAttribs != null) {
                    this.tempFileAttribs.clear();
                }
                this.tempFileAttribs = null;
            }
        }

        @Override
        public boolean setReplication(Path src, short replication) throws IOException {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean rename(Path src, Path dst) throws IOException {
            RawInMemoryFileSystem rawInMemoryFileSystem = this;
            synchronized (rawInMemoryFileSystem) {
                if (this.exists(dst)) {
                    throw new IOException("Path " + dst + " already exists");
                }
                FileAttributes fAttr = this.pathToFileAttribs.remove(this.getPath(src));
                if (fAttr == null) {
                    return false;
                }
                this.pathToFileAttribs.put(this.getPath(dst), fAttr);
                return true;
            }
        }

        @Override
        @Deprecated
        public boolean delete(Path f) throws IOException {
            return this.delete(f, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean delete(Path f, boolean recursive) throws IOException {
            RawInMemoryFileSystem rawInMemoryFileSystem = this;
            synchronized (rawInMemoryFileSystem) {
                FileAttributes fAttr = this.pathToFileAttribs.remove(this.getPath(f));
                if (fAttr != null) {
                    FileAttributes.access$202(fAttr, null);
                    this.totalUsed -= (long)fAttr.size;
                    return true;
                }
                return false;
            }
        }

        @Override
        public FileStatus[] listStatus(Path f) throws IOException {
            return null;
        }

        @Override
        public void setWorkingDirectory(Path new_dir) {
            this.staticWorkingDir = new_dir;
        }

        @Override
        public Path getWorkingDirectory() {
            return this.staticWorkingDir;
        }

        @Override
        public boolean mkdirs(Path f, FsPermission permission) throws IOException {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileStatus getFileStatus(Path f) throws IOException {
            RawInMemoryFileSystem rawInMemoryFileSystem = this;
            synchronized (rawInMemoryFileSystem) {
                FileAttributes attr = this.pathToFileAttribs.get(this.getPath(f));
                if (attr == null) {
                    throw new FileNotFoundException("File " + f + " does not exist.");
                }
                return new InMemoryFileStatus(f.makeQualified(this), attr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean reserveSpace(Path f, long size2) {
            RawInMemoryFileSystem rawInMemoryFileSystem = this;
            synchronized (rawInMemoryFileSystem) {
                FileAttributes fileAttr;
                if (!this.canFitInMemory(size2)) {
                    return false;
                }
                try {
                    fileAttr = new FileAttributes((int)size2);
                }
                catch (OutOfMemoryError o) {
                    return false;
                }
                this.totalUsed += size2;
                this.tempFileAttribs.put(this.getPath(f), fileAttr);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unreserveSpace(Path f) {
            RawInMemoryFileSystem rawInMemoryFileSystem = this;
            synchronized (rawInMemoryFileSystem) {
                FileAttributes fAttr = this.tempFileAttribs.remove(this.getPath(f));
                if (fAttr != null) {
                    FileAttributes.access$202(fAttr, null);
                    this.totalUsed -= (long)fAttr.size;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Path[] getFiles(PathFilter filter) {
            RawInMemoryFileSystem rawInMemoryFileSystem = this;
            synchronized (rawInMemoryFileSystem) {
                ArrayList<String> closedFilesList = new ArrayList<String>();
                Map<String, FileAttributes> map2 = this.pathToFileAttribs;
                synchronized (map2) {
                    Set<String> paths = this.pathToFileAttribs.keySet();
                    if (paths == null || paths.isEmpty()) {
                        return new Path[0];
                    }
                    for (String f : paths) {
                        if (!filter.accept(new Path(f))) continue;
                        closedFilesList.add(f);
                    }
                }
                String[] names = closedFilesList.toArray(new String[closedFilesList.size()]);
                Path[] results = new Path[names.length];
                for (int i = 0; i < names.length; ++i) {
                    results[i] = new Path(names[i]);
                }
                return results;
            }
        }

        public int getNumFiles(PathFilter filter) {
            return this.getFiles(filter).length;
        }

        public long getFSSize() {
            return this.fsSize;
        }

        public float getPercentUsed() {
            if (this.fsSize > 0L) {
                return (float)this.totalUsed / (float)this.fsSize;
            }
            return 0.1f;
        }

        private boolean canFitInMemory(long size2) {
            return size2 <= Integer.MAX_VALUE && size2 + this.totalUsed < this.fsSize;
        }

        private String getPath(Path f) {
            return f.toUri().getPath();
        }

        private class InMemoryFileStatus
        extends FileStatus {
            InMemoryFileStatus(Path f, FileAttributes attr) throws IOException {
                super(attr.size, false, 1, RawInMemoryFileSystem.this.getDefaultBlockSize(), 0L, f);
            }
        }

        private static class FileAttributes {
            private byte[] data;
            private int size;

            public FileAttributes(int size2) {
                this.size = size2;
                this.data = new byte[size2];
            }

            static /* synthetic */ byte[] access$202(FileAttributes x0, byte[] x1) {
                x0.data = x1;
                return x1;
            }
        }

        private class InMemoryOutputStream
        extends OutputStream {
            private int count;
            private FileAttributes fAttr;
            private Path f;

            public InMemoryOutputStream(Path f, FileAttributes fAttr) throws IOException {
                this.fAttr = fAttr;
                this.f = f;
            }

            public long getPos() throws IOException {
                return this.count;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                RawInMemoryFileSystem rawInMemoryFileSystem = RawInMemoryFileSystem.this;
                synchronized (rawInMemoryFileSystem) {
                    RawInMemoryFileSystem.this.pathToFileAttribs.put(RawInMemoryFileSystem.this.getPath(this.f), this.fAttr);
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return;
                }
                int newcount = this.count + len;
                if (newcount > this.fAttr.size) {
                    throw new IOException("Insufficient space");
                }
                System.arraycopy(b, off, this.fAttr.data, this.count, len);
                this.count = newcount;
            }

            @Override
            public void write(int b) throws IOException {
                int newcount = this.count + 1;
                if (newcount > this.fAttr.size) {
                    throw new IOException("Insufficient space");
                }
                ((FileAttributes)this.fAttr).data[this.count] = (byte)b;
                this.count = newcount;
            }
        }

        private class InMemoryInputStream
        extends FSInputStream {
            private DataInputBuffer din = new DataInputBuffer();
            private FileAttributes fAttr;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public InMemoryInputStream(Path f) throws IOException {
                RawInMemoryFileSystem rawInMemoryFileSystem2 = RawInMemoryFileSystem.this;
                synchronized (rawInMemoryFileSystem2) {
                    this.fAttr = (FileAttributes)RawInMemoryFileSystem.this.pathToFileAttribs.get(RawInMemoryFileSystem.this.getPath(f));
                    if (this.fAttr == null) {
                        throw new FileNotFoundException("File " + f + " does not exist");
                    }
                    this.din.reset(this.fAttr.data, 0, this.fAttr.size);
                }
            }

            @Override
            public long getPos() throws IOException {
                return this.din.getPosition();
            }

            @Override
            public void seek(long pos) throws IOException {
                if ((int)pos > this.fAttr.size) {
                    throw new IOException("Cannot seek after EOF");
                }
                this.din.reset(this.fAttr.data, (int)pos, this.fAttr.size - (int)pos);
            }

            @Override
            public boolean seekToNewSource(long targetPos) throws IOException {
                return false;
            }

            @Override
            public int available() throws IOException {
                return this.din.available();
            }

            public boolean markSupport() {
                return false;
            }

            @Override
            public int read() throws IOException {
                return this.din.read();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return this.din.read(b, off, len);
            }

            @Override
            public long skip(long n) throws IOException {
                return this.din.skip(n);
            }
        }
    }
}

