/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.namenode.BlocksMap;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.WritableUtils;

public class DatanodeDescriptor
extends DatanodeInfo {
    DecommissioningStatus decommissioningStatus = new DecommissioningStatus();
    private volatile BlocksMap.BlockInfo blockList = null;
    protected boolean isAlive = false;
    protected boolean needKeyUpdate = false;
    private long bandwidth;
    private BlockQueue replicateBlocks = new BlockQueue();
    private BlockQueue recoverBlocks = new BlockQueue();
    private Set<Block> invalidateBlocks = new TreeSet<Block>();
    private int currApproxBlocksScheduled = 0;
    private int prevApproxBlocksScheduled = 0;
    private long lastBlocksScheduledRollTime = 0L;
    private static final int BLOCKS_SCHEDULED_ROLL_INTERVAL = 600000;
    private boolean firstBlockReport = true;

    public DatanodeDescriptor() {
    }

    public DatanodeDescriptor(DatanodeID nodeID) {
        this(nodeID, 0L, 0L, 0L, 0);
    }

    public DatanodeDescriptor(DatanodeID nodeID, String networkLocation) {
        this(nodeID, networkLocation, null);
    }

    public DatanodeDescriptor(DatanodeID nodeID, String networkLocation, String hostName) {
        this(nodeID, networkLocation, hostName, 0L, 0L, 0L, 0);
    }

    public DatanodeDescriptor(DatanodeID nodeID, long capacity, long dfsUsed, long remaining, int xceiverCount) {
        super(nodeID);
        this.updateHeartbeat(capacity, dfsUsed, remaining, xceiverCount);
    }

    public DatanodeDescriptor(DatanodeID nodeID, String networkLocation, String hostName, long capacity, long dfsUsed, long remaining, int xceiverCount) {
        super(nodeID, networkLocation, hostName);
        this.updateHeartbeat(capacity, dfsUsed, remaining, xceiverCount);
    }

    boolean addBlock(BlocksMap.BlockInfo b) {
        if (!b.addNode(this)) {
            return false;
        }
        this.blockList = b.listInsert(this.blockList, this);
        return true;
    }

    boolean removeBlock(BlocksMap.BlockInfo b) {
        this.blockList = b.listRemove(this.blockList, this);
        return b.removeNode(this);
    }

    void moveBlockToHead(BlocksMap.BlockInfo b) {
        this.blockList = b.listRemove(this.blockList, this);
        this.blockList = b.listInsert(this.blockList, this);
    }

    void resetBlocks() {
        this.capacity = 0L;
        this.remaining = 0L;
        this.dfsUsed = 0L;
        this.xceiverCount = 0;
        this.blockList = null;
        this.invalidateBlocks.clear();
    }

    public int numBlocks() {
        return this.blockList == null ? 0 : this.blockList.listCount(this);
    }

    void updateHeartbeat(long capacity, long dfsUsed, long remaining, int xceiverCount) {
        this.capacity = capacity;
        this.dfsUsed = dfsUsed;
        this.remaining = remaining;
        this.lastUpdate = System.currentTimeMillis();
        this.xceiverCount = xceiverCount;
        this.rollBlocksScheduled(this.lastUpdate);
    }

    Iterator<Block> getBlockIterator() {
        return new BlockIterator(this.blockList, this);
    }

    void addBlockToBeReplicated(Block block, DatanodeDescriptor[] targets) {
        assert (block != null && targets != null && targets.length > 0);
        this.replicateBlocks.offer(block, targets);
    }

    void addBlockToBeRecovered(Block block, DatanodeDescriptor[] targets) {
        assert (block != null && targets != null && targets.length > 0);
        this.recoverBlocks.offer(block, targets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBlocksToBeInvalidated(List<Block> blocklist) {
        assert (blocklist != null && blocklist.size() > 0);
        Set<Block> set2 = this.invalidateBlocks;
        synchronized (set2) {
            for (Block blk : blocklist) {
                this.invalidateBlocks.add(blk);
            }
        }
    }

    int getNumberOfBlocksToBeReplicated() {
        return this.replicateBlocks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfBlocksToBeInvalidated() {
        Set<Block> set2 = this.invalidateBlocks;
        synchronized (set2) {
            return this.invalidateBlocks.size();
        }
    }

    BlockCommand getReplicationCommand(int maxTransfers) {
        List<BlockTargetPair> blocktargetlist = this.replicateBlocks.poll(maxTransfers);
        return blocktargetlist == null ? null : new BlockCommand(1, blocktargetlist);
    }

    BlockCommand getLeaseRecoveryCommand(int maxTransfers) {
        List<BlockTargetPair> blocktargetlist = this.recoverBlocks.poll(maxTransfers);
        return blocktargetlist == null ? null : new BlockCommand(6, blocktargetlist);
    }

    BlockCommand getInvalidateBlocks(int maxblocks) {
        Block[] deleteList = DatanodeDescriptor.getBlockArray(this.invalidateBlocks, maxblocks);
        return deleteList == null ? null : new BlockCommand(2, deleteList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Block[] getBlockArray(Collection<Block> blocks, int max) {
        Block[] blockarray = null;
        Collection<Block> collection = blocks;
        synchronized (collection) {
            int available;
            int n = available = blocks.size();
            if (max > 0 && n > 0) {
                if (max < n) {
                    n = max;
                }
                blockarray = new Block[n];
                Iterator<Block> e = blocks.iterator();
                int blockCount = 0;
                while (blockCount < n && e.hasNext()) {
                    blockarray[blockCount++] = e.next();
                    if (n >= available) continue;
                    e.remove();
                }
                assert (blockarray.length == n);
                if (n == available) {
                    blocks.clear();
                }
            }
        }
        return blockarray;
    }

    void reportDiff(BlocksMap blocksMap, BlockListAsLongs newReport, Collection<Block> toAdd, Collection<Block> toRemove, Collection<Block> toInvalidate) {
        BlocksMap.BlockInfo storedBlock;
        BlocksMap.BlockInfo delimiter = new BlocksMap.BlockInfo(new Block(), 1);
        boolean added = this.addBlock(delimiter);
        assert (added) : "Delimiting block cannot be present in the node";
        if (newReport == null) {
            newReport = new BlockListAsLongs(new long[0]);
        }
        Block iblk = new Block();
        Block oblk = new Block();
        for (int i = 0; i < newReport.getNumberOfBlocks(); ++i) {
            iblk.set(newReport.getBlockId(i), newReport.getBlockLen(i), newReport.getBlockGenStamp(i));
            storedBlock = blocksMap.getStoredBlock(iblk);
            if (storedBlock == null) {
                oblk.set(newReport.getBlockId(i), newReport.getBlockLen(i), 1L);
                storedBlock = blocksMap.getStoredBlock(oblk);
                if (storedBlock == null || storedBlock.getINode() == null || storedBlock.getGenerationStamp() > iblk.getGenerationStamp() && !storedBlock.getINode().isUnderConstruction()) {
                    storedBlock = null;
                }
            }
            if (storedBlock == null) {
                toInvalidate.add(new Block(iblk));
                continue;
            }
            if (storedBlock.findDatanode(this) < 0) {
                if (storedBlock.getNumBytes() != iblk.getNumBytes()) {
                    toAdd.add(new Block(iblk));
                    continue;
                }
                toAdd.add(storedBlock);
                continue;
            }
            this.moveBlockToHead(storedBlock);
        }
        BlockIterator it = new BlockIterator(delimiter.getNext(0), this);
        while (it.hasNext()) {
            storedBlock = (BlocksMap.BlockInfo)it.next();
            INodeFile file = storedBlock.getINode();
            if (file != null && file.isUnderConstruction()) continue;
            toRemove.add(storedBlock);
        }
        this.removeBlock(delimiter);
    }

    void readFieldsFromFSEditLog(DataInput in) throws IOException {
        this.name = UTF8.readString(in);
        this.storageID = UTF8.readString(in);
        this.infoPort = in.readShort() & 0xFFFF;
        this.capacity = in.readLong();
        this.dfsUsed = in.readLong();
        this.remaining = in.readLong();
        this.lastUpdate = in.readLong();
        this.xceiverCount = in.readInt();
        this.location = Text.readString(in);
        this.hostName = Text.readString(in);
        this.setAdminState(WritableUtils.readEnum(in, DatanodeInfo.AdminStates.class));
    }

    public int getBlocksScheduled() {
        return this.currApproxBlocksScheduled + this.prevApproxBlocksScheduled;
    }

    void incBlocksScheduled() {
        ++this.currApproxBlocksScheduled;
    }

    void decBlocksScheduled() {
        if (this.prevApproxBlocksScheduled > 0) {
            --this.prevApproxBlocksScheduled;
        } else if (this.currApproxBlocksScheduled > 0) {
            --this.currApproxBlocksScheduled;
        }
    }

    private void rollBlocksScheduled(long now) {
        if (now - this.lastBlocksScheduledRollTime > 600000L) {
            this.prevApproxBlocksScheduled = this.currApproxBlocksScheduled;
            this.currApproxBlocksScheduled = 0;
            this.lastBlocksScheduledRollTime = now;
        }
    }

    public long getBalancerBandwidth() {
        return this.bandwidth;
    }

    public void setBalancerBandwidth(long bandwidth) {
        this.bandwidth = bandwidth;
    }

    boolean firstBlockReport() {
        return this.firstBlockReport;
    }

    void processedBlockReport() {
        this.firstBlockReport = false;
    }

    class DecommissioningStatus {
        int underReplicatedBlocks;
        int decommissionOnlyReplicas;
        int underReplicatedInOpenFiles;
        long startTime;

        DecommissioningStatus() {
        }

        synchronized void set(int underRep, int onlyRep, int underConstruction) {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return;
            }
            this.underReplicatedBlocks = underRep;
            this.decommissionOnlyReplicas = onlyRep;
            this.underReplicatedInOpenFiles = underConstruction;
        }

        synchronized int getUnderReplicatedBlocks() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0;
            }
            return this.underReplicatedBlocks;
        }

        synchronized int getDecommissionOnlyReplicas() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0;
            }
            return this.decommissionOnlyReplicas;
        }

        synchronized int getUnderReplicatedInOpenFiles() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0;
            }
            return this.underReplicatedInOpenFiles;
        }

        synchronized void setStartTime(long time) {
            this.startTime = time;
        }

        synchronized long getStartTime() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0L;
            }
            return this.startTime;
        }
    }

    private static class BlockIterator
    implements Iterator<Block> {
        private BlocksMap.BlockInfo current;
        private DatanodeDescriptor node;

        BlockIterator(BlocksMap.BlockInfo head, DatanodeDescriptor dn) {
            this.current = head;
            this.node = dn;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public BlocksMap.BlockInfo next() {
            BlocksMap.BlockInfo res = this.current;
            this.current = this.current.getNext(this.current.findDatanode(this.node));
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Sorry. can't remove.");
        }
    }

    private static class BlockQueue {
        private final Queue<BlockTargetPair> blockq = new LinkedList<BlockTargetPair>();

        private BlockQueue() {
        }

        synchronized int size() {
            return this.blockq.size();
        }

        synchronized boolean offer(Block block, DatanodeDescriptor[] targets) {
            return this.blockq.offer(new BlockTargetPair(block, targets));
        }

        synchronized List<BlockTargetPair> poll(int numBlocks) {
            if (numBlocks <= 0 || this.blockq.isEmpty()) {
                return null;
            }
            ArrayList<BlockTargetPair> results = new ArrayList<BlockTargetPair>();
            while (!this.blockq.isEmpty() && numBlocks > 0) {
                results.add(this.blockq.poll());
                --numBlocks;
            }
            return results;
        }
    }

    public static class BlockTargetPair {
        public final Block block;
        public final DatanodeDescriptor[] targets;

        BlockTargetPair(Block block, DatanodeDescriptor[] targets) {
            this.block = block;
            this.targets = targets;
        }
    }
}

