/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class MD5Hash
implements WritableComparable<MD5Hash> {
    public static final int MD5_LEN = 16;
    private static ThreadLocal<MessageDigest> DIGESTER_FACTORY = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private byte[] digest;
    private static final char[] HEX_DIGITS;

    public MD5Hash() {
        this.digest = new byte[16];
    }

    public MD5Hash(String hex) {
        this.setDigest(hex);
    }

    public MD5Hash(byte[] digest) {
        if (digest.length != 16) {
            throw new IllegalArgumentException("Wrong length: " + digest.length);
        }
        this.digest = digest;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        in.readFully(this.digest);
    }

    public static MD5Hash read(DataInput in) throws IOException {
        MD5Hash result = new MD5Hash();
        result.readFields(in);
        return result;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.write(this.digest);
    }

    public void set(MD5Hash that) {
        System.arraycopy(that.digest, 0, this.digest, 0, 16);
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public static MD5Hash digest(byte[] data) {
        return MD5Hash.digest(data, 0, data.length);
    }

    public static MD5Hash digest(InputStream in) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        MessageDigest digester = DIGESTER_FACTORY.get();
        while ((n = in.read(buffer)) != -1) {
            digester.update(buffer, 0, n);
        }
        return new MD5Hash(digester.digest());
    }

    public static MD5Hash digest(byte[] data, int start2, int len) {
        MessageDigest digester = DIGESTER_FACTORY.get();
        digester.update(data, start2, len);
        byte[] digest = digester.digest();
        return new MD5Hash(digest);
    }

    public static MD5Hash digest(String string) {
        return MD5Hash.digest(UTF8.getBytes(string));
    }

    public static MD5Hash digest(UTF8 utf8) {
        return MD5Hash.digest(utf8.getBytes(), 0, utf8.getLength());
    }

    public long halfDigest() {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value |= ((long)this.digest[i] & 0xFFL) << 8 * (7 - i);
        }
        return value;
    }

    public int quarterDigest() {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value |= (this.digest[i] & 0xFF) << 8 * (3 - i);
        }
        return value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MD5Hash)) {
            return false;
        }
        MD5Hash other = (MD5Hash)o;
        return Arrays.equals(this.digest, other.digest);
    }

    public int hashCode() {
        return this.quarterDigest();
    }

    @Override
    public int compareTo(MD5Hash that) {
        return WritableComparator.compareBytes(this.digest, 0, 16, that.digest, 0, 16);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(32);
        for (int i = 0; i < 16; ++i) {
            byte b = this.digest[i];
            buf.append(HEX_DIGITS[b >> 4 & 0xF]);
            buf.append(HEX_DIGITS[b & 0xF]);
        }
        return buf.toString();
    }

    public void setDigest(String hex) {
        if (hex.length() != 32) {
            throw new IllegalArgumentException("Wrong length: " + hex.length());
        }
        byte[] digest = new byte[16];
        for (int i = 0; i < 16; ++i) {
            int j = i << 1;
            digest[i] = (byte)(MD5Hash.charToNibble(hex.charAt(j)) << 4 | MD5Hash.charToNibble(hex.charAt(j + 1)));
        }
        this.digest = digest;
    }

    private static final int charToNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        throw new RuntimeException("Not a hex character: " + c);
    }

    static {
        WritableComparator.define(MD5Hash.class, new Comparator());
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(MD5Hash.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return Comparator.compareBytes(b1, s1, 16, b2, s2, 16);
        }
    }
}

