/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.util.StringUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Configuration
implements Iterable<Map.Entry<String, String>>,
Writable {
    private static final Log LOG = LogFactory.getLog(Configuration.class);
    private boolean quietmode = true;
    private ArrayList<Object> resources = new ArrayList();
    private Set<String> finalParameters = new HashSet<String>();
    private boolean loadDefaults = true;
    private static final WeakHashMap<Configuration, Object> REGISTRY = new WeakHashMap();
    private static final CopyOnWriteArrayList<String> defaultResources = new CopyOnWriteArrayList();
    private boolean storeResource;
    private HashMap<String, String> updatingResource;
    private Properties properties;
    private Properties overlay;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private static Pattern varPat;
    private static int MAX_SUBST;

    public Configuration() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration(boolean loadDefaults) {
        if (this.classLoader == null) {
            this.classLoader = Configuration.class.getClassLoader();
        }
        this.loadDefaults = loadDefaults;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)StringUtils.stringifyException(new IOException("config()")));
        }
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            REGISTRY.put(this, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.storeResource = false;
            return;
        }
    }

    private Configuration(Configuration other, boolean storeResource) {
        this(other);
        this.loadDefaults = other.loadDefaults;
        this.storeResource = storeResource;
        if (storeResource) {
            this.updatingResource = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration(Configuration other) {
        if (this.classLoader == null) {
            this.classLoader = Configuration.class.getClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)StringUtils.stringifyException(new IOException("config(config)")));
        }
        this.resources = (ArrayList)other.resources.clone();
        Object object = other;
        synchronized (object) {
            if (other.properties != null) {
                this.properties = (Properties)other.properties.clone();
            }
            if (other.overlay != null) {
                this.overlay = (Properties)other.overlay.clone();
            }
        }
        this.finalParameters = new HashSet<String>(other.finalParameters);
        object = Configuration.class;
        synchronized (Configuration.class) {
            REGISTRY.put(this, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void addDefaultResource(String name) {
        if (!defaultResources.contains(name)) {
            defaultResources.add(name);
            for (Configuration conf : REGISTRY.keySet()) {
                if (!conf.loadDefaults) continue;
                conf.reloadConfiguration();
            }
        }
    }

    public void addResource(String name) {
        this.addResourceObject(name);
    }

    public void addResource(URL url) {
        this.addResourceObject(url);
    }

    public void addResource(Path file) {
        this.addResourceObject(file);
    }

    public void addResource(InputStream in) {
        this.addResourceObject(in);
    }

    public synchronized void reloadConfiguration() {
        this.properties = null;
        this.finalParameters.clear();
    }

    private synchronized void addResourceObject(Object resource) {
        this.resources.add(resource);
        this.reloadConfiguration();
    }

    private String substituteVars(String expr) {
        if (expr == null) {
            return null;
        }
        Matcher match = varPat.matcher("");
        String eval = expr;
        for (int s = 0; s < MAX_SUBST; ++s) {
            match.reset(eval);
            if (!match.find()) {
                return eval;
            }
            String var = match.group();
            var = var.substring(2, var.length() - 1);
            String val = null;
            try {
                val = System.getProperty(var);
            }
            catch (SecurityException se) {
                LOG.warn((Object)"Unexpected SecurityException in Configuration", (Throwable)se);
            }
            if (val == null) {
                val = this.getRaw(var);
            }
            if (val == null) {
                return eval;
            }
            eval = eval.substring(0, match.start()) + val + eval.substring(match.end());
        }
        throw new IllegalStateException("Variable substitution depth too large: " + MAX_SUBST + " " + expr);
    }

    public String get(String name) {
        return this.substituteVars(this.getProps().getProperty(name));
    }

    public String getRaw(String name) {
        return this.getProps().getProperty(name);
    }

    public void set(String name, String value) {
        this.getOverlay().setProperty(name, value);
        this.getProps().setProperty(name, value);
    }

    public void setIfUnset(String name, String value) {
        if (this.get(name) == null) {
            this.set(name, value);
        }
    }

    private synchronized Properties getOverlay() {
        if (this.overlay == null) {
            this.overlay = new Properties();
        }
        return this.overlay;
    }

    public String get(String name, String defaultValue) {
        return this.substituteVars(this.getProps().getProperty(name, defaultValue));
    }

    public int getInt(String name, int defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            String hexString = this.getHexDigits(valueString);
            if (hexString != null) {
                return Integer.parseInt(hexString, 16);
            }
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void setInt(String name, int value) {
        this.set(name, Integer.toString(value));
    }

    public long getLong(String name, long defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            String hexString = this.getHexDigits(valueString);
            if (hexString != null) {
                return Long.parseLong(hexString, 16);
            }
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private String getHexDigits(String value) {
        boolean negative = false;
        String str = value;
        String hexString = null;
        if (value.startsWith("-")) {
            negative = true;
            str = value.substring(1);
        }
        if (str.startsWith("0x") || str.startsWith("0X")) {
            hexString = str.substring(2);
            if (negative) {
                hexString = "-" + hexString;
            }
            return hexString;
        }
        return null;
    }

    public void setLong(String name, long value) {
        this.set(name, Long.toString(value));
    }

    public float getFloat(String name, float defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void setFloat(String name, float value) {
        this.set(name, Float.toString(value));
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String valueString = this.get(name);
        if ("true".equals(valueString)) {
            return true;
        }
        if ("false".equals(valueString)) {
            return false;
        }
        return defaultValue;
    }

    public void setBoolean(String name, boolean value) {
        this.set(name, Boolean.toString(value));
    }

    public void setBooleanIfUnset(String name, boolean value) {
        this.setIfUnset(name, Boolean.toString(value));
    }

    public <T extends Enum<T>> void setEnum(String name, T value) {
        this.set(name, value.toString());
    }

    public <T extends Enum<T>> T getEnum(String name, T defaultValue) {
        String val = this.get(name);
        return null == val ? defaultValue : Enum.valueOf(defaultValue.getDeclaringClass(), val);
    }

    public IntegerRanges getRange(String name, String defaultValue) {
        return new IntegerRanges(this.get(name, defaultValue));
    }

    public Collection<String> getStringCollection(String name) {
        String valueString = this.get(name);
        return StringUtils.getStringCollection(valueString);
    }

    public String[] getStrings(String name) {
        String valueString = this.get(name);
        return StringUtils.getStrings(valueString);
    }

    public String[] getStrings(String name, String ... defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        return StringUtils.getStrings(valueString);
    }

    public void setStrings(String name, String ... values) {
        this.set(name, StringUtils.arrayToString(values));
    }

    public Class<?> getClassByName(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.classLoader);
    }

    public Class<?>[] getClasses(String name, Class<?> ... defaultValue) {
        String[] classnames = this.getStrings(name);
        if (classnames == null) {
            return defaultValue;
        }
        try {
            Class[] classes = new Class[classnames.length];
            for (int i = 0; i < classnames.length; ++i) {
                classes[i] = this.getClassByName(classnames[i]);
            }
            return classes;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getClass(String name, Class<?> defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return this.getClassByName(valueString);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public <U> Class<? extends U> getClass(String name, Class<? extends U> defaultValue, Class<U> xface) {
        try {
            Class<?> theClass = this.getClass(name, defaultValue);
            if (theClass != null && !xface.isAssignableFrom(theClass)) {
                throw new RuntimeException(theClass + " not " + xface.getName());
            }
            if (theClass != null) {
                return theClass.asSubclass(xface);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setClass(String name, Class<?> theClass, Class<?> xface) {
        if (!xface.isAssignableFrom(theClass)) {
            throw new RuntimeException(theClass + " not " + xface.getName());
        }
        this.set(name, theClass.getName());
    }

    public Path getLocalPath(String dirsProp, String path) throws IOException {
        int index;
        int i;
        String[] dirs = this.getStrings(dirsProp);
        int hashCode = path.hashCode();
        LocalFileSystem fs = FileSystem.getLocal(this);
        for (i = 0; i < dirs.length; ++i) {
            index = (hashCode + i & Integer.MAX_VALUE) % dirs.length;
            Path file = new Path(dirs[index], path);
            Path dir = file.getParent();
            if (!((FileSystem)fs).mkdirs(dir) && !((FileSystem)fs).exists(dir)) continue;
            return file;
        }
        LOG.warn((Object)("Could not make " + path + " in local directories from " + dirsProp));
        for (i = 0; i < dirs.length; ++i) {
            index = (hashCode + i & Integer.MAX_VALUE) % dirs.length;
            LOG.warn((Object)(dirsProp + "[" + index + "]=" + dirs[index]));
        }
        throw new IOException("No valid local directories in property: " + dirsProp);
    }

    public File getFile(String dirsProp, String path) throws IOException {
        String[] dirs = this.getStrings(dirsProp);
        int hashCode = path.hashCode();
        for (int i = 0; i < dirs.length; ++i) {
            int index = (hashCode + i & Integer.MAX_VALUE) % dirs.length;
            File file = new File(dirs[index], path);
            File dir = file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) continue;
            return file;
        }
        throw new IOException("No valid local directories in property: " + dirsProp);
    }

    public URL getResource(String name) {
        return this.classLoader.getResource(name);
    }

    public InputStream getConfResourceAsInputStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url == null) {
                LOG.info((Object)(name + " not found"));
                return null;
            }
            LOG.info((Object)("found resource " + name + " at " + url));
            return url.openStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Reader getConfResourceAsReader(String name) {
        try {
            URL url = this.getResource(name);
            if (url == null) {
                LOG.info((Object)(name + " not found"));
                return null;
            }
            LOG.info((Object)("found resource " + name + " at " + url));
            return new InputStreamReader(url.openStream());
        }
        catch (Exception e) {
            return null;
        }
    }

    private synchronized Properties getProps() {
        if (this.properties == null) {
            this.properties = new Properties();
            this.loadResources(this.properties, this.resources, this.quietmode);
            if (this.overlay != null) {
                this.properties.putAll((Map<?, ?>)this.overlay);
                if (this.storeResource) {
                    for (Map.Entry<Object, Object> item : this.overlay.entrySet()) {
                        this.updatingResource.put((String)item.getKey(), "Unknown");
                    }
                }
            }
        }
        return this.properties;
    }

    public int size() {
        return this.getProps().size();
    }

    public void clear() {
        this.getProps().clear();
        this.getOverlay().clear();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> item : this.getProps().entrySet()) {
            if (!(item.getKey() instanceof String) || !(item.getValue() instanceof String)) continue;
            result.put((String)item.getKey(), (String)item.getValue());
        }
        return result.entrySet().iterator();
    }

    private void loadResources(Properties properties, ArrayList resources, boolean quiet) {
        if (this.loadDefaults) {
            for (String resource : defaultResources) {
                this.loadResource(properties, resource, quiet);
            }
            if (this.getResource("hadoop-site.xml") != null) {
                this.loadResource(properties, "hadoop-site.xml", quiet);
            }
        }
        for (String resource : resources) {
            this.loadResource(properties, resource, quiet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResource(Properties properties, Object name, boolean quiet) {
        try {
            URL url;
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringComments(true);
            docBuilderFactory.setNamespaceAware(true);
            try {
                docBuilderFactory.setXIncludeAware(true);
            }
            catch (UnsupportedOperationException e) {
                LOG.error((Object)("Failed to set setXIncludeAware(true) for parser " + docBuilderFactory + ":" + e), (Throwable)e);
            }
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = null;
            Element root = null;
            if (name instanceof URL) {
                url = (URL)name;
                if (url != null) {
                    if (!quiet) {
                        LOG.info((Object)("parsing " + url));
                    }
                    doc = builder.parse(url.toString());
                }
            } else if (name instanceof String) {
                url = this.getResource((String)name);
                if (url != null) {
                    if (!quiet) {
                        LOG.info((Object)("parsing " + url));
                    }
                    doc = builder.parse(url.toString());
                }
            } else if (name instanceof Path) {
                File file = new File(((Path)name).toUri().getPath()).getAbsoluteFile();
                if (file.exists()) {
                    if (!quiet) {
                        LOG.info((Object)("parsing " + file));
                    }
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                    try {
                        doc = builder.parse(in);
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
            } else if (name instanceof InputStream) {
                try {
                    doc = builder.parse((InputStream)name);
                }
                finally {
                    ((InputStream)name).close();
                }
            } else if (name instanceof Element) {
                root = (Element)name;
            }
            if (doc == null && root == null) {
                if (quiet) {
                    return;
                }
                throw new RuntimeException(name + " not found");
            }
            if (root == null) {
                root = doc.getDocumentElement();
            }
            if (!"configuration".equals(root.getTagName())) {
                LOG.fatal((Object)"bad conf file: top-level element not <configuration>");
            }
            NodeList props = root.getChildNodes();
            for (int i = 0; i < props.getLength(); ++i) {
                Node propNode = props.item(i);
                if (!(propNode instanceof Element)) continue;
                Element prop = (Element)propNode;
                if ("configuration".equals(prop.getTagName())) {
                    this.loadResource(properties, prop, quiet);
                    continue;
                }
                if (!"property".equals(prop.getTagName())) {
                    LOG.warn((Object)"bad conf file: element not <property>");
                }
                NodeList fields = prop.getChildNodes();
                String attr = null;
                String value = null;
                boolean finalParameter = false;
                for (int j = 0; j < fields.getLength(); ++j) {
                    Node fieldNode = fields.item(j);
                    if (!(fieldNode instanceof Element)) continue;
                    Element field = (Element)fieldNode;
                    if ("name".equals(field.getTagName()) && field.hasChildNodes()) {
                        attr = ((Text)field.getFirstChild()).getData().trim();
                    }
                    if ("value".equals(field.getTagName()) && field.hasChildNodes()) {
                        value = ((Text)field.getFirstChild()).getData();
                    }
                    if (!"final".equals(field.getTagName()) || !field.hasChildNodes()) continue;
                    finalParameter = "true".equals(((Text)field.getFirstChild()).getData());
                }
                if (attr == null) continue;
                if (value != null) {
                    if (!this.finalParameters.contains(attr)) {
                        properties.setProperty(attr, value);
                        if (this.storeResource) {
                            this.updatingResource.put(attr, name.toString());
                        }
                    } else if (!value.equals(properties.getProperty(attr))) {
                        LOG.warn((Object)(name + ":a attempt to override final parameter: " + attr + ";  Ignoring."));
                    }
                }
                if (!finalParameter) continue;
                this.finalParameters.add(attr);
            }
        }
        catch (IOException e) {
            LOG.fatal((Object)("error parsing conf file: " + e));
            throw new RuntimeException(e);
        }
        catch (DOMException e) {
            LOG.fatal((Object)("error parsing conf file: " + e));
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            LOG.fatal((Object)("error parsing conf file: " + e));
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            LOG.fatal((Object)("error parsing conf file: " + e));
            throw new RuntimeException(e);
        }
    }

    public void writeXml(OutputStream out) throws IOException {
        Properties properties = this.getProps();
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element conf = doc.createElement("configuration");
            doc.appendChild(conf);
            conf.appendChild(doc.createTextNode("\n"));
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object object = properties.get(name);
                String value = null;
                if (!(object instanceof String)) continue;
                value = (String)object;
                Element propNode = doc.createElement("property");
                conf.appendChild(propNode);
                Element nameNode = doc.createElement("name");
                nameNode.appendChild(doc.createTextNode(name));
                propNode.appendChild(nameNode);
                Element valueNode = doc.createElement("value");
                valueNode.appendChild(doc.createTextNode(value));
                propNode.appendChild(valueNode);
                conf.appendChild(doc.createTextNode("\n"));
            }
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void dumpConfiguration(Configuration conf, Writer out) throws IOException {
        Configuration config = new Configuration(conf, true);
        config.reloadConfiguration();
        JsonFactory dumpFactory = new JsonFactory();
        JsonGenerator dumpGenerator = dumpFactory.createJsonGenerator(out);
        dumpGenerator.writeStartObject();
        dumpGenerator.writeFieldName("properties");
        dumpGenerator.writeStartArray();
        dumpGenerator.flush();
        for (Map.Entry<Object, Object> item : config.getProps().entrySet()) {
            dumpGenerator.writeStartObject();
            dumpGenerator.writeStringField("key", (String)item.getKey());
            dumpGenerator.writeStringField("value", config.get((String)item.getKey()));
            dumpGenerator.writeBooleanField("isFinal", config.finalParameters.contains(item.getKey()));
            dumpGenerator.writeStringField("resource", config.updatingResource.get(item.getKey()));
            dumpGenerator.writeEndObject();
        }
        dumpGenerator.writeEndArray();
        dumpGenerator.writeEndObject();
        dumpGenerator.flush();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Configuration: ");
        if (this.loadDefaults) {
            this.toString(defaultResources, sb);
            if (this.resources.size() > 0) {
                sb.append(", ");
            }
        }
        this.toString(this.resources, sb);
        return sb.toString();
    }

    private void toString(List resources, StringBuffer sb) {
        ListIterator i = resources.listIterator();
        while (i.hasNext()) {
            if (i.nextIndex() != 0) {
                sb.append(", ");
            }
            sb.append(i.next());
        }
    }

    public synchronized void setQuietMode(boolean quietmode) {
        this.quietmode = quietmode;
    }

    public static void main(String[] args) throws Exception {
        new Configuration().writeXml(System.out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.clear();
        int size2 = WritableUtils.readVInt(in);
        for (int i = 0; i < size2; ++i) {
            this.set(org.apache.hadoop.io.Text.readString(in), org.apache.hadoop.io.Text.readString(in));
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Properties props = this.getProps();
        WritableUtils.writeVInt(out, props.size());
        for (Map.Entry<Object, Object> item : props.entrySet()) {
            org.apache.hadoop.io.Text.writeString(out, (String)item.getKey());
            org.apache.hadoop.io.Text.writeString(out, (String)item.getValue());
        }
    }

    public Map<String, String> getValByRegex(String regex) {
        Pattern p = Pattern.compile(regex);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> item : this.getProps().entrySet()) {
            Matcher m;
            if (!(item.getKey() instanceof String) || !(item.getValue() instanceof String) || !(m = p.matcher((String)item.getKey())).find()) continue;
            result.put((String)item.getKey(), (String)item.getValue());
        }
        return result;
    }

    static {
        ClassLoader cL = Thread.currentThread().getContextClassLoader();
        if (cL == null) {
            cL = Configuration.class.getClassLoader();
        }
        if (cL.getResource("hadoop-site.xml") != null) {
            LOG.warn((Object)"DEPRECATED: hadoop-site.xml found in the classpath. Usage of hadoop-site.xml is deprecated. Instead use core-site.xml, mapred-site.xml and hdfs-site.xml to override properties of core-default.xml, mapred-default.xml and hdfs-default.xml respectively");
        }
        Configuration.addDefaultResource("core-default.xml");
        Configuration.addDefaultResource("core-site.xml");
        varPat = Pattern.compile("\\$\\{[^\\}\\$ ]+\\}");
        MAX_SUBST = 20;
    }

    public static class IntegerRanges {
        List<Range> ranges = new ArrayList<Range>();

        public IntegerRanges() {
        }

        public IntegerRanges(String newValue) {
            StringTokenizer itr = new StringTokenizer(newValue, ",");
            while (itr.hasMoreTokens()) {
                String rng = itr.nextToken().trim();
                String[] parts = rng.split("-", 3);
                if (parts.length < 1 || parts.length > 2) {
                    throw new IllegalArgumentException("integer range badly formed: " + rng);
                }
                Range r = new Range();
                r.start = IntegerRanges.convertToInt(parts[0], 0);
                r.end = parts.length == 2 ? IntegerRanges.convertToInt(parts[1], Integer.MAX_VALUE) : r.start;
                if (r.start > r.end) {
                    throw new IllegalArgumentException("IntegerRange from " + r.start + " to " + r.end + " is invalid");
                }
                this.ranges.add(r);
            }
        }

        private static int convertToInt(String value, int defaultValue) {
            String trim = value.trim();
            if (trim.length() == 0) {
                return defaultValue;
            }
            return Integer.parseInt(trim);
        }

        public boolean isIncluded(int value) {
            for (Range r : this.ranges) {
                if (r.start > value || value > r.end) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            boolean first = true;
            for (Range r : this.ranges) {
                if (first) {
                    first = false;
                } else {
                    result.append(',');
                }
                result.append(r.start);
                result.append('-');
                result.append(r.end);
            }
            return result.toString();
        }

        private static class Range {
            int start;
            int end;

            private Range() {
            }
        }
    }
}

